/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.schema;

import com.google.common.annotations.Beta;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.avro.ImmutableSchema;
import org.apache.avro.Schema;
import org.spf4j.avro.schema.ImmutableCloningVisitor;
import org.spf4j.avro.schema.SchemaVisitor;
import org.spf4j.avro.schema.SchemaVisitorAction;
import org.spf4j.base.CharSequences;
import org.spf4j.ds.IdentityHashSet;

@ParametersAreNonnullByDefault
@Beta
@SuppressFBWarnings(value={"AI_ANNOTATION_ISSUES_NEEDS_NULLABLE"})
public final class Schemas {
    private Schemas() {
    }

    @Nonnull
    public static ImmutableSchema immutable(Schema schema) {
        if (schema instanceof ImmutableSchema) {
            return (ImmutableSchema)schema;
        }
        return Schemas.visit(schema, new ImmutableCloningVisitor(schema, false));
    }

    @Nonnull
    public static ImmutableSchema immutable(Schema schema, boolean withSerializationSignificatAttrsonly) {
        return Schemas.visit(schema, new ImmutableCloningVisitor(schema, withSerializationSignificatAttrsonly));
    }

    public static <T> T visit(Schema start, SchemaVisitor<T> visitor) {
        Object current;
        IdentityHashSet visited = new IdentityHashSet();
        ArrayDeque<Object> dq = new ArrayDeque<Object>();
        dq.addLast(start);
        block13: while ((current = dq.pollLast()) != null) {
            boolean terminate;
            if (current instanceof Supplier) {
                SchemaVisitorAction action = (SchemaVisitorAction)((Object)((Supplier)current).get());
                switch (action) {
                    case CONTINUE: {
                        continue block13;
                    }
                    case SKIP_SUBTREE: {
                        throw new UnsupportedOperationException();
                    }
                    case SKIP_SIBLINGS: {
                        while (dq.getLast() instanceof Schema) {
                            dq.removeLast();
                        }
                        continue block13;
                    }
                    case TERMINATE: {
                        return visitor.get();
                    }
                }
                throw new UnsupportedOperationException("Invalid action " + (Object)((Object)action));
            }
            Schema schema = (Schema)current;
            if (!visited.contains((Object)schema)) {
                Schema.Type type = schema.getType();
                switch (type) {
                    case ARRAY: {
                        terminate = Schemas.visitNonTerminal(visitor, schema, dq, Collections.singletonList(schema.getElementType()));
                        visited.add((Object)schema);
                        break;
                    }
                    case RECORD: {
                        terminate = Schemas.visitNonTerminal(visitor, schema, dq, Lists.transform((List)Lists.reverse((List)schema.getFields()), Schema.Field::schema));
                        visited.add((Object)schema);
                        break;
                    }
                    case UNION: {
                        terminate = Schemas.visitNonTerminal(visitor, schema, dq, schema.getTypes());
                        visited.add((Object)schema);
                        break;
                    }
                    case MAP: {
                        terminate = Schemas.visitNonTerminal(visitor, schema, dq, Collections.singletonList(schema.getValueType()));
                        visited.add((Object)schema);
                        break;
                    }
                    case NULL: 
                    case BOOLEAN: 
                    case BYTES: 
                    case DOUBLE: 
                    case ENUM: 
                    case FIXED: 
                    case FLOAT: 
                    case INT: 
                    case LONG: 
                    case STRING: {
                        terminate = Schemas.visitTerminal(visitor, schema, dq);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Invalid type " + type);
                    }
                }
            } else {
                terminate = Schemas.visitTerminal(visitor, schema, dq);
            }
            if (!terminate) continue;
            return visitor.get();
        }
        return visitor.get();
    }

    private static boolean visitNonTerminal(SchemaVisitor visitor, Schema schema, Deque<Object> dq, Iterable<Schema> itSupp) {
        SchemaVisitorAction action = visitor.visitNonTerminal(schema);
        switch (action) {
            case CONTINUE: {
                dq.addLast(() -> visitor.afterVisitNonTerminal(schema));
                for (Schema child : itSupp) {
                    dq.addLast(child);
                }
                break;
            }
            case SKIP_SUBTREE: {
                dq.addLast(() -> visitor.afterVisitNonTerminal(schema));
                break;
            }
            case SKIP_SIBLINGS: {
                while (!dq.isEmpty() && dq.getLast() instanceof Schema) {
                    dq.removeLast();
                }
                break;
            }
            case TERMINATE: {
                return true;
            }
            default: {
                throw new UnsupportedOperationException("Invalid action " + (Object)((Object)action) + " for " + schema);
            }
        }
        return false;
    }

    private static boolean visitTerminal(SchemaVisitor visitor, Schema schema, Deque<Object> dq) {
        SchemaVisitorAction action = visitor.visitTerminal(schema);
        switch (action) {
            case CONTINUE: {
                break;
            }
            case SKIP_SUBTREE: {
                throw new UnsupportedOperationException("Invalid action " + (Object)((Object)action) + " for " + schema);
            }
            case SKIP_SIBLINGS: {
                Object current;
                while ((current = dq.getLast()) instanceof Schema) {
                }
                dq.addLast(current);
                break;
            }
            case TERMINATE: {
                return true;
            }
            default: {
                throw new UnsupportedOperationException("Invalid action " + (Object)((Object)action) + " for " + schema);
            }
        }
        return false;
    }

    public static boolean isNullableUnion(Schema schema) {
        if (schema.getType() != Schema.Type.UNION) {
            return false;
        }
        for (Schema ss : schema.getTypes()) {
            if (ss.getType() != Schema.Type.NULL) continue;
            return true;
        }
        return false;
    }

    public static Schema getSubSchema(Schema schema, CharSequence path) {
        return Schemas.getSubSchema(schema, path, 0);
    }

    public static Schema getSubSchema(Schema schema, CharSequence path, int at) {
        int length = path.length();
        if (at >= length) {
            return schema;
        }
        int to = CharSequences.indexOf((CharSequence)path, (int)at, (int)length, (char)'.');
        if (to < 0) {
            to = length;
        }
        String part = CharSequences.subSequence((CharSequence)path, (int)at, (int)to).toString().trim();
        switch (schema.getType()) {
            case ARRAY: {
                if ("[]".equals(part)) {
                    if (to == length) {
                        return schema.getElementType();
                    }
                    return Schemas.getSubSchema(schema.getElementType(), path, to + 1);
                }
                throw new IllegalArgumentException("Invalid path " + path + " at " + at + ", " + schema);
            }
            case MAP: {
                if ("{}".equals(part)) {
                    if (to == length) {
                        return schema.getValueType();
                    }
                    return Schemas.getSubSchema(schema.getValueType(), path, to + 1);
                }
                throw new IllegalArgumentException("Invalid path " + path + " at " + at + ", " + schema);
            }
            case RECORD: {
                for (Schema.Field field : schema.getFields()) {
                    if (!part.equals(field.name()) && !field.aliases().contains(part)) continue;
                    if (to == length) {
                        return field.schema();
                    }
                    return Schemas.getSubSchema(field.schema(), path, to + 1);
                }
                throw new IllegalArgumentException("Invalid path " + path + " at " + at + ", " + schema);
            }
        }
        throw new IllegalArgumentException("Invalid path " + path + " at " + at + ", " + schema);
    }

    @Nullable
    public static Schema project(Schema schema, CharSequence ... paths) {
        if (paths.length == 0 || paths.length == 1 && paths[0].length() == 0) {
            return schema;
        }
        switch (schema.getType()) {
            case ARRAY: {
                ArrayList<String> seqs = new ArrayList<String>(paths.length);
                for (CharSequence path : paths) {
                    String part = Schemas.getFirstRef(path);
                    if ("[]".equals(part)) {
                        if (part.length() == path.length()) {
                            return schema;
                        }
                    } else {
                        return null;
                    }
                    seqs.add(part.substring(part.length() + 1));
                }
                if (seqs.isEmpty()) {
                    return null;
                }
                return Schema.createArray((Schema)Schemas.project(schema.getElementType(), seqs.toArray(new CharSequence[seqs.size()])));
            }
            case MAP: {
                ArrayList<String> seqs = new ArrayList<String>(paths.length);
                for (CharSequence path : paths) {
                    String part = Schemas.getFirstRef(path);
                    if (!"{}".equals(part)) continue;
                    if (part.length() == path.length()) {
                        return schema;
                    }
                    seqs.add(part.substring("{}".length() + 1));
                }
                if (seqs.isEmpty()) {
                    return null;
                }
                return Schema.createMap((Schema)Schemas.project(schema.getElementType(), seqs.toArray(new CharSequence[seqs.size()])));
            }
            case RECORD: {
                Schema rec = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError());
                List fields = schema.getFields();
                ArrayList<Schema.Field> nFields = new ArrayList<Schema.Field>(fields.size());
                LinkedList<CharSequence> tPaths = new LinkedList<CharSequence>(Arrays.asList(paths));
                do {
                    Schema.Field extract;
                    if ((extract = Schemas.extract(fields, tPaths)) == null) {
                        return null;
                    }
                    nFields.add(extract);
                } while (!tPaths.isEmpty());
                rec.setFields(nFields);
                return rec;
            }
            case UNION: {
                List types = schema.getTypes();
                ArrayList<Schema> nTypes = new ArrayList<Schema>(types.size());
                for (Schema us : types) {
                    if (us.getType() == Schema.Type.NULL) {
                        nTypes.add(us);
                        continue;
                    }
                    Schema project = Schemas.project(us, paths);
                    if (project == null) continue;
                    nTypes.add(project);
                }
                return Schema.createUnion(nTypes);
            }
        }
        return null;
    }

    private static Schema.Field extract(List<Schema.Field> fields, List<CharSequence> paths) {
        Iterator<CharSequence> iterator = paths.iterator();
        if (iterator.hasNext()) {
            ArrayList<CharSequence> proj = new ArrayList<CharSequence>(2);
            CharSequence path = iterator.next();
            String part = Schemas.getFirstRef(path);
            Schema.Field field = Schemas.getField(part, fields);
            if (field == null) {
                return null;
            }
            iterator.remove();
            if (part.length() == path.length()) {
                proj.add("");
            } else {
                proj.add(path.subSequence(part.length() + 1, path.length()));
            }
            while (iterator.hasNext()) {
                path = iterator.next();
                part = Schemas.getFirstRef(path);
                if (!Schemas.isNamed(part, field)) continue;
                if (part.length() == path.length()) {
                    proj.add("");
                } else {
                    proj.add(path.subSequence(part.length() + 1, path.length()));
                }
                iterator.remove();
            }
            return new Schema.Field(field.name(), Schemas.project(field.schema(), proj.toArray(new CharSequence[proj.size()])), field.doc(), field.defaultVal(), field.order());
        }
        return null;
    }

    @Nullable
    public static Schema.Field getField(String name, List<Schema.Field> fields) {
        for (Schema.Field field : fields) {
            if (!Schemas.isNamed(name, field)) continue;
            return field;
        }
        return null;
    }

    public static boolean isNamed(String name, Schema.Field field) {
        return name.equals(field.name()) || field.aliases().contains(name);
    }

    private static String getFirstRef(CharSequence path) {
        int length = path.length();
        int to = CharSequences.indexOf((CharSequence)path, (int)0, (int)length, (char)'.');
        String part = to < 0 ? path.toString() : path.subSequence(0, to).toString();
        return part;
    }
}

