/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.schema;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.avro.ImmutableSchema;
import org.apache.avro.Schema;
import org.spf4j.avro.schema.SchemaUtils;
import org.spf4j.avro.schema.SchemaVisitor;
import org.spf4j.avro.schema.SchemaVisitorAction;

public final class ImmutableCloningVisitor
implements SchemaVisitor<ImmutableSchema> {
    private final IdentityHashMap<Schema, ImmutableSchema> replace = new IdentityHashMap();
    private final Schema root;
    private final BiConsumer<Schema.Field, Schema.Field> copyField;
    private final BiConsumer<Schema, Schema> copySchema;
    private final boolean copyDocs;

    public ImmutableCloningVisitor(Schema root, boolean serializationSignificatOnly) {
        this(serializationSignificatOnly ? SchemaUtils.FIELD_ESENTIALS : SchemaUtils.FIELD_EVERYTHING, serializationSignificatOnly ? SchemaUtils.SCHEMA_ESENTIALS : SchemaUtils.SCHEMA_EVERYTHING, !serializationSignificatOnly, root);
    }

    public ImmutableCloningVisitor(BiConsumer<Schema.Field, Schema.Field> copyField, BiConsumer<Schema, Schema> copySchema, boolean copyDocs, Schema root) {
        this.copyField = copyField;
        this.copySchema = copySchema;
        this.copyDocs = copyDocs;
        this.root = root;
    }

    @Override
    public SchemaVisitorAction visitTerminal(Schema terminal) {
        Schema newSchema;
        Schema.Type type = terminal.getType();
        switch (type) {
            case RECORD: 
            case ARRAY: 
            case MAP: 
            case UNION: {
                if (!this.replace.containsKey(terminal)) {
                    throw new IllegalStateException("Schema " + terminal + " must be already processed");
                }
                return SchemaVisitorAction.CONTINUE;
            }
            case BOOLEAN: 
            case BYTES: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case NULL: 
            case STRING: {
                newSchema = Schema.create((Schema.Type)type);
                break;
            }
            case ENUM: {
                newSchema = Schema.createEnum((String)terminal.getName(), (String)(this.copyDocs ? terminal.getDoc() : null), (String)terminal.getNamespace(), (List)terminal.getEnumSymbols());
                break;
            }
            case FIXED: {
                newSchema = Schema.createFixed((String)terminal.getName(), (String)(this.copyDocs ? terminal.getDoc() : null), (String)terminal.getNamespace(), (int)terminal.getFixedSize());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported schema " + terminal);
            }
        }
        this.copySchema.accept(terminal, newSchema);
        this.replace.put(terminal, ImmutableSchema.create(newSchema));
        return SchemaVisitorAction.CONTINUE;
    }

    @Override
    public SchemaVisitorAction visitNonTerminal(Schema nt) {
        Schema.Type type = nt.getType();
        if (type == Schema.Type.RECORD) {
            Schema newSchema = Schema.createRecord((String)nt.getName(), (String)(this.copyDocs ? nt.getDoc() : null), (String)nt.getNamespace(), (boolean)nt.isError());
            this.copySchema.accept(nt, newSchema);
            this.replace.put(nt, ImmutableSchema.create(newSchema));
        }
        return SchemaVisitorAction.CONTINUE;
    }

    @Override
    public SchemaVisitorAction afterVisitNonTerminal(Schema nt) {
        Schema newSchema;
        Schema.Type type = nt.getType();
        switch (type) {
            case RECORD: {
                Schema newSchema2 = this.replace.get(nt);
                List fields = nt.getFields();
                ArrayList<Schema.Field> newFields = new ArrayList<Schema.Field>(fields.size());
                for (Schema.Field field : fields) {
                    Schema.Field newField = new Schema.Field(field.name(), (Schema)this.replace.get(field.schema()), this.copyDocs ? field.doc() : null, field.defaultVal(), field.order());
                    this.copyField.accept(field, newField);
                    newFields.add(newField);
                }
                newSchema2.setFields(newFields);
                return SchemaVisitorAction.CONTINUE;
            }
            case UNION: {
                List types = nt.getTypes();
                ArrayList<ImmutableSchema> newTypes = new ArrayList<ImmutableSchema>(types.size());
                for (Schema sch : types) {
                    newTypes.add(this.replace.get(sch));
                }
                newSchema = Schema.createUnion(newTypes);
                break;
            }
            case ARRAY: {
                newSchema = Schema.createArray((Schema)this.replace.get(nt.getElementType()));
                break;
            }
            case MAP: {
                newSchema = Schema.createMap((Schema)this.replace.get(nt.getValueType()));
                break;
            }
            default: {
                throw new IllegalStateException("Illegal type " + type + ", schema " + nt);
            }
        }
        this.copySchema.accept(nt, newSchema);
        this.replace.put(nt, ImmutableSchema.create(newSchema));
        return SchemaVisitorAction.CONTINUE;
    }

    @Override
    public ImmutableSchema get() {
        ImmutableSchema result = this.replace.get(this.root);
        if (result == null) {
            throw new IllegalStateException("Replacement map does not contain " + this.root + ", map " + this.replace);
        }
        return result;
    }

    public String toString() {
        return "UnmodifiableCloningVisitor{replace=" + this.replace + ", root=" + this.root + '}';
    }
}

