/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.csv;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.parsing.JsonGrammarGenerator;
import org.apache.avro.io.parsing.Parser;
import org.apache.avro.io.parsing.Symbol;
import org.apache.avro.util.Utf8;
import org.spf4j.base.Base64;
import org.spf4j.io.csv.CsvWriter;

public final class CsvEncoder
extends Encoder
implements Parser.ActionHandler {
    private final CsvWriter csvWriter;
    private final Parser parser;
    private final Schema writerSchema;
    private boolean firstItem = true;

    public CsvEncoder(CsvWriter csvWriter, Schema writerSchema) throws IOException {
        this.csvWriter = csvWriter;
        this.parser = new Parser(new JsonGrammarGenerator().generate(writerSchema), (Parser.ActionHandler)this);
        if (writerSchema.getType() != Schema.Type.ARRAY) {
            throw new IllegalArgumentException("schema must be an array: " + writerSchema);
        }
        if (writerSchema.getElementType().getType() != Schema.Type.RECORD) {
            throw new IllegalArgumentException("schema  array element must be record: " + writerSchema);
        }
        this.writerSchema = writerSchema;
    }

    public void writeHeader() throws IOException {
        this.writeHeader("", this.writerSchema.getElementType());
        this.csvWriter.writeEol();
    }

    private void writeHeader(String prefix, Schema rowSchema) throws IOException {
        block8: for (Schema.Field field : rowSchema.getFields()) {
            Schema schema = field.schema();
            Schema.Type type = schema.getType();
            String name = prefix + field.name();
            switch (type) {
                case ARRAY: 
                case MAP: {
                    throw new UnsupportedOperationException(type + " unsupported in CSV row" + rowSchema);
                }
                case UNION: {
                    this.csvWriter.writeElement((CharSequence)(name + ".type"));
                    for (Schema us : schema.getTypes()) {
                        switch (us.getType()) {
                            case ARRAY: 
                            case RECORD: 
                            case MAP: {
                                throw new UnsupportedOperationException(type + " unsupported in CSV row union" + rowSchema);
                            }
                        }
                    }
                    this.csvWriter.writeElement((CharSequence)name);
                    continue block8;
                }
                case RECORD: {
                    this.writeHeader(name + '.', schema);
                    continue block8;
                }
            }
            this.csvWriter.writeElement((CharSequence)name);
        }
    }

    public void writeNull() throws IOException {
        this.parser.advance(Symbol.NULL);
        this.csvWriter.writeElement((CharSequence)"");
    }

    public void writeBoolean(boolean bln) throws IOException {
        this.parser.advance(Symbol.BOOLEAN);
        this.csvWriter.writeElement((CharSequence)Boolean.toString(bln));
    }

    public void writeInt(int i) throws IOException {
        this.parser.advance(Symbol.INT);
        this.csvWriter.writeElement((CharSequence)Integer.toString(i));
    }

    public void writeLong(long l) throws IOException {
        this.parser.advance(Symbol.LONG);
        this.csvWriter.writeElement((CharSequence)Long.toString(l));
    }

    public void writeFloat(float f) throws IOException {
        this.parser.advance(Symbol.FLOAT);
        this.csvWriter.writeElement((CharSequence)Float.toString(f));
    }

    public void writeDouble(double d) throws IOException {
        this.parser.advance(Symbol.DOUBLE);
        this.csvWriter.writeElement((CharSequence)Double.toString(d));
    }

    public void writeString(Utf8 utf8) throws IOException {
        this.parser.advance(Symbol.STRING);
        this.csvWriter.writeElement((CharSequence)utf8);
    }

    public void writeBytes(ByteBuffer bb) throws IOException {
        this.parser.advance(Symbol.BYTES);
        int position = bb.position();
        this.csvWriter.writeElement((CharSequence)Base64.encodeBase64((byte[])bb.array(), (int)(bb.arrayOffset() + position), (int)(bb.limit() - position)));
    }

    public void writeBytes(byte[] bytes, int i, int length) throws IOException {
        this.parser.advance(Symbol.BYTES);
        this.csvWriter.writeElement((CharSequence)Base64.encodeBase64((byte[])bytes, (int)i, (int)length));
    }

    public void writeFixed(byte[] bytes, int i, int length) throws IOException {
        this.parser.advance(Symbol.FIXED);
        this.csvWriter.writeElement((CharSequence)Base64.encodeBase64((byte[])bytes, (int)i, (int)length));
    }

    public void writeEnum(int e) throws IOException {
        this.parser.advance(Symbol.ENUM);
        Symbol.EnumLabelsAction top = (Symbol.EnumLabelsAction)this.parser.popSymbol();
        if (e < 0 || e >= top.size) {
            throw new AvroTypeException("Enumeration out of range: max is " + top.size + " but received " + e);
        }
        this.csvWriter.writeElement((CharSequence)top.getLabel(e));
    }

    public void writeArrayStart() throws IOException {
        this.firstItem = true;
        this.parser.advance(Symbol.ARRAY_START);
    }

    public void writeArrayEnd() throws IOException {
        this.parser.advance(Symbol.ITEM_END);
        this.parser.advance(Symbol.ARRAY_END);
    }

    public void writeMapStart() {
        throw new UnsupportedOperationException();
    }

    public void writeMapEnd() {
        throw new UnsupportedOperationException();
    }

    public void writeIndex(int unionIndex) throws IOException {
        this.parser.advance(Symbol.UNION);
        Symbol.Alternative top = (Symbol.Alternative)this.parser.popSymbol();
        Symbol symbol = top.getSymbol(unionIndex);
        this.csvWriter.writeElement((CharSequence)top.getLabel(unionIndex));
        this.parser.pushSymbol(Symbol.UNION_END);
        this.parser.pushSymbol(symbol);
    }

    public void flush() throws IOException {
        this.csvWriter.flush();
    }

    @Nullable
    public Symbol doAction(Symbol symbol, Symbol symbol1) {
        return null;
    }

    public void setItemCount(long l) {
    }

    public void startItem() throws IOException {
        if (!this.firstItem) {
            this.parser.advance(Symbol.ITEM_END);
            this.csvWriter.writeEol();
        } else {
            this.firstItem = false;
        }
    }

    public String toString() {
        return "CsvEncoder{csvWriter=" + this.csvWriter + ", parser=" + this.parser + ", writerSchema=" + this.writerSchema + ", firstItem=" + this.firstItem + '}';
    }
}

