/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.csv;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.ParsingDecoder;
import org.apache.avro.io.parsing.JsonGrammarGenerator;
import org.apache.avro.io.parsing.Symbol;
import org.apache.avro.util.Utf8;
import org.spf4j.avro.DecodedSchema;
import org.spf4j.avro.schema.Schemas;
import org.spf4j.base.Base64;
import org.spf4j.base.CharSequences;
import org.spf4j.io.Csv;
import org.spf4j.io.csv.CsvParseException;
import org.spf4j.io.csv.CsvReader;

public final class CsvDecoder
extends ParsingDecoder {
    private final CsvReader csvReader;

    public CsvDecoder(CsvReader csvReader, Schema readerSchema) throws IOException {
        super(new JsonGrammarGenerator().generate(readerSchema));
        this.csvReader = csvReader;
        try {
            if (csvReader.current() == null) {
                csvReader.next();
            }
        }
        catch (CsvParseException ex) {
            throw new AvroRuntimeException((Throwable)ex);
        }
    }

    public void skipHeader() throws IOException, CsvParseException {
        this.csvReader.skipRow();
    }

    public void readNull() throws IOException {
        this.parser.advance(Symbol.NULL);
        CsvReader.TokenType tok = this.csvReader.current();
        if (tok == CsvReader.TokenType.ELEMENT) {
            boolean notNull = !CharSequences.equals((CharSequence)"", (CharSequence)this.csvReader.getElement());
            this.parseNextCsv();
            if (notNull) {
                throw new AvroTypeException("Expected null, not " + this.csvReader.getElement());
            }
        } else {
            throw new AvroTypeException("Expected boolean, not " + tok);
        }
    }

    public boolean readBoolean() throws IOException {
        this.parser.advance(Symbol.BOOLEAN);
        CsvReader.TokenType tok = this.csvReader.current();
        if (tok == CsvReader.TokenType.ELEMENT) {
            boolean result = CharSequences.equals((CharSequence)"true", (CharSequence)this.csvReader.getElement());
            this.parseNextCsv();
            return result;
        }
        throw new AvroTypeException("Expected boolean, not " + tok);
    }

    private void parseNextCsv() throws IOException {
        try {
            this.csvReader.next();
        }
        catch (CsvParseException ex) {
            throw new AvroRuntimeException((Throwable)ex);
        }
    }

    public int readInt() throws IOException {
        this.parser.advance(Symbol.INT);
        CsvReader.TokenType tok = this.csvReader.current();
        if (tok == CsvReader.TokenType.ELEMENT) {
            int result = CharSequences.parseInt((CharSequence)this.csvReader.getElement());
            this.parseNextCsv();
            return result;
        }
        throw new AvroTypeException("Expected int, not " + tok);
    }

    public long readLong() throws IOException {
        this.parser.advance(Symbol.LONG);
        CsvReader.TokenType tok = this.csvReader.current();
        if (tok == CsvReader.TokenType.ELEMENT) {
            long result = CharSequences.parseLong((CharSequence)this.csvReader.getElement());
            this.parseNextCsv();
            return result;
        }
        throw new AvroTypeException("Expected long, not " + tok);
    }

    public float readFloat() throws IOException {
        this.parser.advance(Symbol.FLOAT);
        CsvReader.TokenType tok = this.csvReader.current();
        if (tok == CsvReader.TokenType.ELEMENT) {
            float result = Float.parseFloat(this.csvReader.getElement().toString());
            this.parseNextCsv();
            return result;
        }
        throw new AvroTypeException("Expected float, not " + tok);
    }

    public double readDouble() throws IOException {
        this.parser.advance(Symbol.DOUBLE);
        CsvReader.TokenType tok = this.csvReader.current();
        if (tok == CsvReader.TokenType.ELEMENT) {
            double result = Double.parseDouble(this.csvReader.getElement().toString());
            this.parseNextCsv();
            return result;
        }
        throw new AvroTypeException("Expected double, not " + tok);
    }

    public Utf8 readString(Utf8 utf8) throws IOException {
        this.parser.advance(Symbol.STRING);
        CsvReader.TokenType tok = this.csvReader.current();
        if (tok == CsvReader.TokenType.ELEMENT) {
            Utf8 result = new Utf8(this.csvReader.getElement().toString());
            this.parseNextCsv();
            return result;
        }
        throw new AvroTypeException("Expected string, not " + tok);
    }

    public String readString() throws IOException {
        this.parser.advance(Symbol.STRING);
        CsvReader.TokenType tok = this.csvReader.current();
        if (tok == CsvReader.TokenType.ELEMENT) {
            String result = this.csvReader.getElement().toString();
            this.parseNextCsv();
            return result;
        }
        throw new AvroTypeException("Expected string, not " + tok);
    }

    public void skipString() throws IOException {
        this.parser.advance(Symbol.STRING);
        CsvReader.TokenType tok = this.csvReader.current();
        if (tok != CsvReader.TokenType.ELEMENT) {
            throw new AvroTypeException("Expected string, not " + tok);
        }
        this.parseNextCsv();
    }

    public ByteBuffer readBytes(ByteBuffer bb) throws IOException {
        this.parser.advance(Symbol.BYTES);
        CsvReader.TokenType tok = this.csvReader.current();
        if (tok == CsvReader.TokenType.ELEMENT) {
            ByteBuffer result = ByteBuffer.wrap(Base64.decodeBase64((CharSequence)this.csvReader.getElement()));
            this.parseNextCsv();
            return result;
        }
        throw new AvroTypeException("Expected string, not " + tok);
    }

    public void skipBytes() throws IOException {
        this.parser.advance(Symbol.BYTES);
        CsvReader.TokenType tok = this.csvReader.current();
        if (tok != CsvReader.TokenType.ELEMENT) {
            this.parseNextCsv();
            throw new AvroTypeException("Expected bytes, not " + tok);
        }
    }

    public void readFixed(byte[] bytes, int i, int nrBytes) throws IOException {
        this.parser.advance(Symbol.FIXED);
        CsvReader.TokenType tok = this.csvReader.current();
        if (tok == CsvReader.TokenType.ELEMENT) {
            CharSequence text = this.csvReader.getElement();
            int nrB = Base64.decodeInto((CharSequence)text, (int)0, (int)text.length(), (byte[])bytes, (int)i);
            if (nrB != nrBytes) {
                throw new AvroTypeException("invalid fixed lenth " + nrB + " into " + Arrays.toString(bytes));
            }
        } else {
            throw new AvroTypeException("Expected string, not " + tok);
        }
        this.parseNextCsv();
    }

    public void skipFixed(int i) throws IOException {
        this.parser.advance(Symbol.FIXED);
        CsvReader.TokenType tok = this.csvReader.current();
        if (tok != CsvReader.TokenType.ELEMENT) {
            throw new AvroTypeException("Expected fixed, not " + tok);
        }
        this.parseNextCsv();
    }

    public int readEnum() throws IOException {
        this.parser.advance(Symbol.ENUM);
        Symbol.EnumLabelsAction top = (Symbol.EnumLabelsAction)this.parser.popSymbol();
        CsvReader.TokenType tok = this.csvReader.current();
        if (tok == CsvReader.TokenType.ELEMENT) {
            String symb = this.csvReader.getElement().toString();
            int n = top.findLabel(symb);
            if (n >= 0) {
                this.parseNextCsv();
                return n;
            }
            throw new AvroTypeException("Invalid enum symbol " + symb);
        }
        throw new AvroTypeException("Expected string, not " + tok);
    }

    public long readArrayStart() throws IOException {
        CsvReader.TokenType current = this.csvReader.current();
        if (current == null) {
            throw new IllegalStateException("cannot be at the beginning of " + this.csvReader);
        }
        this.parser.advance(Symbol.ARRAY_START);
        if (current == CsvReader.TokenType.ELEMENT) {
            return 1L;
        }
        return 0L;
    }

    public long arrayNext() throws IOException {
        this.parser.advance(Symbol.ITEM_END);
        CsvReader.TokenType current = this.csvReader.current();
        if (current == null) {
            throw new IllegalStateException("cannot be at the beginning of " + this.csvReader);
        }
        if (current == CsvReader.TokenType.END_ROW) {
            try {
                current = this.csvReader.next();
            }
            catch (CsvParseException ex) {
                throw new AvroRuntimeException((Throwable)ex);
            }
        }
        if (current == CsvReader.TokenType.ELEMENT) {
            return 1L;
        }
        return 0L;
    }

    public long skipArray() throws IOException {
        long i = 0L;
        while (this.csvReader.current() != CsvReader.TokenType.END_DOCUMENT) {
            if (this.csvReader.current() == CsvReader.TokenType.END_ROW) {
                ++i;
            }
            try {
                this.csvReader.next();
            }
            catch (CsvParseException ex) {
                throw new AvroRuntimeException((Throwable)ex);
            }
        }
        this.parser.advance(Symbol.ARRAY_START);
        this.parser.advance(Symbol.ARRAY_END);
        return i;
    }

    public long readMapStart() {
        throw new UnsupportedOperationException();
    }

    public long mapNext() {
        throw new UnsupportedOperationException();
    }

    public long skipMap() {
        throw new UnsupportedOperationException();
    }

    public int readIndex() throws IOException {
        this.parser.advance(Symbol.UNION);
        Symbol.Alternative a = (Symbol.Alternative)this.parser.popSymbol();
        String label = this.csvReader.getElement().toString();
        this.parser.pushSymbol(Symbol.UNION_END);
        int n = a.findLabel(label);
        if (n < 0) {
            throw new AvroTypeException("Unknown union branch " + label);
        }
        this.parser.pushSymbol(a.getSymbol(n));
        this.parseNextCsv();
        return n;
    }

    protected void skipFixed() throws IOException {
        this.parser.advance(Symbol.FIXED);
        CsvReader.TokenType tok = this.csvReader.current();
        if (tok != CsvReader.TokenType.ELEMENT) {
            throw new AvroTypeException("Expected fixed, not " + tok);
        }
        this.parseNextCsv();
    }

    @Nullable
    public Symbol doAction(Symbol symbol, Symbol symbol1) {
        return null;
    }

    public String toString() {
        return "CsvDecoder{csvReader=" + this.csvReader + '}';
    }

    private static String validateName(CharSequence name) {
        int length = name.length();
        if (length == 0) {
            return "_";
        }
        StringBuilder result = null;
        char first = name.charAt(0);
        if (first != '_' && !Character.isLetter(first)) {
            result = new StringBuilder(length);
            result.append('_');
        }
        for (int i = 1; i < length; ++i) {
            char c = name.charAt(i);
            if (c != '_' && !Character.isLetterOrDigit(c)) {
                if (result == null) {
                    result = new StringBuilder(length);
                    result.append(name, 0, i);
                }
                result.append('_');
                continue;
            }
            if (result == null) continue;
            result.append(c);
        }
        return result == null ? name.toString() : result.toString();
    }

    public static DecodedSchema tryDecodeSchema(InputStream is, @Nullable Schema readerSchema) throws IOException {
        try {
            Schema record;
            CsvReader reader = Csv.CSV.readerILEL((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
            if (readerSchema == null) {
                record = Schema.createRecord((String)"DynCsv", (String)"Infered schema", (String)"org.spf4j.avro", (boolean)false);
                ArrayList bfields = new ArrayList();
                reader.readRow(cs -> bfields.add(new Schema.Field(CsvDecoder.validateName(cs), Schema.create((Schema.Type)Schema.Type.STRING), cs.toString(), null)));
                record.setFields(bfields);
            } else {
                ArrayList list = new ArrayList();
                reader.readRow(cs -> list.add(cs.toString()));
                record = Schemas.project(readerSchema.getElementType(), list.toArray(new CharSequence[list.size()]));
            }
            Schema arraySchema = Schema.createArray((Schema)record);
            return new DecodedSchema(arraySchema, (Decoder)new CsvDecoder(reader, arraySchema));
        }
        catch (CsvParseException ex) {
            throw new RuntimeException(ex);
        }
    }
}

