/*
 * Decompiled with CFR 0.152.
 */
package org.specsy.junit5;

import org.junit.gen5.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.gen5.engine.support.descriptor.EngineDescriptor;
import org.specsy.core.Path;

public class ClassTestDescriptor
extends AbstractTestDescriptor {
    private final Class<?> testClass;
    private final Path pathToExecute;

    public ClassTestDescriptor(EngineDescriptor parent, Class<?> testClass) {
        this(parent, testClass, Path.ROOT);
    }

    public ClassTestDescriptor(EngineDescriptor parent, Class<?> testClass, Path pathToExecute) {
        super(parent.getUniqueId() + ":" + testClass.getName());
        this.testClass = testClass;
        this.pathToExecute = pathToExecute;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Path getPathToExecute() {
        return this.pathToExecute;
    }

    public String getName() {
        return this.testClass.getName();
    }

    public String getDisplayName() {
        return this.testClass.getSimpleName();
    }

    public boolean isTest() {
        return true;
    }

    public boolean isContainer() {
        return true;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "(" + this.getName() + ")";
    }
}

