/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.facade;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonarsource.scanner.lib.ScannerEngineFacade;
import org.sonarsource.scanner.lib.internal.facade.Dirs;
import org.sonarsource.scanner.lib.internal.facade.forked.JreCacheHit;

public abstract class AbstractScannerEngineFacade
implements ScannerEngineFacade {
    private final Map<String, String> bootstrapProperties;
    private final boolean isSonarQubeCloud;
    private final String serverVersion;
    private final boolean wasEngineCacheHit;
    private final JreCacheHit wasJreCacheHit;

    protected AbstractScannerEngineFacade(Map<String, String> bootstrapProperties, boolean isSonarQubeCloud, @Nullable String serverVersion, boolean wasEngineCacheHit, @Nullable JreCacheHit wasJreCacheHit) {
        this.bootstrapProperties = bootstrapProperties;
        this.isSonarQubeCloud = isSonarQubeCloud;
        this.serverVersion = serverVersion;
        this.wasEngineCacheHit = wasEngineCacheHit;
        this.wasJreCacheHit = wasJreCacheHit;
    }

    @Override
    public String getServerVersion() {
        if (this.isSonarQubeCloud) {
            throw new UnsupportedOperationException("Server version is not available for SonarQube Cloud.");
        }
        return this.serverVersion;
    }

    @Override
    public boolean isSonarQubeCloud() {
        return this.isSonarQubeCloud;
    }

    @Override
    public boolean analyze(Map<String, String> analysisProps) {
        HashMap<String, String> allProps = new HashMap<String, String>();
        allProps.putAll(this.bootstrapProperties);
        allProps.putAll(analysisProps);
        AbstractScannerEngineFacade.initAnalysisProperties(allProps);
        this.addStatsProperties(allProps);
        return this.doAnalyze(allProps);
    }

    private void addStatsProperties(Map<String, String> allProps) {
        if (this.wasJreCacheHit != null) {
            allProps.put("sonar.scanner.wasJreCacheHit", this.wasJreCacheHit.name());
        }
        allProps.put("sonar.scanner.wasEngineCacheHit", String.valueOf(this.wasEngineCacheHit));
    }

    protected abstract boolean doAnalyze(Map<String, String> var1);

    private static void initAnalysisProperties(Map<String, String> p) {
        new Dirs().init(p);
    }

    @Override
    public Map<String, String> getBootstrapProperties() {
        return this.bootstrapProperties;
    }
}

