/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.endpoint;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.sonarsource.scanner.lib.internal.MessageException;
import org.sonarsource.scanner.lib.internal.endpoint.OfficialSonarQubeCloudInstance;
import org.sonarsource.scanner.lib.internal.endpoint.ScannerEndpoint;
import org.sonarsource.scanner.lib.internal.endpoint.SonarQubeServer;

public class ScannerEndpointResolver {
    private ScannerEndpointResolver() {
    }

    public static ScannerEndpoint resolveEndpoint(Map<String, String> properties) {
        if (properties.containsKey("sonar.host.url")) {
            return ScannerEndpointResolver.resolveEndpointFromSonarHostUrl(properties);
        }
        return ScannerEndpointResolver.resolveSonarQubeCloudEndpoint(properties);
    }

    private static ScannerEndpoint resolveSonarQubeCloudEndpoint(Map<String, String> properties) {
        boolean hasCloudUrl = properties.containsKey("sonar.scanner.sonarcloudUrl");
        if (hasCloudUrl) {
            return ScannerEndpointResolver.resolveCustomSonarQubeCloudEndpoint(properties);
        }
        ScannerEndpointResolver.failIfApiEndpointAloneDefined(properties);
        String regionCode = properties.get("sonar.region");
        return OfficialSonarQubeCloudInstance.fromRegionCode(regionCode).orElseThrow(() -> new MessageException(String.format("Invalid region '%s'. Valid regions are: %s. Please check the '%s' property or the '%s' environment variable.", regionCode, StringUtils.join((Iterable)OfficialSonarQubeCloudInstance.getRegionCodesWithoutGlobal().stream().map(r -> "'" + r + "'").collect(Collectors.toList()), (String)", "), "sonar.region", "SONAR_REGION"))).getEndpoint();
    }

    private static void failIfApiEndpointAloneDefined(Map<String, String> properties) {
        boolean hasApiUrl = properties.containsKey("sonar.scanner.apiBaseUrl");
        if (hasApiUrl) {
            throw new MessageException(String.format("Defining '%s' without '%s' is not supported.", "sonar.scanner.apiBaseUrl", "sonar.scanner.sonarcloudUrl"));
        }
    }

    private static ScannerEndpoint resolveCustomSonarQubeCloudEndpoint(Map<String, String> properties) {
        boolean hasApiUrl = properties.containsKey("sonar.scanner.apiBaseUrl");
        Optional<ScannerEndpoint> maybeCloudInstance = ScannerEndpointResolver.maybeResolveOfficialSonarQubeCloud(properties, "sonar.scanner.sonarcloudUrl");
        if (maybeCloudInstance.isPresent()) {
            return maybeCloudInstance.get();
        }
        if (!hasApiUrl) {
            throw new MessageException(String.format("Defining a custom '%s' without providing '%s' is not supported.", "sonar.scanner.sonarcloudUrl", "sonar.scanner.apiBaseUrl"));
        }
        return new ScannerEndpoint(properties.get("sonar.scanner.sonarcloudUrl"), properties.get("sonar.scanner.apiBaseUrl"), true, null);
    }

    private static MessageException inconsistentUrlAndRegion(String prop2) {
        return new MessageException(String.format("Inconsistent values for properties '%s' and '%s'. Please only specify one of the two properties.", "sonar.region", prop2));
    }

    private static ScannerEndpoint resolveEndpointFromSonarHostUrl(Map<String, String> properties) {
        return ScannerEndpointResolver.maybeResolveOfficialSonarQubeCloud(properties, "sonar.host.url").orElse(new SonarQubeServer(properties.get("sonar.host.url")));
    }

    private static Optional<ScannerEndpoint> maybeResolveOfficialSonarQubeCloud(Map<String, String> properties, String urlPropName) {
        Optional<OfficialSonarQubeCloudInstance> maybeCloudInstance = OfficialSonarQubeCloudInstance.fromWebEndpoint(properties.get(urlPropName));
        boolean hasRegion = properties.containsKey("sonar.region");
        if (maybeCloudInstance.isPresent()) {
            if (hasRegion) {
                if (OfficialSonarQubeCloudInstance.fromRegionCode(properties.get("sonar.region")).filter(maybeCloudInstance.get()::equals).isEmpty()) {
                    throw ScannerEndpointResolver.inconsistentUrlAndRegion(urlPropName);
                }
            }
            return Optional.of(maybeCloudInstance.get().getEndpoint());
        }
        if (hasRegion) {
            throw ScannerEndpointResolver.inconsistentUrlAndRegion(urlPropName);
        }
        return Optional.empty();
    }
}

