/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.lib.ScannerEngineBootstrapResult;
import org.sonarsource.scanner.lib.ScannerEngineFacade;
import org.sonarsource.scanner.lib.internal.FailedBootstrap;
import org.sonarsource.scanner.lib.internal.MessageException;
import org.sonarsource.scanner.lib.internal.SuccessfulBootstrap;
import org.sonarsource.scanner.lib.internal.cache.FileCache;
import org.sonarsource.scanner.lib.internal.endpoint.ScannerEndpoint;
import org.sonarsource.scanner.lib.internal.endpoint.ScannerEndpointResolver;
import org.sonarsource.scanner.lib.internal.facade.forked.NewScannerEngineFacade;
import org.sonarsource.scanner.lib.internal.facade.forked.ScannerEngineLauncher;
import org.sonarsource.scanner.lib.internal.facade.forked.ScannerEngineLauncherFactory;
import org.sonarsource.scanner.lib.internal.facade.inprocess.InProcessScannerEngineFacade;
import org.sonarsource.scanner.lib.internal.facade.inprocess.IsolatedLauncherFactory;
import org.sonarsource.scanner.lib.internal.facade.simulation.SimulationScannerEngineFacade;
import org.sonarsource.scanner.lib.internal.http.HttpConfig;
import org.sonarsource.scanner.lib.internal.http.HttpException;
import org.sonarsource.scanner.lib.internal.http.ScannerHttpClient;
import org.sonarsource.scanner.lib.internal.http.ssl.CertificateStore;
import org.sonarsource.scanner.lib.internal.util.ArchResolver;
import org.sonarsource.scanner.lib.internal.util.OsResolver;
import org.sonarsource.scanner.lib.internal.util.Paths2;
import org.sonarsource.scanner.lib.internal.util.System2;
import org.sonarsource.scanner.lib.internal.util.VersionUtils;

public class ScannerEngineBootstrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ScannerEngineBootstrapper.class);
    static final String SQ_VERSION_NEW_BOOTSTRAPPING = "10.6";
    static final String SQ_VERSION_TOKEN_AUTHENTICATION = "10.0";
    private final IsolatedLauncherFactory launcherFactory;
    private final ScannerEngineLauncherFactory scannerEngineLauncherFactory;
    private final Map<String, String> bootstrapProperties = new HashMap<String, String>();
    private final ScannerHttpClient scannerHttpClient;
    private final System2 system;

    ScannerEngineBootstrapper(String app, String version, System2 system, ScannerHttpClient scannerHttpClient, IsolatedLauncherFactory launcherFactory, ScannerEngineLauncherFactory scannerEngineLauncherFactory) {
        this.system = system;
        this.scannerHttpClient = scannerHttpClient;
        this.launcherFactory = launcherFactory;
        this.scannerEngineLauncherFactory = scannerEngineLauncherFactory;
        this.setBootstrapProperty("sonar.scanner.app", app).setBootstrapProperty("sonar.scanner.appVersion", version);
    }

    public static ScannerEngineBootstrapper create(String app, String version) {
        System2 system = new System2();
        return new ScannerEngineBootstrapper(app, version, system, new ScannerHttpClient(), new IsolatedLauncherFactory(), new ScannerEngineLauncherFactory(system));
    }

    public ScannerEngineBootstrapper addBootstrapProperties(Map<String, String> p) {
        this.bootstrapProperties.putAll(p);
        return this;
    }

    public ScannerEngineBootstrapper setBootstrapProperty(String key, String value) {
        this.bootstrapProperties.put(key, value);
        return this;
    }

    public ScannerEngineBootstrapResult bootstrap() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scanner max available memory: {}", (Object)FileUtils.byteCountToDisplaySize((long)Runtime.getRuntime().maxMemory()));
        }
        ScannerEndpoint endpoint = ScannerEndpointResolver.resolveEndpoint(this.bootstrapProperties);
        this.initBootstrapDefaultValues(endpoint);
        Map<String, String> immutableProperties = Map.copyOf(this.bootstrapProperties);
        Path sonarUserHome = ScannerEngineBootstrapper.resolveSonarUserHome(immutableProperties);
        HttpConfig httpConfig = new HttpConfig(immutableProperties, sonarUserHome, this.system);
        boolean isSonarQubeCloud = endpoint.isSonarQubeCloud();
        boolean isSimulation = immutableProperties.containsKey("sonar.scanner.internal.dumpToFile");
        FileCache fileCache = FileCache.create(sonarUserHome);
        if (isSimulation) {
            String serverVersion = immutableProperties.getOrDefault("sonar.scanner.internal.sqVersion", "9.9");
            return new SuccessfulBootstrap(new SimulationScannerEngineFacade(immutableProperties, isSonarQubeCloud, serverVersion));
        }
        try {
            this.scannerHttpClient.init(httpConfig);
            if (isSonarQubeCloud) {
                return this.bootstrapCloud(fileCache, immutableProperties, httpConfig, endpoint);
            }
            return this.bootstrapServer(fileCache, immutableProperties, httpConfig);
        }
        catch (MessageException e) {
            return ScannerEngineBootstrapper.handleException(e);
        }
    }

    private ScannerEngineBootstrapResult bootstrapCloud(FileCache fileCache, Map<String, String> immutableProperties, HttpConfig httpConfig, ScannerEndpoint endpoint) {
        endpoint.getRegionLabel().ifPresentOrElse(region -> LOG.info("Communicating with SonarQube Cloud ({} region)", region), () -> LOG.info("Communicating with SonarQube Cloud"));
        ScannerEngineFacade scannerFacade = this.buildNewFacade(fileCache, immutableProperties, httpConfig, (launcher, adaptedProperties) -> NewScannerEngineFacade.forSonarQubeCloud(adaptedProperties, launcher));
        return new SuccessfulBootstrap(scannerFacade);
    }

    private ScannerEngineBootstrapResult bootstrapServer(FileCache fileCache, Map<String, String> immutableProperties, HttpConfig httpConfig) {
        ScannerEngineFacade scannerFacade;
        String serverVersion = ScannerEngineBootstrapper.getServerVersion(this.scannerHttpClient);
        String serverLabel = ScannerEngineBootstrapper.guessServerLabelFromVersion(serverVersion);
        LOG.info("Communicating with {} {}", (Object)serverLabel, (Object)serverVersion);
        if (VersionUtils.isAtLeastIgnoringQualifier(serverVersion, SQ_VERSION_TOKEN_AUTHENTICATION) && Objects.nonNull(httpConfig.getLogin())) {
            LOG.warn("Use of '{}' property has been deprecated in favor of '{}' (or the env variable alternative '{}'). Please use the latter when passing a token.", new Object[]{"sonar.login", "sonar.token", "SONAR_TOKEN"});
        }
        if (VersionUtils.isAtLeastIgnoringQualifier(serverVersion, SQ_VERSION_NEW_BOOTSTRAPPING)) {
            scannerFacade = this.buildNewFacade(fileCache, immutableProperties, httpConfig, (launcher, adaptedProperties) -> NewScannerEngineFacade.forSonarQubeServer(adaptedProperties, launcher, serverVersion));
        } else {
            IsolatedLauncherFactory.IsolatedLauncherAndClassloader launcher2 = this.launcherFactory.createLauncher(this.scannerHttpClient, fileCache);
            Map<String, String> adaptedProperties2 = this.adaptDeprecatedPropertiesForInProcessBootstrapping(immutableProperties, httpConfig);
            scannerFacade = new InProcessScannerEngineFacade(adaptedProperties2, launcher2, false, serverVersion);
        }
        return new SuccessfulBootstrap(scannerFacade);
    }

    static String guessServerLabelFromVersion(String serverVersion) {
        if (VersionUtils.compareMajor(serverVersion, 10) <= 0 || VersionUtils.compareMajor(serverVersion, 2025) >= 0) {
            return "SonarQube Server";
        }
        return "SonarQube Community Build";
    }

    private ScannerEngineFacade buildNewFacade(FileCache fileCache, Map<String, String> immutableProperties, HttpConfig httpConfig, BiFunction<ScannerEngineLauncher, Map<String, String>, ScannerEngineFacade> facadeFactory) {
        ScannerEngineLauncher launcher = this.scannerEngineLauncherFactory.createLauncher(this.scannerHttpClient, fileCache, immutableProperties);
        Map<String, String> adaptedProperties = ScannerEngineBootstrapper.adaptSslPropertiesToScannerProperties(immutableProperties, httpConfig);
        return facadeFactory.apply(launcher, adaptedProperties);
    }

    private static ScannerEngineBootstrapResult handleException(MessageException e) {
        StringBuilder message = new StringBuilder(e.getMessage());
        if (e.getCause() instanceof HttpException) {
            String helpMessage;
            HttpException httpEx = (HttpException)e.getCause();
            int code = httpEx.getCode();
            if (code == 401 || code == 403) {
                helpMessage = "Please check the property sonar.token or the environment variable SONAR_TOKEN.";
                message.append(". ").append(helpMessage);
            }
            if (code == 407) {
                helpMessage = "Please check the properties sonar.scanner.proxyUser and sonar.scanner.proxyPassword.";
                message.append(". ").append(helpMessage);
            }
        }
        ScannerEngineBootstrapper.logWithStacktraceOnlyIfDebug(message.toString(), e);
        return new FailedBootstrap();
    }

    private static void logWithStacktraceOnlyIfDebug(String message, Throwable t) {
        if (LOG.isDebugEnabled()) {
            LOG.error(message, t);
        } else {
            LOG.error(message);
        }
    }

    Map<String, String> adaptDeprecatedPropertiesForInProcessBootstrapping(Map<String, String> properties, HttpConfig httpConfig) {
        CertificateStore trustStore;
        Proxy proxy;
        HashMap<String, String> adaptedProperties = new HashMap<String, String>(properties);
        if (!adaptedProperties.containsKey("sonar.ws.timeout")) {
            adaptedProperties.put("sonar.ws.timeout", "" + httpConfig.getSocketTimeout().get(ChronoUnit.SECONDS));
        }
        if ((proxy = httpConfig.getProxy()) != null) {
            this.setSystemPropertyIfNotAlreadySet("http.proxyHost", ((InetSocketAddress)proxy.address()).getHostString());
            this.setSystemPropertyIfNotAlreadySet("https.proxyHost", ((InetSocketAddress)proxy.address()).getHostString());
            this.setSystemPropertyIfNotAlreadySet("http.proxyPort", String.valueOf(((InetSocketAddress)proxy.address()).getPort()));
            this.setSystemPropertyIfNotAlreadySet("https.proxyPort", String.valueOf(((InetSocketAddress)proxy.address()).getPort()));
        }
        this.setSystemPropertyIfNotAlreadySet("http.proxyUser", httpConfig.getProxyUser());
        this.setSystemPropertyIfNotAlreadySet("http.proxyPassword", httpConfig.getProxyPassword());
        CertificateStore keyStore = httpConfig.getSslConfig().getKeyStore();
        if (keyStore != null) {
            this.setSystemPropertyIfNotAlreadySet("javax.net.ssl.keyStore", keyStore.getPath().toString());
            this.setSystemPropertyIfNotAlreadySet("javax.net.ssl.keyStorePassword", keyStore.getKeyStorePassword().orElse("changeit"));
        }
        if ((trustStore = httpConfig.getSslConfig().getTrustStore()) != null) {
            this.setSystemPropertyIfNotAlreadySet("javax.net.ssl.trustStore", trustStore.getPath().toString());
            this.setSystemPropertyIfNotAlreadySet("javax.net.ssl.trustStorePassword", trustStore.getKeyStorePassword().orElse("changeit"));
        }
        return Map.copyOf(adaptedProperties);
    }

    private void setSystemPropertyIfNotAlreadySet(String key, @Nullable String value) {
        if (this.system.getProperty(key) == null && StringUtils.isNotBlank((CharSequence)value)) {
            System.setProperty(key, value);
        }
    }

    private static Path resolveSonarUserHome(Map<String, String> properties) {
        String sonarUserHome;
        if (properties.containsKey("sonar.userHome")) {
            sonarUserHome = properties.get("sonar.userHome");
        } else {
            String userHome = Objects.requireNonNull(System.getProperty("user.home"), "The system property 'user.home' is expected to be non null");
            sonarUserHome = Paths.get(userHome, ".sonar").toAbsolutePath().toString();
        }
        return Paths.get(sonarUserHome, new String[0]);
    }

    private static String getServerVersion(ScannerHttpClient scannerHttpClient) {
        try {
            return scannerHttpClient.callRestApi("/analysis/version");
        }
        catch (HttpException httpException) {
            try {
                String serverVersion = scannerHttpClient.callWebApi("/api/server/version");
                if (VersionUtils.isAtLeastIgnoringQualifier(serverVersion, SQ_VERSION_NEW_BOOTSTRAPPING)) {
                    throw httpException;
                }
                return serverVersion;
            }
            catch (Exception e2) {
                MessageException ex = new MessageException("Failed to query server version: " + e2.getMessage(), e2);
                if (!e2.equals(httpException)) {
                    ex.addSuppressed(httpException);
                }
                throw ex;
            }
        }
        catch (Exception e) {
            throw new MessageException("Failed to query server version: " + e.getMessage(), e);
        }
    }

    private void initBootstrapDefaultValues(ScannerEndpoint endpoint) {
        this.setBootstrapPropertyIfNotAlreadySet("sonar.host.url", endpoint.getWebEndpoint());
        this.setBootstrapPropertyIfNotAlreadySet("sonar.scanner.apiBaseUrl", endpoint.getApiEndpoint());
        if (!this.bootstrapProperties.containsKey("sonar.scanner.os")) {
            this.setBootstrapProperty("sonar.scanner.os", new OsResolver(this.system, new Paths2()).getOs().name().toLowerCase(Locale.ENGLISH));
        }
        if (!this.bootstrapProperties.containsKey("sonar.scanner.arch")) {
            this.setBootstrapProperty("sonar.scanner.arch", new ArchResolver().getCpuArch());
        }
    }

    static Map<String, String> adaptSslPropertiesToScannerProperties(Map<String, String> bootstrapProperties, HttpConfig httpConfig) {
        CertificateStore trustStore;
        HashMap<String, String> result = new HashMap<String, String>(bootstrapProperties);
        CertificateStore keyStore = httpConfig.getSslConfig().getKeyStore();
        if (keyStore != null && keyStore.isFromJvm()) {
            result.put("sonar.scanner.keystorePath", keyStore.getPath().toString());
            keyStore.getKeyStorePassword().ifPresent(password -> result.put("sonar.scanner.keystorePassword", (String)password));
        }
        if ((trustStore = httpConfig.getSslConfig().getTrustStore()) != null && trustStore.isFromJvm()) {
            result.put("sonar.scanner.truststorePath", trustStore.getPath().toString());
            trustStore.getKeyStorePassword().ifPresent(password -> result.put("sonar.scanner.truststorePassword", (String)password));
        }
        return Map.copyOf(result);
    }

    private void setBootstrapPropertyIfNotAlreadySet(String key, @Nullable String value) {
        if (!this.bootstrapProperties.containsKey(key) && value != null) {
            this.setBootstrapProperty(key, value);
        }
    }
}

