/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle.properties;

import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public class SonarProperty {
    public static final String SKIP = "sonar.skip";
    public static final String GRADLE_SCAN_ALL = "sonar.gradle.scanAll";
    public static final String VERBOSE = "sonar.verbose";
    public static final String PROJECT_KEY = "sonar.projectKey";
    public static final String MODULE_KEY = "sonar.moduleKey";
    public static final String MODULES = "sonar.modules";
    public static final String PROJECT_NAME = "sonar.projectName";
    public static final String PROJECT_DESCRIPTION = "sonar.projectDescription";
    public static final String PROJECT_VERSION = "sonar.projectVersion";
    public static final String PROJECT_BASE_DIR = "sonar.projectBaseDir";
    public static final String WORKING_DIRECTORY = "sonar.working.directory";
    public static final String PROJECT_SOURCE_DIRS = "sonar.sources";
    public static final String PROJECT_TEST_DIRS = "sonar.tests";
    public static final String SOURCE_ENCODING = "sonar.sourceEncoding";
    public static final String JAVA_SOURCE = "sonar.java.source";
    public static final String JAVA_TARGET = "sonar.java.target";
    public static final String JAVA_ENABLE_PREVIEW = "sonar.java.enablePreview";
    public static final String JAVA_JDK_HOME = "sonar.java.jdkHome";
    public static final String JAVA_BINARIES = "sonar.java.binaries";
    public static final String JAVA_LIBRARIES = "sonar.java.libraries";
    public static final String JAVA_TEST_BINARIES = "sonar.java.test.binaries";
    public static final String JAVA_TEST_LIBRARIES = "sonar.java.test.libraries";
    public static final String LIBRARIES = "sonar.libraries";
    public static final String GROOVY_BINARIES = "sonar.groovy.binaries";
    public static final String KOTLIN_GRADLE_PROJECT_ROOT = "sonar.kotlin.gradleProjectRoot";
    public static final String JUNIT_REPORT_PATHS = "sonar.junit.reportPaths";
    public static final String JUNIT_REPORTS_PATH = "sonar.junit.reportsPath";
    public static final String SUREFIRE_REPORTS_PATH = "sonar.surefire.reportsPath";
    public static final String JACOCO_XML_REPORT_PATHS = "sonar.coverage.jacoco.xmlReportPaths";
    public static final String ANDROID_LINT_REPORT_PATHS = "sonar.androidLint.reportPaths";
    public static final String BINARIES = "sonar.binaries";
    private static final Set<String> ALL_SONAR_PROPERTIES = Set.of("sonar.skip", "sonar.gradle.scanAll", "sonar.verbose", "sonar.projectKey", "sonar.moduleKey", "sonar.modules", "sonar.projectName", "sonar.projectDescription", "sonar.projectVersion", "sonar.projectBaseDir", "sonar.working.directory", "sonar.sources", "sonar.tests", "sonar.sourceEncoding", "sonar.java.source", "sonar.java.target", "sonar.java.enablePreview", "sonar.java.jdkHome", "sonar.java.binaries", "sonar.java.libraries", "sonar.java.test.binaries", "sonar.java.test.libraries", "sonar.libraries", "sonar.groovy.binaries", "sonar.kotlin.gradleProjectRoot", "sonar.junit.reportPaths", "sonar.junit.reportsPath", "sonar.surefire.reportsPath", "sonar.coverage.jacoco.xmlReportPaths", "sonar.androidLint.reportPaths", "sonar.binaries");
    @Nullable
    private final String subproject;
    private final String propertyName;

    public static Optional<SonarProperty> parse(String value) {
        if (value == null || value.isEmpty()) {
            return Optional.empty();
        }
        for (String prop : ALL_SONAR_PROPERTIES) {
            String module;
            if (value.equals(prop)) {
                return Optional.of(new SonarProperty("", prop));
            }
            if (!value.endsWith("." + prop) || (module = value.substring(0, value.length() - prop.length() - 1)).isEmpty()) continue;
            return Optional.of(new SonarProperty(module, prop));
        }
        return Optional.empty();
    }

    public static SonarProperty rootProjectProperty(String property) {
        return new SonarProperty(null, property);
    }

    public SonarProperty(@Nullable String subproject, String propertyName) {
        if (subproject != null && subproject.isEmpty()) {
            subproject = null;
        }
        this.subproject = subproject;
        this.propertyName = propertyName;
    }

    @Nullable
    public String getSubproject() {
        return this.subproject;
    }

    public String getProperty() {
        return this.propertyName;
    }

    public String toString() {
        if (this.subproject != null) {
            return this.subproject + "." + this.propertyName;
        }
        return this.propertyName;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SonarProperty that = (SonarProperty)o;
        if (this.subproject == null && that.subproject == null) {
            return this.propertyName.equals(that.propertyName);
        }
        return this.propertyName.equals(that.propertyName) && this.subproject != null && this.subproject.equals(that.subproject);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

