/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nonnull;

public class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;

    private Version(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public static Version of(int major, int minor) {
        return new Version(major, minor);
    }

    public static Version of(String version) {
        String[] split = version.split("\\.");
        int major = 0;
        int minor = 0;
        if (split.length > 0) {
            major = Version.parseInt(split[0]);
            if (split.length > 1) {
                minor = Version.parseInt(split[1]);
            }
        }
        return new Version(major, minor);
    }

    private static int parseInt(String field) {
        try {
            return Integer.parseInt(field);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.major == version.major && this.minor == version.minor;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor);
    }

    public String toString() {
        return this.major + "." + this.minor;
    }

    @Override
    public int compareTo(@Nonnull Version o) {
        return Comparator.comparingInt(Version::major).thenComparing(Version::minor).compare(this, o);
    }
}

