/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.sonarqube.gradle.ProjectProperties;
import org.sonarqube.gradle.ResolutionSerializer;
import org.sonarqube.gradle.SonarUtils;

public abstract class SonarResolverTask
extends DefaultTask {
    public static final String TASK_NAME = "sonarResolver";
    public static final String TASK_DESCRIPTION = "Resolves and serializes project information and classpath for SonarQube analysis.";
    private static final Logger LOGGER = Logger.getLogger(SonarResolverTask.class.getName());
    private String projectName;
    private boolean isTopLevelProject;
    private Provider<FileCollection> mainLibraries;
    private Provider<FileCollection> testLibraries;
    private Provider<FileCollection> compileClasspath;
    private Provider<FileCollection> testCompileClasspath;
    private File outputDirectory;
    private Provider<Boolean> skipProject;

    @Inject
    public SonarResolverTask() {
        this.getOutputs().upToDateWhen(task -> false);
    }

    @Input
    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String name) {
        this.projectName = name;
    }

    @Input
    public boolean isTopLevelProject() {
        return this.isTopLevelProject;
    }

    public void setTopLevelProject(boolean topLevelProject) {
        this.isTopLevelProject = topLevelProject;
    }

    @Internal
    FileCollection getCompileClasspath() {
        return (FileCollection)this.compileClasspath.get();
    }

    public void setCompileClasspath(Provider<FileCollection> compileClasspath) {
        this.compileClasspath = compileClasspath;
    }

    @Internal
    Provider<FileCollection> getTestCompileClasspath() {
        return this.testCompileClasspath;
    }

    public void setTestCompileClasspath(Provider<FileCollection> testCompileClasspath) {
        this.testCompileClasspath = testCompileClasspath;
    }

    @Internal
    Provider<FileCollection> getMainLibraries() {
        return this.mainLibraries;
    }

    public void setMainLibraries(Provider<FileCollection> mainLibraries) {
        this.mainLibraries = mainLibraries;
    }

    @Internal
    Provider<FileCollection> getTestLibraries() {
        return this.testLibraries;
    }

    public void setTestLibraries(Provider<FileCollection> testLibraries) {
        this.testLibraries = testLibraries;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @OutputFile
    public File getOutputFile() {
        return new File(this.outputDirectory, "properties");
    }

    @Input
    public Provider<Boolean> getSkipProject() {
        return this.skipProject;
    }

    public void setSkipProject(Provider<Boolean> skipProject) {
        this.skipProject = skipProject;
    }

    private static List<String> getAbsolutePaths(Provider<FileCollection> fileCollection) {
        FileCollection collection = (FileCollection)fileCollection.getOrNull();
        if (collection == null) {
            return Collections.emptyList();
        }
        return SonarUtils.exists((Iterable<File>)collection).stream().map(File::getAbsolutePath).collect(Collectors.toList());
    }

    @TaskAction
    void run() throws IOException {
        if (Boolean.TRUE.equals(this.skipProject.get())) {
            return;
        }
        String displayName = this.getProjectName();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Resolving properties for " + displayName + ".");
        }
        List<String> compileClasspathFilenames = SonarResolverTask.getAbsolutePaths(this.compileClasspath);
        List<String> testCompileClasspathFilenames = SonarResolverTask.getAbsolutePaths(this.testCompileClasspath);
        List<String> mainLibrariesFilenames = SonarResolverTask.getAbsolutePaths(this.getMainLibraries());
        List<String> testLibrariesFilenames = SonarResolverTask.getAbsolutePaths(this.getTestLibraries());
        ProjectProperties projectProperties = new ProjectProperties(this.getProjectName(), this.isTopLevelProject(), compileClasspathFilenames, testCompileClasspathFilenames, mainLibrariesFilenames, testLibrariesFilenames);
        ResolutionSerializer.write(this.getOutputFile(), projectProperties);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Resolved properties for " + displayName + " and wrote them to " + String.valueOf(this.getOutputFile()) + ".");
        }
    }
}

