/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.testing.jacoco.plugins.JacocoPlugin;
import org.gradle.testing.jacoco.tasks.JacocoReport;
import org.gradle.util.GradleVersion;
import org.sonarqube.gradle.ActionBroadcast;
import org.sonarqube.gradle.AndroidUtils;
import org.sonarqube.gradle.SonarExtension;
import org.sonarqube.gradle.SonarProperties;
import org.sonarqube.gradle.SonarPropertyComputer;
import org.sonarqube.gradle.SonarResolverTask;
import org.sonarqube.gradle.SonarTask;
import org.sonarqube.gradle.SonarUtils;

public class SonarQubePlugin
implements Plugin<Project> {
    private static final Logger LOGGER = Logging.getLogger(SonarQubePlugin.class);

    private static ActionBroadcast<SonarProperties> addBroadcaster(Map<String, ActionBroadcast<SonarProperties>> actionBroadcastMap, Project project) {
        return actionBroadcastMap.computeIfAbsent(project.getPath(), s -> new ActionBroadcast());
    }

    private static boolean addTaskByName(Project p, String name, List<Task> allCompileTasks) {
        try {
            allCompileTasks.add(p.getTasks().getByName(name));
            return true;
        }
        catch (UnknownTaskException e) {
            return false;
        }
    }

    public void apply(Project project) {
        if (project.getExtensions().findByName("sonar") == null) {
            HashMap<String, ActionBroadcast<SonarProperties>> actionBroadcastMap = new HashMap<String, ActionBroadcast<SonarProperties>>();
            SonarQubePlugin.addExtensions(project, "sonar", actionBroadcastMap);
            SonarQubePlugin.addExtensions(project, "sonarqube", actionBroadcastMap);
            LOGGER.debug("Adding '{}' task to '{}'", (Object)"sonar", (Object)project);
            List<File> resolverFiles = SonarQubePlugin.registerAndConfigureResolverTasks(project);
            TaskContainer tasks = project.getTasks();
            tasks.register("sonarqube", SonarTask.class, task -> {
                task.setDescription("Analyzes " + String.valueOf(project) + " and its subprojects with Sonar. This task is deprecated. Use 'sonar' instead.");
                task.setGroup("verification");
                task.setResolverFiles(resolverFiles);
                task.setBuildSonar((Provider<Directory>)project.getLayout().getBuildDirectory().dir("sonar"));
                SonarQubePlugin.configureTask(task, project, actionBroadcastMap);
            });
            tasks.register("sonar", SonarTask.class, task -> {
                task.setDescription("Analyzes " + String.valueOf(project) + " and its subprojects with Sonar.");
                task.setGroup("verification");
                task.setResolverFiles(resolverFiles);
                task.setBuildSonar((Provider<Directory>)project.getLayout().getBuildDirectory().dir("sonar"));
                SonarQubePlugin.configureTask(task, project, actionBroadcastMap);
            });
        }
    }

    private static List<File> registerAndConfigureResolverTasks(Project topLevelProject) {
        ArrayList<File> resolverFiles = new ArrayList<File>();
        Callable<Iterable<? extends Task>> androidTasks = SonarQubePlugin.getAndroidTasks(topLevelProject);
        topLevelProject.getAllprojects().forEach(target -> target.getTasks().register("sonarResolver", SonarResolverTask.class, task -> {
            Provider skipProject = target.provider(() -> SonarQubePlugin.isSkipped(target));
            task.setDescription("Resolves and serializes project information and classpath for SonarQube analysis.");
            task.setSkipProject((Provider<Boolean>)skipProject);
            task.setGroup("verification");
            if (target == topLevelProject) {
                task.setTopLevelProject(true);
            }
            task.setProjectName(SonarUtils.constructPrefixedProjectName(target.getPath()));
            Provider compile = target.provider(() -> SonarQubePlugin.querySourceSet(target, "main"));
            Provider test = target.provider(() -> SonarQubePlugin.querySourceSet(target, "test"));
            task.setCompileClasspath((Provider<FileCollection>)compile);
            task.setTestCompileClasspath((Provider<FileCollection>)test);
            if (SonarUtils.isAndroidProject(target)) {
                task.setMainLibraries((Provider<FileCollection>)target.provider(() -> AndroidUtils.findMainLibraries(target)));
                task.setTestLibraries((Provider<FileCollection>)target.provider(() -> AndroidUtils.findTestLibraries(target)));
            } else {
                task.setMainLibraries((Provider<FileCollection>)target.provider(() -> target.files(new Object[]{SonarUtils.getRuntimeJars()})));
                task.setTestLibraries((Provider<FileCollection>)target.provider(() -> target.files(new Object[]{SonarUtils.getRuntimeJars()})));
            }
            DirectoryProperty buildDirectory = target.getLayout().getBuildDirectory();
            File localSonarResolver = new File((File)buildDirectory.getAsFile().get(), "sonar-resolver");
            localSonarResolver.mkdirs();
            task.setOutputDirectory(localSonarResolver);
            resolverFiles.add(task.getOutputFile());
            task.mustRunAfter(new Object[]{androidTasks});
        }));
        return resolverFiles;
    }

    private static FileCollection querySourceSet(Project project, String sourceSetName) {
        SourceSetContainer sourceSets = SonarUtils.getSourceSets(project);
        if (sourceSets == null) {
            return project.files(new Object[0]);
        }
        SourceSet set = (SourceSet)sourceSets.findByName(sourceSetName);
        return set == null ? project.files(new Object[0]) : set.getCompileClasspath();
    }

    private static void addExtensions(Project project, String name, Map<String, ActionBroadcast<SonarProperties>> actionBroadcastMap) {
        project.getAllprojects().forEach(p -> {
            LOGGER.debug("Adding " + name + " extension to " + String.valueOf(p));
            ActionBroadcast<SonarProperties> actionBroadcast = SonarQubePlugin.addBroadcaster(actionBroadcastMap, p);
            p.getExtensions().create(name, SonarExtension.class, new Object[]{actionBroadcast});
        });
    }

    private static void configureTask(SonarTask sonarTask, Project project, Map<String, ActionBroadcast<SonarProperties>> actionBroadcastMap) {
        Provider conventionProvider = project.provider(() -> new SonarPropertyComputer(actionBroadcastMap, project).computeSonarProperties()).map(m -> m.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)e.getValue())));
        if (SonarQubePlugin.isGradleVersionGreaterOrEqualTo("6.1")) {
            MapProperty mapProperty = project.getObjects().mapProperty(String.class, String.class);
            mapProperty.convention(conventionProvider);
            mapProperty.finalizeValueOnRead();
            sonarTask.setProperties((Provider<Map<String, String>>)mapProperty);
        } else {
            sonarTask.setProperties((Provider<Map<String, String>>)conventionProvider);
        }
        sonarTask.mustRunAfter(new Object[]{SonarQubePlugin.getJavaCompileTasks(project)});
        sonarTask.mustRunAfter(new Object[]{SonarQubePlugin.getAndroidTasks(project)});
        sonarTask.mustRunAfter(new Object[]{SonarQubePlugin.getJavaTestTasks(project)});
        sonarTask.mustRunAfter(new Object[]{SonarQubePlugin.getJacocoTasks(project)});
        sonarTask.dependsOn(new Object[]{SonarQubePlugin.getClassPathResolverTask(project)});
    }

    private static boolean isGradleVersionGreaterOrEqualTo(String version) {
        return GradleVersion.current().compareTo(GradleVersion.version((String)version)) >= 0;
    }

    private static Callable<Iterable<? extends Task>> getJacocoTasks(Project project) {
        return () -> project.getAllprojects().stream().filter(p -> p.getPlugins().hasPlugin(JacocoPlugin.class) && SonarQubePlugin.notSkipped(p)).map(p -> p.getTasks().withType(JacocoReport.class)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static Callable<Iterable<? extends Task>> getJavaTestTasks(Project project) {
        return () -> project.getAllprojects().stream().filter(p -> p.getPlugins().hasPlugin(JavaPlugin.class) && SonarQubePlugin.notSkipped(p)).map(p -> p.getTasks().getByName("test")).collect(Collectors.toList());
    }

    private static Callable<Iterable<? extends Task>> getJavaCompileTasks(Project project) {
        return () -> project.getAllprojects().stream().filter(p -> p.getPlugins().hasPlugin(JavaPlugin.class) && SonarQubePlugin.notSkipped(p)).flatMap(p -> Stream.of(p.getTasks().getByName("compileJava"), p.getTasks().getByName("compileTestJava"))).collect(Collectors.toList());
    }

    private static Callable<Iterable<? extends Task>> getClassPathResolverTask(Project project) {
        return () -> project.getAllprojects().stream().map(p -> p.getTasks().getByName("sonarResolver")).collect(Collectors.toList());
    }

    static boolean notSkipped(Project p) {
        return !SonarQubePlugin.isSkipped(p);
    }

    static boolean isSkipped(Project p) {
        return SonarQubePlugin.getSonarExtensions(p).stream().anyMatch(SonarExtension::isSkipProject);
    }

    private static List<SonarExtension> getSonarExtensions(Project p) {
        return Stream.of("sonar", "sonarqube").map(name -> (SonarExtension)p.getExtensions().getByName(name)).collect(Collectors.toList());
    }

    @Nullable
    static String getConfiguredAndroidVariant(Project p) {
        return SonarQubePlugin.getSonarExtensions(p).stream().map(SonarExtension::getAndroidVariant).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static Callable<Iterable<? extends Task>> getAndroidTasks(Project project) {
        return () -> project.getAllprojects().stream().filter(p -> SonarUtils.isAndroidProject(p) && SonarQubePlugin.notSkipped(p)).map(p -> {
            AndroidUtils.AndroidVariantAndExtension androidVariantAndExtension = AndroidUtils.findVariantAndExtension(p, SonarQubePlugin.getConfiguredAndroidVariant(p));
            ArrayList<Task> allTasks = new ArrayList<Task>();
            if (androidVariantAndExtension != null && androidVariantAndExtension.getVariant() != null) {
                String compileTaskPrefix = "compile" + SonarUtils.capitalize(androidVariantAndExtension.getVariant().getName());
                boolean unitTestTaskDepAdded = SonarQubePlugin.addTaskByName(p, compileTaskPrefix + "UnitTestJavaWithJavac", allTasks);
                boolean androidTestTaskDepAdded = SonarQubePlugin.addTaskByName(p, compileTaskPrefix + "AndroidTestJavaWithJavac", allTasks);
                if (!unitTestTaskDepAdded && !androidTestTaskDepAdded) {
                    SonarQubePlugin.addTaskByName(p, compileTaskPrefix + "JavaWithJavac", allTasks);
                }
                String testTaskPrefix = "test" + SonarUtils.capitalize(androidVariantAndExtension.getVariant().getName());
                SonarQubePlugin.addTaskByName(p, testTaskPrefix + "UnitTest", allTasks);
            }
            return allTasks;
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

