/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.plugins.GroovyPlugin;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.gradle.testing.jacoco.tasks.JacocoReport;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.VisibleForTesting;
import org.sonarqube.gradle.ActionBroadcast;
import org.sonarqube.gradle.AndroidUtils;
import org.sonarqube.gradle.JavaCompilerUtils;
import org.sonarqube.gradle.SonarProperties;
import org.sonarqube.gradle.SonarQubePlugin;
import org.sonarqube.gradle.SonarUtils;
import org.sonarqube.gradle.SourceCollector;
import org.sonarsource.scanner.lib.EnvironmentConfig;

public class SonarPropertyComputer {
    private static final Logger LOGGER = Logging.getLogger(SonarPropertyComputer.class);
    private static final String MAIN_SOURCE_SET_SUFFIX = "main";
    private static final String TEST_SOURCE_SET_SUFFIX = "test";
    private final Map<String, ActionBroadcast<SonarProperties>> actionBroadcastMap;
    private final Project targetProject;
    private static final String SONAR = "sonar";

    public SonarPropertyComputer(Map<String, ActionBroadcast<SonarProperties>> actionBroadcastMap, Project targetProject) {
        this.actionBroadcastMap = actionBroadcastMap;
        this.targetProject = targetProject;
    }

    public Map<String, Object> computeSonarProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        this.computeSonarProperties(this.targetProject, properties);
        properties.computeIfPresent("sonar.projectBaseDir", (k, v) -> SonarUtils.findProjectBaseDir(properties));
        if (SonarQubePlugin.notSkipped(this.targetProject)) {
            properties.put("sonar.kotlin.gradleProjectRoot", this.targetProject.getRootProject().getProjectDir().getAbsolutePath());
        }
        return properties;
    }

    private void computeSonarProperties(Project project, Map<String, Object> properties) {
        this.computeDefaultProperties(project, properties, "");
        if (this.shouldApplyScanAll(project, properties)) {
            SonarPropertyComputer.computeScanAllProperties(project, properties);
        }
    }

    private void computeDefaultProperties(Project project, Map<String, Object> properties, String prefix) {
        if (SonarQubePlugin.isSkipped(project)) {
            return;
        }
        LinkedHashMap<String, Object> rawProperties = new LinkedHashMap<String, Object>();
        this.addGradleDefaults(project, rawProperties);
        if (SonarUtils.isAndroidProject(project)) {
            AndroidUtils.configureForAndroid(project, SonarQubePlugin.getConfiguredAndroidVariant(project), rawProperties);
        }
        if (this.isRootProject(project)) {
            SonarPropertyComputer.addGithubFolder(project, rawProperties);
            SonarPropertyComputer.addKotlinBuildScriptsToSources(project, rawProperties);
        }
        this.overrideWithUserDefinedProperties(project, rawProperties);
        rawProperties.putIfAbsent("sonar.sources", "");
        rawProperties.putIfAbsent("sonar.tests", "");
        if (project.equals(this.targetProject)) {
            rawProperties.putIfAbsent("sonar.projectKey", this.computeProjectKey());
        } else {
            String projectKey = (String)properties.get("sonar.projectKey");
            rawProperties.putIfAbsent("sonar.moduleKey", projectKey + project.getPath());
        }
        SonarPropertyComputer.convertProperties(rawProperties, prefix, properties);
        List enabledChildProjects = project.getChildProjects().values().stream().filter(SonarQubePlugin::notSkipped).collect(Collectors.toList());
        List skippedChildProjects = project.getChildProjects().values().stream().filter(SonarQubePlugin::isSkipped).collect(Collectors.toList());
        if (!skippedChildProjects.isEmpty()) {
            LOGGER.debug("Skipping collecting Sonar properties on: {}", skippedChildProjects);
        }
        if (enabledChildProjects.isEmpty()) {
            return;
        }
        ArrayList<String> moduleIds = new ArrayList<String>();
        Object toPrefix = prefix.isEmpty() ? "" : prefix + ".";
        for (Project childProject : enabledChildProjects) {
            String moduleId = childProject.getPath();
            moduleIds.add(moduleId);
            String modulePrefix = (String)toPrefix + moduleId;
            this.computeDefaultProperties(childProject, properties, modulePrefix);
        }
        properties.put(SonarPropertyComputer.convertKey("sonar.modules", prefix), String.join((CharSequence)",", moduleIds));
    }

    private boolean shouldApplyScanAll(Project project, Map<String, Object> properties) {
        String scanAllValue = (String)properties.getOrDefault("sonar.gradle.scanAll", "false");
        boolean scanAllEnabled = "true".equalsIgnoreCase(scanAllValue.trim());
        if (scanAllEnabled) {
            LOGGER.info("Parameter sonar.gradle.scanAll is enabled. The scanner will attempt to collect additional sources.");
            SonarProperties sonarProps = new SonarProperties(new HashMap<String, Object>());
            this.actionBroadcastMap.get(project.getPath()).execute(sonarProps);
            boolean sourcesOrTestsAlreadySet = Stream.of(SonarPropertyComputer.getSonarSystemProperties(project), SonarPropertyComputer.getSonarEnvironmentVariables(project), sonarProps.getProperties()).map(Map::keySet).flatMap(Collection::stream).anyMatch(k -> "sonar.sources".endsWith((String)k) || "sonar.tests".endsWith((String)k));
            if (sourcesOrTestsAlreadySet) {
                LOGGER.warn("Parameter sonar.gradle.scanAll is enabled but the scanner will not collect additional sources because sonar.sources or sonar.tests has been overridden.");
                return false;
            }
        }
        return scanAllEnabled;
    }

    static Map<String, String> getSonarEnvironmentVariables(Project project) {
        try {
            return EnvironmentConfig.load((Map)((Map)project.getProviders().environmentVariablesPrefixedBy("SONAR").get()));
        }
        catch (NoSuchMethodError e) {
            return EnvironmentConfig.load();
        }
    }

    @VisibleForTesting
    static Map<String, String> getSonarSystemProperties(Project project) {
        try {
            return (Map)project.getProviders().systemPropertiesPrefixedBy(SONAR).get();
        }
        catch (NoSuchMethodError e) {
            return SonarPropertyComputer.fallbackSystemPropertiesForOlderGradle();
        }
    }

    private static Map<String, String> fallbackSystemPropertiesForOlderGradle() {
        return System.getProperties().entrySet().stream().filter(entry -> entry.getKey().toString().startsWith(SONAR)).collect(Collectors.toMap(entry -> entry.getKey().toString(), entry -> entry.getValue().toString()));
    }

    private static void computeScanAllProperties(Project project, Map<String, Object> properties) {
        Set<Path> allModulesExistingSourcesAndTests = properties.entrySet().stream().filter(e -> ((String)e.getKey()).endsWith("sonar.sources") || ((String)e.getKey()).endsWith("sonar.tests")).map(Map.Entry::getValue).map(String.class::cast).map(SonarUtils::splitAsCsv).flatMap(Collection::stream).filter(Predicate.not(String::isBlank)).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toSet());
        Set<Path> skippedDirs = SonarPropertyComputer.skippedProjects(project).map(Project::getProjectDir).map(File::toPath).collect(Collectors.toSet());
        Set<Path> excludedFiles = SonarUtils.computeReportPaths(properties);
        SourceCollector visitor = SourceCollector.builder().setRoot(project.getProjectDir().toPath()).setExistingSources(allModulesExistingSourcesAndTests).setExcludedFiles(excludedFiles).setDirectoriesToIgnore(skippedDirs).build();
        Path projectDir = project.getProjectDir().toPath();
        try {
            Files.walkFileTree(projectDir, visitor);
        }
        catch (IOException e2) {
            LOGGER.error(String.valueOf(e2));
        }
        Map<SonarUtils.InputFileType, List<Path>> collectedSourceByType = visitor.getCollectedSources().stream().map(Path::toAbsolutePath).collect(Collectors.groupingBy(path -> SonarUtils.findProjectFileType(projectDir, path)));
        List<Path> collectedMainSources = collectedSourceByType.getOrDefault((Object)SonarUtils.InputFileType.MAIN, List.of());
        SonarPropertyComputer.appendAdditionalSourceFiles(properties, "sonar.sources", collectedMainSources);
        List<Path> collectedTestSources = collectedSourceByType.getOrDefault((Object)SonarUtils.InputFileType.TEST, List.of());
        SonarPropertyComputer.appendAdditionalSourceFiles(properties, "sonar.tests", collectedTestSources);
    }

    private static void appendAdditionalSourceFiles(Map<String, Object> properties, String sourcePropertyToUpdate, List<Path> collectedSources) {
        String existingValue = (String)properties.getOrDefault(sourcePropertyToUpdate, "");
        Set existingSources = existingValue.isBlank() ? Collections.emptySet() : SonarUtils.splitAsCsv(existingValue).stream().filter(Predicate.not(String::isBlank)).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toSet());
        List<String> mergedSources = Stream.of(existingSources, collectedSources).flatMap(Collection::stream).map(Path::toString).sorted().collect(Collectors.toList());
        properties.put(sourcePropertyToUpdate, SonarUtils.joinAsCsv(mergedSources));
    }

    private void overrideWithUserDefinedProperties(Project project, Map<String, Object> rawProperties) {
        ActionBroadcast<SonarProperties> actionBroadcast = this.actionBroadcastMap.get(project.getPath());
        if (actionBroadcast != null) {
            SonarPropertyComputer.evaluateSonarPropertiesBlocks(actionBroadcast, rawProperties);
        }
        if (this.isRootProject(project)) {
            rawProperties.putAll(SonarPropertyComputer.getSonarEnvironmentVariables(project));
            rawProperties.putAll(SonarPropertyComputer.getSonarSystemProperties(project));
        }
    }

    private boolean isRootProject(Project project) {
        return project.equals(this.targetProject);
    }

    private static void evaluateSonarPropertiesBlocks(ActionBroadcast<? super SonarProperties> propertiesActions, Map<String, Object> properties) {
        SonarProperties sqProperties = new SonarProperties(properties);
        propertiesActions.execute(sqProperties);
    }

    private static void convertProperties(Map<String, Object> rawProperties, String projectPrefix, Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : rawProperties.entrySet()) {
            String value = SonarPropertyComputer.convertValue(entry.getValue(), false);
            if (value == null) continue;
            properties.put(SonarPropertyComputer.convertKey(entry.getKey(), projectPrefix), value);
        }
    }

    private static String convertKey(String key, String projectPrefix) {
        return projectPrefix.isEmpty() ? key : projectPrefix + "." + key;
    }

    private static String convertValue(@Nullable Object value, boolean escapeFilePath) {
        if (value == null) {
            return null;
        }
        if (value instanceof Iterable) {
            String joined = StreamSupport.stream(((Iterable)value).spliterator(), false).map(v -> SonarPropertyComputer.convertValue(v, true)).filter(Objects::nonNull).collect(Collectors.joining(","));
            return joined.isEmpty() ? null : joined;
        }
        if (value instanceof File && escapeFilePath) {
            return SonarPropertyComputer.getEscapedFilePath((File)value);
        }
        return value.toString();
    }

    private static String getEscapedFilePath(File file) {
        String filePath = file.toString();
        if (filePath.contains(",")) {
            return "\"" + filePath.replace("\"", "\\\"") + "\"";
        }
        return filePath;
    }

    private static void configureSourceEncoding(Project project, Map<String, Object> properties) {
        project.getTasks().withType(JavaCompile.class, compile -> {
            String encoding = compile.getOptions().getEncoding();
            if (encoding != null) {
                properties.put("sonar.sourceEncoding", encoding);
            }
        });
    }

    private static void configureForJava(Project project, Map<String, Object> properties) {
        project.getPlugins().withType(JavaBasePlugin.class, javaBasePlugin -> SonarPropertyComputer.populateJdkProperties(project, properties));
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> SonarPropertyComputer.configureSourceDirsAndJavaClasspath(project, properties, false));
    }

    private static void configureForKotlin(Project project, Map<String, Object> properties, Object kotlinProjectExtension) {
        Collection<File> testDirectories;
        Collection<File> sourceDirectories = SonarPropertyComputer.getKotlinSourceFiles(kotlinProjectExtension, MAIN_SOURCE_SET_SUFFIX);
        if (sourceDirectories != null) {
            SonarUtils.appendSourcesProp(properties, sourceDirectories, false);
        }
        if ((testDirectories = SonarPropertyComputer.getKotlinSourceFiles(kotlinProjectExtension, TEST_SOURCE_SET_SUFFIX)) != null) {
            SonarUtils.appendSourcesProp(properties, testDirectories, true);
        }
        if (sourceDirectories != null || testDirectories != null) {
            SonarPropertyComputer.configureSourceEncoding(project, properties);
            SonarPropertyComputer.extractTestProperties(project, properties);
        }
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> SonarPropertyComputer.configureJavaClasspath(project, properties, false));
    }

    private static void configureForGroovy(Project project, Map<String, Object> properties) {
        project.getPlugins().withType(GroovyBasePlugin.class, groovyBasePlugin -> SonarPropertyComputer.populateJdkProperties(project, properties));
        project.getPlugins().withType(GroovyPlugin.class, groovyPlugin -> SonarPropertyComputer.configureSourceDirsAndJavaClasspath(project, properties, true));
    }

    private static void populateJdkProperties(Project project, Map<String, Object> properties) {
        JavaCompilerUtils.extractJavaCompilerConfigurationFromCompileTasks(project).ifPresent(config -> SonarUtils.populateJdkProperties(properties, config));
    }

    private static void extractTestProperties(Project project, Map<String, Object> properties) {
        Task testTask = (Task)project.getTasks().findByName(TEST_SOURCE_SET_SUFFIX);
        if (testTask instanceof Test) {
            SonarPropertyComputer.configureTestReports((Test)testTask, properties);
            SonarPropertyComputer.configureJaCoCoCoverageReport(project, properties);
        }
    }

    private static void configureJaCoCoCoverageReport(Project project, Map<String, Object> properties) {
        project.getTasks().withType(JacocoReport.class, jacocoReportTask -> {
            SingleFileReport xmlReport = jacocoReportTask.getReports().getXml();
            File reportDestination = SonarPropertyComputer.getDestination((Report)xmlReport);
            if (SonarPropertyComputer.isReportEnabled((Report)xmlReport) && reportDestination != null) {
                SonarUtils.appendProp(properties, "sonar.coverage.jacoco.xmlReportPaths", reportDestination);
            } else {
                LOGGER.info("JaCoCo report task detected, but XML report is not enabled or it was not produced. Coverage for this task will not be reported.");
            }
        });
    }

    private static void configureTestReports(Test testTask, Map<String, Object> properties) {
        File testResultsDir = SonarPropertyComputer.getDestination((Report)testTask.getReports().getJunitXml());
        if (testResultsDir == null) {
            return;
        }
        SonarUtils.appendProp(properties, "sonar.junit.reportPaths", testResultsDir);
        SonarUtils.appendProp(properties, "sonar.junit.reportsPath", testResultsDir);
        SonarUtils.appendProp(properties, "sonar.surefire.reportsPath", testResultsDir);
    }

    private static void configureSourceDirsAndJavaClasspath(Project project, Map<String, Object> properties, boolean addForGroovy) {
        SourceSet test;
        Collection<File> testDirectories;
        SourceSetContainer sourceSets = SonarUtils.getSourceSets(project);
        SourceSet main = (SourceSet)sourceSets.getAt(MAIN_SOURCE_SET_SUFFIX);
        Collection<File> sourceDirectories = SonarPropertyComputer.getJavaSourceFiles(main);
        if (sourceDirectories != null) {
            SonarUtils.appendSourcesProp(properties, sourceDirectories, false);
        }
        if ((testDirectories = SonarPropertyComputer.getJavaSourceFiles(test = (SourceSet)sourceSets.getAt(TEST_SOURCE_SET_SUFFIX))) != null) {
            SonarUtils.appendSourcesProp(properties, testDirectories, true);
        }
        if (sourceDirectories != null || testDirectories != null) {
            SonarPropertyComputer.configureSourceEncoding(project, properties);
            SonarPropertyComputer.extractTestProperties(project, properties);
        }
        SonarPropertyComputer.configureJavaClasspath(project, properties, addForGroovy);
    }

    private static void configureJavaClasspath(Project project, Map<String, Object> properties, boolean addForGroovy) {
        SourceSetContainer sourceSets = SonarUtils.getSourceSets(project);
        SourceSet main = (SourceSet)sourceSets.getAt(MAIN_SOURCE_SET_SUFFIX);
        Collection<File> mainClassDirs = SonarPropertyComputer.getJavaOutputDirs(main);
        SonarUtils.setMainBinariesProps(properties, mainClassDirs, addForGroovy);
        SourceSet test = (SourceSet)sourceSets.getAt(TEST_SOURCE_SET_SUFFIX);
        Collection<File> testClassDirs = SonarPropertyComputer.getJavaOutputDirs(test);
        SonarUtils.appendProps(properties, "sonar.java.test.binaries", testClassDirs);
    }

    @Nullable
    private static Collection<File> getJavaSourceFiles(SourceSet sourceSet) {
        ArrayList sourceDirectories = new ArrayList(sourceSet.getAllJava().getSrcDirs());
        return SonarUtils.nonEmptyOrNull(sourceDirectories);
    }

    private static Collection<File> getJavaOutputDirs(SourceSet sourceSet) {
        return sourceSet.getOutput().getClassesDirs().getFiles();
    }

    @Nullable
    private static Collection<File> getKotlinSourceFiles(Object extension, String sourceSetNameSuffix) {
        try {
            Method getSourceSetsMethod = extension.getClass().getMethod("getSourceSets", new Class[0]);
            NamedDomainObjectContainer sourceSets = (NamedDomainObjectContainer)getSourceSetsMethod.invoke(extension, new Object[0]);
            Collection sourceFiles = sourceSets.stream().map(x$0 -> InternalKotlinSourceSet.of(x$0)).filter(s -> s.name.toLowerCase(Locale.ROOT).endsWith(sourceSetNameSuffix)).flatMap(s -> s.srcDirs.stream()).collect(Collectors.toList());
            return SonarUtils.nonEmptyOrNull(sourceFiles);
        }
        catch (Exception e) {
            LOGGER.warn("Sonar plugin wasn't able to locate Kotlin source sets. Continue without sources. Root cause: " + e.getMessage());
            return null;
        }
    }

    private void addGradleDefaults(Project project, Map<String, Object> properties) {
        Object kotlinExtension;
        properties.put("sonar.projectName", project.getName());
        properties.put("sonar.projectDescription", project.getDescription());
        properties.put("sonar.projectVersion", project.getVersion());
        properties.put("sonar.projectBaseDir", project.getProjectDir());
        if (project.equals(this.targetProject)) {
            Provider workingDir = project.getLayout().getBuildDirectory().dir(SONAR);
            properties.put("sonar.working.directory", ((Directory)workingDir.get()).getAsFile());
        }
        if ((kotlinExtension = project.getExtensions().findByName("kotlin")) != null && kotlinExtension.getClass().getName().startsWith("org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension")) {
            SonarPropertyComputer.configureForKotlin(project, properties, kotlinExtension);
        } else if (project.getPlugins().hasPlugin(GroovyBasePlugin.class)) {
            SonarPropertyComputer.configureForGroovy(project, properties);
        } else {
            SonarPropertyComputer.configureForJava(project, properties);
        }
    }

    private static void addKotlinBuildScriptsToSources(Project project, Map<String, Object> properties) {
        Set skippedProjects = SonarPropertyComputer.skippedProjects(project).collect(Collectors.toSet());
        List<File> buildScripts = project.getAllprojects().stream().filter(Predicate.not(skippedProjects::contains)).map(Project::getBuildFile).filter(file -> file.getAbsolutePath().endsWith("kts")).collect(Collectors.toList());
        File settingsFile = Path.of(project.getProjectDir().getAbsolutePath(), "settings.gradle.kts").toFile();
        buildScripts.add(settingsFile);
        SonarUtils.appendSourcesProp(properties, buildScripts, false);
    }

    private static void addGithubFolder(Project project, Map<String, Object> properties) {
        File githubFolder = project.getProjectDir().toPath().resolve(".github").toFile();
        SonarUtils.appendSourcesProp(properties, List.of(githubFolder), false);
    }

    private String computeProjectKey() {
        String rootKey;
        Project rootProject = this.targetProject.getRootProject();
        String rootProjectName = rootProject.getName();
        String rootGroup = rootProject.getGroup().toString();
        String string = rootKey = rootGroup.isEmpty() ? rootProjectName : rootGroup + ":" + rootProjectName;
        if (this.targetProject == rootProject) {
            return rootKey;
        }
        return rootKey + this.targetProject.getPath();
    }

    private static boolean isReportEnabled(Report report) {
        try {
            if (GradleVersion.version((String)"7.0").compareTo(GradleVersion.current()) <= 0) {
                return (Boolean)report.getRequired().getOrElse((Object)false);
            }
            Method isEnabledGradle5 = report.getClass().getMethod("isEnabled", new Class[0]);
            return (Boolean)isEnabledGradle5.invoke((Object)report, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to check if report is enabled.", e);
        }
    }

    @CheckForNull
    private static File getDestination(Report report) {
        try {
            if (GradleVersion.version((String)"7.0").compareTo(GradleVersion.current()) <= 0) {
                return SonarPropertyComputer.getDestinationNewApi(report);
            }
            return SonarPropertyComputer.getDestinationOldApi(report);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to check the destination of the report.", e);
        }
    }

    private static File getDestinationNewApi(Report report) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method getOutputLocation = report.getClass().getMethod("getOutputLocation", new Class[0]);
        Provider provider = (Provider)getOutputLocation.invoke((Object)report, new Object[0]);
        FileSystemLocation location = (FileSystemLocation)provider.getOrNull();
        if (location != null) {
            return location.getAsFile();
        }
        return null;
    }

    private static File getDestinationOldApi(Report report) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method getDestinationGradle5 = report.getClass().getMethod("getDestination", new Class[0]);
        return (File)getDestinationGradle5.invoke((Object)report, new Object[0]);
    }

    private static Stream<Project> skippedProjects(Project project) {
        Set projectsMarkedAsSkipped = project.getAllprojects().stream().filter(SonarQubePlugin::isSkipped).collect(Collectors.toSet());
        return project.getAllprojects().stream().filter(p -> SonarPropertyComputer.hasSkippedAncestor(p, projectsMarkedAsSkipped));
    }

    private static boolean hasSkippedAncestor(Project project, Set<Project> skippedProjects) {
        while (project != null) {
            if (skippedProjects.contains(project)) {
                return true;
            }
            project = project.getParent();
        }
        return false;
    }

    private static class InternalKotlinSourceSet {
        private String name;
        private Collection<File> srcDirs;

        private InternalKotlinSourceSet() {
        }

        private static InternalKotlinSourceSet of(Object rawSourceSet) {
            InternalKotlinSourceSet internalKotlinSourceSet = new InternalKotlinSourceSet();
            try {
                Method getName = rawSourceSet.getClass().getMethod("getName", new Class[0]);
                internalKotlinSourceSet.name = (String)getName.invoke(rawSourceSet, new Object[0]);
                Method getKotlin = rawSourceSet.getClass().getMethod("getKotlin", new Class[0]);
                Object kotlin = getKotlin.invoke(rawSourceSet, new Object[0]);
                Method getSrcDirs = kotlin.getClass().getMethod("getSrcDirs", new Class[0]);
                internalKotlinSourceSet.srcDirs = (Collection)getSrcDirs.invoke(kotlin, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.warn("Sonar plugin wasn't able to locate source set. Root cause: " + e.getMessage());
            }
            return internalKotlinSourceSet;
        }
    }
}

