/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.spring;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import javax.inject.Singleton;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceHandle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@Singleton
public class AutowiredInjectionResolver
implements InjectionResolver<Autowired> {
    private ApplicationContext applicationContext;

    public AutowiredInjectionResolver(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Object resolve(Injectee injectee, ServiceHandle<?> root) {
        return this.getBeanFromSpringContext(injectee.getRequiredType());
    }

    public boolean isConstructorParameterIndicator() {
        return false;
    }

    public boolean isMethodParameterIndicator() {
        return false;
    }

    private Object getBeanFromSpringContext(Type beanType) {
        Map beans = this.applicationContext.getBeansOfType(this.getClassFromType(beanType));
        if (!beans.values().isEmpty()) {
            return beans.values().iterator().next();
        }
        return null;
    }

    private Class<?> getClassFromType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return null;
    }
}

