/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.proxy;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.smallmind.web.jersey.proxy.HttpProtocol;
import org.smallmind.web.jersey.proxy.JsonTarget;
import org.smallmind.web.jersey.proxy.TrustAllHostNameVerifier;

public class JsonTargetFactory {
    public static JsonTarget manufacture(String host, int concurrencyLevel) throws NoSuchAlgorithmException, MalformedURLException, URISyntaxException {
        return JsonTargetFactory.manufacture(HttpProtocol.HTTP, host, 0, null, concurrencyLevel);
    }

    public static JsonTarget manufacture(HttpProtocol protocol, String host, int concurrencyLevel) throws NoSuchAlgorithmException, MalformedURLException, URISyntaxException {
        return JsonTargetFactory.manufacture(protocol, host, 0, null, concurrencyLevel);
    }

    public static JsonTarget manufacture(HttpProtocol protocol, String host, int port, int concurrencyLevel) throws NoSuchAlgorithmException, MalformedURLException, URISyntaxException {
        return JsonTargetFactory.manufacture(protocol, host, port, null, concurrencyLevel);
    }

    public static JsonTarget manufacture(HttpProtocol protocol, String host, String context, int concurrencyLevel) throws NoSuchAlgorithmException, MalformedURLException, URISyntaxException {
        return JsonTargetFactory.manufacture(protocol, host, 0, context, concurrencyLevel);
    }

    public static JsonTarget manufacture(HttpProtocol protocol, String host, int port, String context, int concurrencyLevel) throws NoSuchAlgorithmException, MalformedURLException, URISyntaxException {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultConnectionConfig(ConnectionConfig.custom().setCharset(StandardCharsets.UTF_8).build());
        connectionManager.setDefaultSocketConfig(SocketConfig.copy((SocketConfig)SocketConfig.DEFAULT).setSoTimeout(20000).setTcpNoDelay(true).build());
        CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).setSSLContext(SSLContext.getInstance("SSL")).setSSLHostnameVerifier((HostnameVerifier)new TrustAllHostNameVerifier()).setMaxConnTotal(concurrencyLevel).setMaxConnPerRoute(concurrencyLevel).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
        return new JsonTarget(httpClient, URI.create(String.valueOf(protocol.getScheme()) + "://" + host + (port > 0 ? ":" + port : "") + (context != null ? context : "")));
    }
}

