/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.spring;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.spring.ResultSetExtractorImpl;
import org.simpleflatmapper.util.CheckedConsumer;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;

public final class PreparedStatementCallbackImpl<T>
implements PreparedStatementCallback<List<T>> {
    private final ResultSetExtractorImpl<T> resultSetExtractor;

    public PreparedStatementCallbackImpl(JdbcMapper<T> mapper) {
        this.resultSetExtractor = new ResultSetExtractorImpl<T>(mapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
        try (ResultSet rs = ps.executeQuery();){
            Object object = this.resultSetExtractor.extractData(rs);
            return object;
        }
    }

    public <H extends CheckedConsumer<T>> PreparedStatementCallback<H> newPreparedStatementCallback(final H handler) {
        return new PreparedStatementCallback<H>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public H doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                ResultSetExtractor<CheckedConsumer> extractor = PreparedStatementCallbackImpl.this.resultSetExtractor.newResultSetExtractor(handler);
                try (ResultSet rs = ps.executeQuery();){
                    CheckedConsumer checkedConsumer = (CheckedConsumer)extractor.extractData(rs);
                    return checkedConsumer;
                }
            }
        };
    }
}

