/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.spring;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.named.NamedParameter;
import org.simpleflatmapper.jdbc.named.NamedSqlQuery;
import org.simpleflatmapper.jdbc.spring.PreparedStatementCallbackImpl;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.object.SqlQuery;

public class MappingSqlQuery<T>
extends SqlQuery<T> {
    private final PreparedStatementCallbackImpl<T> statementCallback;

    public MappingSqlQuery(DataSource ds, String sql, JdbcMapper<T> mapper) {
        super(ds, sql);
        this.setParameters(this.extractParameters(sql));
        this.statementCallback = new PreparedStatementCallbackImpl<T>(mapper);
        this.afterPropertiesSet();
    }

    private SqlParameter[] extractParameters(String sql) {
        NamedSqlQuery query = NamedSqlQuery.parse((CharSequence)sql);
        SqlParameter[] params = new SqlParameter[query.getParametersSize()];
        for (int i = 0; i < params.length; ++i) {
            NamedParameter namedParameter = query.getParameter(i);
            params[i] = new SqlParameter(namedParameter.getName(), 0);
        }
        return params;
    }

    public List<T> execute(Object[] params, Map<?, ?> context) throws DataAccessException {
        this.validateParameters(params);
        return this.query(this.newPreparedStatementCreator(params));
    }

    public List<T> executeByNamedParam(Map<String, ?> paramMap, Map<?, ?> context) throws DataAccessException {
        this.validateNamedParameters(paramMap);
        ParsedSql parsedSql = this.getParsedSql();
        MapSqlParameterSource paramSource = new MapSqlParameterSource(paramMap);
        String sqlToUse = NamedParameterUtils.substituteNamedParameters((ParsedSql)parsedSql, (SqlParameterSource)paramSource);
        Object[] params = NamedParameterUtils.buildValueArray((ParsedSql)parsedSql, (SqlParameterSource)paramSource, (List)this.getDeclaredParameters());
        return this.query(this.newPreparedStatementCreator(sqlToUse, params));
    }

    private List<T> query(PreparedStatementCreator preparedStatementCreator) {
        return (List)this.getJdbcTemplate().execute(preparedStatementCreator, this.statementCallback);
    }

    protected RowMapper<T> newRowMapper(Object[] parameters, Map<?, ?> context) {
        throw new UnsupportedOperationException();
    }
}

