/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.TypeCoercer;
import org.openqa.selenium.json.Types;

public class StaticInitializerCoercer
extends TypeCoercer<Object> {
    private static final String FACTORY_METHOD_NAME = "fromJson";

    @Override
    public boolean test(Class<?> aClass) {
        return this.getMethods(aClass).count() == 1L;
    }

    @Override
    public BiFunction<JsonInput, PropertySetting, Object> apply(Type type) {
        Class<?> aClass = Types.narrow(type);
        Method fromJson = this.getMethods(aClass).findFirst().get();
        fromJson.setAccessible(true);
        return (jsonInput, setting) -> {
            Type argType = fromJson.getGenericParameterTypes()[0];
            JsonInput obj = JsonInput.class.equals((Object)argType) ? jsonInput : jsonInput.read(argType);
            if (obj == null) {
                throw new JsonException("Unable to read value to convert for " + String.valueOf(type));
            }
            try {
                return fromJson.invoke(null, obj);
            }
            catch (ReflectiveOperationException e) {
                throw new JsonException("Unable to create instance of " + String.valueOf(type), e);
            }
        };
    }

    private Stream<Method> getMethods(Class<?> aClass) {
        return Arrays.stream(aClass.getDeclaredMethods()).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> FACTORY_METHOD_NAME.equals(method.getName())).filter(method -> method.getParameterCount() == 1);
    }
}

