/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v141.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v141.network.model.DirectSocketDnsQueryType;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DirectTCPSocketOptions {
    private final Boolean noDelay;
    private final Optional<Number> keepAliveDelay;
    private final Optional<Number> sendBufferSize;
    private final Optional<Number> receiveBufferSize;
    private final Optional<DirectSocketDnsQueryType> dnsQueryType;

    public DirectTCPSocketOptions(Boolean noDelay, Optional<Number> keepAliveDelay, Optional<Number> sendBufferSize, Optional<Number> receiveBufferSize, Optional<DirectSocketDnsQueryType> dnsQueryType) {
        this.noDelay = Objects.requireNonNull(noDelay, "noDelay is required");
        this.keepAliveDelay = keepAliveDelay;
        this.sendBufferSize = sendBufferSize;
        this.receiveBufferSize = receiveBufferSize;
        this.dnsQueryType = dnsQueryType;
    }

    public Boolean getNoDelay() {
        return this.noDelay;
    }

    public Optional<Number> getKeepAliveDelay() {
        return this.keepAliveDelay;
    }

    public Optional<Number> getSendBufferSize() {
        return this.sendBufferSize;
    }

    public Optional<Number> getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public Optional<DirectSocketDnsQueryType> getDnsQueryType() {
        return this.dnsQueryType;
    }

    private static DirectTCPSocketOptions fromJson(JsonInput input) {
        Boolean noDelay = false;
        Optional<Number> keepAliveDelay = Optional.empty();
        Optional<Number> sendBufferSize = Optional.empty();
        Optional<Number> receiveBufferSize = Optional.empty();
        Optional<DirectSocketDnsQueryType> dnsQueryType = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "noDelay": {
                    noDelay = input.nextBoolean();
                    continue block14;
                }
                case "keepAliveDelay": {
                    keepAliveDelay = Optional.ofNullable(input.nextNumber());
                    continue block14;
                }
                case "sendBufferSize": {
                    sendBufferSize = Optional.ofNullable(input.nextNumber());
                    continue block14;
                }
                case "receiveBufferSize": {
                    receiveBufferSize = Optional.ofNullable(input.nextNumber());
                    continue block14;
                }
                case "dnsQueryType": {
                    dnsQueryType = Optional.ofNullable((DirectSocketDnsQueryType)((Object)input.read(DirectSocketDnsQueryType.class)));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DirectTCPSocketOptions(noDelay, keepAliveDelay, sendBufferSize, receiveBufferSize, dnsQueryType);
    }
}

