/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v137.network.model;

import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v137.network.model.Headers;
import org.openqa.selenium.devtools.v137.network.model.SignedExchangeSignature;
import org.openqa.selenium.json.JsonInput;

@Beta
public class SignedExchangeHeader {
    private final String requestUrl;
    private final Integer responseCode;
    private final Headers responseHeaders;
    private final List<SignedExchangeSignature> signatures;
    private final String headerIntegrity;

    public SignedExchangeHeader(String requestUrl, Integer responseCode, Headers responseHeaders, List<SignedExchangeSignature> signatures, String headerIntegrity) {
        this.requestUrl = Objects.requireNonNull(requestUrl, "requestUrl is required");
        this.responseCode = Objects.requireNonNull(responseCode, "responseCode is required");
        this.responseHeaders = Objects.requireNonNull(responseHeaders, "responseHeaders is required");
        this.signatures = Objects.requireNonNull(signatures, "signatures is required");
        this.headerIntegrity = Objects.requireNonNull(headerIntegrity, "headerIntegrity is required");
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public Integer getResponseCode() {
        return this.responseCode;
    }

    public Headers getResponseHeaders() {
        return this.responseHeaders;
    }

    public List<SignedExchangeSignature> getSignatures() {
        return this.signatures;
    }

    public String getHeaderIntegrity() {
        return this.headerIntegrity;
    }

    private static SignedExchangeHeader fromJson(JsonInput input) {
        String requestUrl = null;
        Integer responseCode = 0;
        Headers responseHeaders = null;
        List signatures = null;
        String headerIntegrity = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestUrl": {
                    requestUrl = input.nextString();
                    continue block14;
                }
                case "responseCode": {
                    responseCode = input.nextNumber().intValue();
                    continue block14;
                }
                case "responseHeaders": {
                    responseHeaders = (Headers)input.read(Headers.class);
                    continue block14;
                }
                case "signatures": {
                    signatures = input.readArray(SignedExchangeSignature.class);
                    continue block14;
                }
                case "headerIntegrity": {
                    headerIntegrity = input.nextString();
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SignedExchangeHeader(requestUrl, responseCode, responseHeaders, signatures, headerIntegrity);
    }
}

