/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v136.log.model;

import java.util.Arrays;
import java.util.Objects;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public class ViolationSetting {
    private final Name name;
    private final Number threshold;

    public ViolationSetting(Name name, Number threshold) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.threshold = Objects.requireNonNull(threshold, "threshold is required");
    }

    public Name getName() {
        return this.name;
    }

    public Number getThreshold() {
        return this.threshold;
    }

    private static ViolationSetting fromJson(JsonInput input) {
        Name name = null;
        Number threshold = 0;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = Name.fromString(input.nextString());
                    continue block8;
                }
                case "threshold": {
                    threshold = input.nextNumber();
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ViolationSetting(name, threshold);
    }

    public static enum Name {
        LONGTASK("longTask"),
        LONGLAYOUT("longLayout"),
        BLOCKEDEVENT("blockedEvent"),
        BLOCKEDPARSER("blockedParser"),
        DISCOURAGEDAPIUSE("discouragedAPIUse"),
        HANDLER("handler"),
        RECURRINGHANDLER("recurringHandler");

        private String value;

        private Name(String value) {
            this.value = value;
        }

        public static Name fromString(String s) {
            return Arrays.stream(Name.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Name "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Name fromJson(JsonInput input) {
            return Name.fromString(input.nextString());
        }
    }
}

