/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v132.css.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v132.css.model.CSSStyle;
import org.openqa.selenium.devtools.v132.css.model.StyleSheetId;
import org.openqa.selenium.devtools.v132.css.model.StyleSheetOrigin;
import org.openqa.selenium.json.JsonInput;

public class CSSTryRule {
    private final Optional<StyleSheetId> styleSheetId;
    private final StyleSheetOrigin origin;
    private final CSSStyle style;

    public CSSTryRule(Optional<StyleSheetId> styleSheetId, StyleSheetOrigin origin, CSSStyle style) {
        this.styleSheetId = styleSheetId;
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.style = Objects.requireNonNull(style, "style is required");
    }

    public Optional<StyleSheetId> getStyleSheetId() {
        return this.styleSheetId;
    }

    public StyleSheetOrigin getOrigin() {
        return this.origin;
    }

    public CSSStyle getStyle() {
        return this.style;
    }

    private static CSSTryRule fromJson(JsonInput input) {
        Optional<StyleSheetId> styleSheetId = Optional.empty();
        StyleSheetOrigin origin = null;
        CSSStyle style = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "styleSheetId": {
                    styleSheetId = Optional.ofNullable((StyleSheetId)input.read(StyleSheetId.class));
                    continue block10;
                }
                case "origin": {
                    origin = (StyleSheetOrigin)((Object)input.read(StyleSheetOrigin.class));
                    continue block10;
                }
                case "style": {
                    style = (CSSStyle)input.read(CSSStyle.class);
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSTryRule(styleSheetId, origin, style);
    }
}

