/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v130.domsnapshot.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v130.dom.model.Rect;
import org.openqa.selenium.json.JsonInput;

public class InlineTextBox {
    private final Rect boundingBox;
    private final Integer startCharacterIndex;
    private final Integer numCharacters;

    public InlineTextBox(Rect boundingBox, Integer startCharacterIndex, Integer numCharacters) {
        this.boundingBox = Objects.requireNonNull(boundingBox, "boundingBox is required");
        this.startCharacterIndex = Objects.requireNonNull(startCharacterIndex, "startCharacterIndex is required");
        this.numCharacters = Objects.requireNonNull(numCharacters, "numCharacters is required");
    }

    public Rect getBoundingBox() {
        return this.boundingBox;
    }

    public Integer getStartCharacterIndex() {
        return this.startCharacterIndex;
    }

    public Integer getNumCharacters() {
        return this.numCharacters;
    }

    private static InlineTextBox fromJson(JsonInput input) {
        Rect boundingBox = null;
        Integer startCharacterIndex = 0;
        Integer numCharacters = 0;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "boundingBox": {
                    boundingBox = (Rect)input.read(Rect.class);
                    continue block10;
                }
                case "startCharacterIndex": {
                    startCharacterIndex = input.nextNumber().intValue();
                    continue block10;
                }
                case "numCharacters": {
                    numCharacters = input.nextNumber().intValue();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new InlineTextBox(boundingBox, startCharacterIndex, numCharacters);
    }
}

