/*
 * Decompiled with CFR 0.152.
 */
package scoverage.reporter;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;
import scoverage.domain.CodeGrid;
import scoverage.domain.Coverage;
import scoverage.domain.MeasuredClass;
import scoverage.domain.MeasuredFile;
import scoverage.domain.MeasuredPackage;
import scoverage.reporter.BaseReportWriter;
import scoverage.reporter.IOUtils$;
import scoverage.reporter.StatementWriter;

@ScalaSignature(bytes="\u0006\u0005\u0005ed\u0001B\f\u0019\u0001uA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\ts\u0001\u0011\t\u0011)A\u0005c!A!\b\u0001B\u0001B\u0003%1\bC\u0003H\u0001\u0011\u0005\u0001\nC\u0003H\u0001\u0011\u0005Q\nC\u0003H\u0001\u0011\u0005A\u000bC\u0003H\u0001\u0011\u0005q\u000bC\u0003\\\u0001\u0011\u0005A\fC\u0003i\u0001\u0011%\u0011\u000eC\u0003p\u0001\u0011%\u0001\u000fC\u0003w\u0001\u0011%q\u000fC\u0003\u007f\u0001\u0011%q\u0010C\u0004\u0002\u0010\u0001!\t!!\u0005\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002bBA \u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003\u000f\u0002A\u0011AA%\u0011\u001d\ti\u0005\u0001C\u0001\u0003\u001fBq!!\u0018\u0001\t\u0003\ty\u0006C\u0004\u0002d\u0001!\t!!\u001a\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u0011q\u000e\u0001\u0005\u0002\u0005E$aE*d_Z,'/Y4f\u0011RlGn\u0016:ji\u0016\u0014(BA\r\u001b\u0003!\u0011X\r]8si\u0016\u0014(\"A\u000e\u0002\u0013M\u001cwN^3sC\u001e,7\u0001A\n\u0003\u0001y\u0001\"a\b\u0011\u000e\u0003aI!!\t\r\u0003!\t\u000b7/\u001a*fa>\u0014Ho\u0016:ji\u0016\u0014\u0018!E:pkJ\u001cW\rR5sK\u000e$xN]5fgB\u0019AEL\u0019\u000f\u0005\u0015ZcB\u0001\u0014*\u001b\u00059#B\u0001\u0015\u001d\u0003\u0019a$o\\8u}%\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-[\u00059\u0001/Y2lC\u001e,'\"\u0001\u0016\n\u0005=\u0002$aA*fc*\u0011A&\f\t\u0003e]j\u0011a\r\u0006\u0003iU\n!![8\u000b\u0003Y\nAA[1wC&\u0011\u0001h\r\u0002\u0005\r&dW-A\u0005pkR\u0004X\u000f\u001e#je\u0006q1o\\;sG\u0016,enY8eS:<\u0007c\u0001\u001f>\u007f5\tQ&\u0003\u0002?[\t1q\n\u001d;j_:\u0004\"\u0001\u0011#\u000f\u0005\u0005\u0013\u0005C\u0001\u0014.\u0013\t\u0019U&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000b\u001a\u0013aa\u0015;sS:<'BA\".\u0003\u0019a\u0014N\\5u}Q!\u0011JS&M!\ty\u0002\u0001C\u0003#\t\u0001\u00071\u0005C\u0003:\t\u0001\u0007\u0011\u0007C\u0003;\t\u0001\u00071\b\u0006\u0003J\u001dJ\u001b\u0006\"\u0002\u0012\u0006\u0001\u0004y\u0005c\u0001\u001fQc%\u0011\u0011+\f\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0006s\u0015\u0001\r!\r\u0005\u0006u\u0015\u0001\ra\u000f\u000b\u0004\u0013V3\u0006\"\u0002\u0012\u0007\u0001\u0004\u0019\u0003\"B\u001d\u0007\u0001\u0004\tDcA%Y5\")\u0011l\u0002a\u0001c\u0005y1o\\;sG\u0016$\u0015N]3di>\u0014\u0018\u0010C\u0003:\u000f\u0001\u0007\u0011'A\u0003xe&$X\r\u0006\u0002^AB\u0011AHX\u0005\u0003?6\u0012A!\u00168ji\")\u0011\r\u0003a\u0001E\u0006A1m\u001c<fe\u0006<W\r\u0005\u0002dM6\tAM\u0003\u0002f5\u00051Am\\7bS:L!a\u001a3\u0003\u0011\r{g/\u001a:bO\u0016\fAb\u001e:ji\u0016\u0004\u0016mY6bO\u0016$\"!\u00186\t\u000b-L\u0001\u0019\u00017\u0002\u0007A\\w\r\u0005\u0002d[&\u0011a\u000e\u001a\u0002\u0010\u001b\u0016\f7/\u001e:fIB\u000b7m[1hK\u0006IqO]5uK\u001aKG.\u001a\u000b\u0003;FDQA\u001d\u0006A\u0002M\fQ!\u001c4jY\u0016\u0004\"a\u0019;\n\u0005U$'\u0001D'fCN,(/\u001a3GS2,\u0017a\u00079bG.\fw-Z(wKJ4\u0018.Z<SK2\fG/\u001b<f!\u0006$\b\u000e\u0006\u0002y{B\u0011\u0011\u0010`\u0007\u0002u*\u001110N\u0001\u0005Y\u0006tw-\u0003\u0002Fu\")1n\u0003a\u0001Y\u0006Aa-\u001b7f!\u0006<W\r\u0006\u0003\u0002\u0002\u00055\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001dQ&A\u0002y[2LA!a\u0003\u0002\u0006\t!aj\u001c3f\u0011\u0015\u0011H\u00021\u0001t\u0003\u0019AW-\u00193feV\u0011\u00111\u0003\t\u0005\u0003\u0007\t)\"\u0003\u0003\u0002\u0018\u0005\u0015!\u0001B#mK6\fq\u0002]1dW\u0006<Wm\u0014<feZLWm\u001e\u000b\u0005\u0003\u0003\ti\u0002\u0003\u0004\u0002 9\u0001\r\u0001\\\u0001\u0005a\u0006\u001c7.\u0001\u0007dY\u0006\u001c8/Z:UC\ndW\r\u0006\u0004\u0002\u0002\u0005\u0015\u0012Q\u0007\u0005\b\u0003Oy\u0001\u0019AA\u0015\u0003\u001d\u0019G.Y:tKN\u0004R\u0001JA\u0016\u0003_I1!!\f1\u0005!IE/\u001a:bE2,\u0007cA2\u00022%\u0019\u00111\u00073\u0003\u001b5+\u0017m];sK\u0012\u001cE.Y:t\u0011\u001d\t9d\u0004a\u0001\u0003s\tq!\u00193e!\u0006$\b\u000eE\u0002=\u0003wI1!!\u0010.\u0005\u001d\u0011un\u001c7fC:\f\u0001b\u00197bgN\u0014vn\u001e\u000b\u0005\u0003\u0003\t\u0019\u0005C\u0004\u0002FA\u0001\r!a\f\u0002\u000b-d\u0017m]:\u0002\u0017A\f7m[1hK2K7\u000f\u001e\u000b\u0005\u0003\u0003\tY\u0005C\u0003b#\u0001\u0007!-A\u0003sSN\\7\u000f\u0006\u0004\u0002\u0014\u0005E\u00131\u000b\u0005\u0006CJ\u0001\rA\u0019\u0005\b\u0003+\u0012\u0002\u0019AA,\u0003\u0015a\u0017.\\5u!\ra\u0014\u0011L\u0005\u0004\u00037j#aA%oi\u0006I\u0001/Y2lC\u001e,7O\r\u000b\u0005\u0003'\t\t\u0007C\u0003b'\u0001\u0007!-\u0001\u0005pm\u0016\u0014h/[3x)\u0011\t\t!a\u001a\t\u000b\u0005$\u0002\u0019\u00012\u0002\u000bM$\u0018\r^:\u0015\t\u0005\u0005\u0011Q\u000e\u0005\u0006CV\u0001\rAY\u0001\ba2,x-\u001b8t+\t\t\u0019\b\u0005\u0003\u0002\u0004\u0005U\u0014\u0002BA<\u0003\u000b\u0011!BT8eK\n+hMZ3s\u0001")
public class ScoverageHtmlWriter
extends BaseReportWriter {
    private final File outputDir;
    private final Option<String> sourceEncoding;

    public void write(Coverage coverage) {
        String string;
        String string2;
        File indexFile = new File(new StringBuilder(11).append(this.outputDir.getAbsolutePath()).append("/index.html").toString());
        File cssFile = new File(new StringBuilder(13).append(this.outputDir.getAbsolutePath()).append("/pure-min.css").toString());
        File packageFile = new File(new StringBuilder(14).append(this.outputDir.getAbsolutePath()).append("/packages.html").toString());
        File overviewFile = new File(new StringBuilder(14).append(this.outputDir.getAbsolutePath()).append("/overview.html").toString());
        try (InputStream in = this.getClass().getResourceAsStream("/scoverage/index.html");){
            string2 = IOUtils$.MODULE$.readStreamAsString(in);
        }
        String index = string2;
        try (InputStream in = this.getClass().getResourceAsStream("/scoverage/pure-min.css");){
            string = IOUtils$.MODULE$.readStreamAsString(in);
        }
        String css = string;
        IOUtils$.MODULE$.writeToFile(indexFile, index, this.sourceEncoding);
        IOUtils$.MODULE$.writeToFile(cssFile, css, this.sourceEncoding);
        IOUtils$.MODULE$.writeToFile(packageFile, this.packageList(coverage).toString(), this.sourceEncoding);
        IOUtils$.MODULE$.writeToFile(overviewFile, this.overview(coverage).toString(), this.sourceEncoding);
        coverage.packages().foreach((Function1 & Serializable)pkg -> {
            this.writePackage(pkg);
            return BoxedUnit.UNIT;
        });
    }

    private void writePackage(MeasuredPackage pkg) {
        File file = new File(this.outputDir, this.packageOverviewRelativePath(pkg));
        file.getParentFile().mkdirs();
        IOUtils$.MODULE$.writeToFile(file, this.packageOverview(pkg).toString(), this.sourceEncoding);
        pkg.files().foreach((Function1 & Serializable)mfile -> {
            this.writeFile(mfile);
            return BoxedUnit.UNIT;
        });
    }

    private void writeFile(MeasuredFile mfile) {
        File file = new File(this.outputDir, new StringBuilder(5).append(this.relativeSource(mfile.source())).append(".html").toString());
        file.getParentFile().mkdirs();
        IOUtils$.MODULE$.writeToFile(file, this.filePage(mfile).toString(), this.sourceEncoding);
    }

    private String packageOverviewRelativePath(MeasuredPackage pkg) {
        return new StringBuilder(5).append(pkg.name().replace("<empty>", "(empty)")).append(".html").toString();
    }

    private Node filePage(MeasuredFile mfile) {
        String filename = new StringBuilder(5).append(this.relativeSource(mfile.source())).append(".html").toString();
        String css = "table.codegrid { font-family: monospace; font-size: 12px; width: auto!important; }table.statementlist { width: auto!important; font-size: 13px; } table.codegrid td { padding: 0!important; border: 0!important } table td.linenumber { width: 40px!important; } ";
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("content", (Seq)new Text("text/html; charset=utf-8"), (MetaData)$md);
        $md = new UnprefixedAttribute("http-equiv", (Seq)new Text("Content-Type"), (MetaData)$md);
        $buf2.$amp$plus((Object)new Elem(null, "meta", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("id", (Seq)new Text("title"), (MetaData)$md2);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        $buf3.$amp$plus((Object)filename);
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "title", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)this.plugins());
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          "));
        $buf4.$amp$plus((Object)css);
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "style", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "head", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("style", (Seq)new Text("font-family: monospace;"), (MetaData)$md3);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("nav nav-tabs"), (MetaData)$md4);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n            "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tab"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("href", (Seq)new Text("#codegrid"), (MetaData)$md5);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Codegrid"));
        $buf7.$amp$plus((Object)new Elem(null, "a", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf7.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf6.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n            "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tab"), (MetaData)$md6);
        $md6 = new UnprefixedAttribute("href", (Seq)new Text("#statementlist"), (MetaData)$md6);
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("Statement List"));
        $buf9.$amp$plus((Object)new Elem(null, "a", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf9.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("tab-content"), (MetaData)$md7);
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n          "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("id", (Seq)new Text("codegrid"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("class", (Seq)new Text("tab-pane active"), (MetaData)$md8);
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n            "));
        $buf12.$amp$plus((Object)Unparsed$.MODULE$.apply(new CodeGrid(mfile, this.sourceEncoding).highlighted()));
        $buf12.$amp$plus((Object)new Text("\n          "));
        $buf11.$amp$plus((Object)new Elem(null, "div", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
        $buf11.$amp$plus((Object)new Text("\n          "));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("id", (Seq)new Text("statementlist"), (MetaData)$md9);
        $md9 = new UnprefixedAttribute("class", (Seq)new Text("tab-pane"), (MetaData)$md9);
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("\n            "));
        $buf13.$amp$plus((Object)new StatementWriter(mfile).output());
        $buf13.$amp$plus((Object)new Text("\n          "));
        $buf11.$amp$plus((Object)new Elem(null, "div", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13)));
        $buf11.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "html", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    /*
     * WARNING - void declaration
     */
    public Elem header() {
        void var2_2;
        String css = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(".meter {\n                |        height: 14px;\n                |        position: relative;\n                |        background: #BB2020;\n                |}\n                |\n                |.meter span {\n                |\tdisplay: block;\n                |\theight: 100%;\n                |\tbackground-color: rgb(43,194,83);\n                |\tbackground-image: -webkit-gradient(\n                |\t  linear,\n                |\t  left bottom,\n                |\t  left top,\n                |\t  color-stop(0, rgb(43,194,83)),\n                |\t  color-stop(1, rgb(84,240,84))\n                |\t );\n                |\tbackground-image: -webkit-linear-gradient(\n                |\t  center bottom,\n                |\t  rgb(43,194,83) 37%,\n                |\t  rgb(84,240,84) 69%\n                |\t );\n                |\tbackground-image: -moz-linear-gradient(\n                |\t  center bottom,\n                |\t  rgb(43,194,83) 37%,\n                |\t  rgb(84,240,84) 69%\n                |\t );\n                |\tbackground-image: -ms-linear-gradient(\n                |\t  center bottom,\n                |\t  rgb(43,194,83) 37%,\n                |\t  rgb(84,240,84) 69%\n                |\t );\n                |\tbackground-image: -o-linear-gradient(\n                |\t  center bottom,\n                |\t  rgb(43,194,83) 37%,\n                |\t  rgb(84,240,84) 69%\n                |\t );\n                |\t-webkit-box-shadow:\n                |\t  inset 0 2px 9px  rgba(255,255,255,0.3),\n                |\t  inset 0 -2px 6px rgba(0,0,0,0.4);\n                |\t-moz-box-shadow:\n                |\t  inset 0 2px 9px  rgba(255,255,255,0.3),\n                |\t  inset 0 -2px 6px rgba(0,0,0,0.4);\n                |\tposition: relative;\n                |\toverflow: hidden;\n                |}"));
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("content", (Seq)new Text("text/html; charset=utf-8"), (MetaData)$md);
        $md = new UnprefixedAttribute("http-equiv", (Seq)new Text("Content-Type"), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "meta", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("id", (Seq)new Text("title"), (MetaData)$md2);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Scoverage Code Coverage"));
        $buf.$amp$plus((Object)new Elem(null, "title", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)this.plugins());
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)css);
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "style", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "head", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public Node packageOverview(MeasuredPackage pack) {
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)this.header());
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", (Seq)new Text("font-family: monospace;"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)this.classesTable((Iterable<MeasuredClass>)pack.classes(), false));
        $buf2.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "html", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
    }

    public Node classesTable(Iterable<MeasuredClass> classes, boolean addPath) {
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", (Seq)new Text("font-size:13px"), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("tablesorter table table-striped"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n            Class\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n            Source file\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n            Lines\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n            Methods\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n            Statements\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n            Invoked\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n            Coverage\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n            Branches\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("\n            Invoked\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("\n            Coverage\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf14)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)new Text("\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf15)));
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("\n        "));
        $buf16.$amp$plus(((IterableOps)classes.toSeq().sortBy((Function1 & Serializable)x$1 -> x$1.fullClassName(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)klass -> this.classRow((MeasuredClass)klass)));
        $buf16.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf16)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    public Node classRow(MeasuredClass klass) {
        File fileRelativeToSource = new File(new StringBuilder(5).append(this.relativeSource(klass.source())).append(".html").toString());
        String path = fileRelativeToSource.getParent();
        String value = fileRelativeToSource.getName();
        String filename = path != "" ? fileRelativeToSource.toString().replace(File.separator, "/") : value;
        String statement0f = Integer.toString((int)Math.round(klass.statementCoveragePercent()));
        String branch0f = Integer.toString((int)Math.round(klass.branchCoveragePercent()));
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("href", filename, (MetaData)$md);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        $buf3.$amp$plus((Object)klass.displayClassName());
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus(klass.statements().headOption().map((Function1 & Serializable)x$2 -> (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(x$2.source()), File.separatorChar)))).getOrElse((Function0 & Serializable)() -> ""));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)Integer.toString(klass.loc()));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus((Object)Integer.toString(klass.methodCount()));
        $buf6.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n        "));
        $buf7.$amp$plus((Object)Integer.toString(klass.statementCount()));
        $buf7.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf8.$amp$plus((Object)Integer.toString(klass.invokedStatementCount()));
        $buf8.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("meter"), (MetaData)$md2);
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("style", new StringBuilder(8).append("width: ").append(statement0f).append("%").toString(), (MetaData)$md3);
        $buf10.$amp$plus((Object)new Elem(null, "span", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf10.$amp$plus((Object)new Text("\n        "));
        $buf9.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf9.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n        "));
        $buf11.$amp$plus((Object)klass.statementCoverageFormatted());
        $buf11.$amp$plus((Object)new Text("\n        %\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n        "));
        $buf12.$amp$plus((Object)Integer.toString(klass.branchCount()));
        $buf12.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("\n        "));
        $buf13.$amp$plus((Object)Integer.toString(klass.invokedBranchesCount()));
        $buf13.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("\n        "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("meter"), (MetaData)$md4);
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)new Text("\n          "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("style", new StringBuilder(8).append("width: ").append(branch0f).append("%").toString(), (MetaData)$md5);
        $buf15.$amp$plus((Object)new Elem(null, "span", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf15.$amp$plus((Object)new Text("\n        "));
        $buf14.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf15)));
        $buf14.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf14)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("\n        "));
        $buf16.$amp$plus((Object)klass.branchCoverageFormatted());
        $buf16.$amp$plus((Object)new Text("\n        %\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf16)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    /*
     * WARNING - void declaration
     */
    public Node packageList(Coverage coverage) {
        void var2_2;
        void var3_3;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("content", (Seq)new Text("text/html; charset=utf-8"), (MetaData)$md);
        $md = new UnprefixedAttribute("http-equiv", (Seq)new Text("Content-Type"), (MetaData)$md);
        $buf2.$amp$plus((Object)new Elem(null, "meta", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("id", (Seq)new Text("title"), (MetaData)$md2);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          Scoverage Code Coverage\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "title", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)this.plugins());
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "head", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("style", (Seq)new Text("font-family: monospace;"), (MetaData)$md3);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("style", (Seq)new Text("font-size: 13px"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("tablesorter table table-striped"), (MetaData)$md4);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n                "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("target", (Seq)new Text("mainFrame"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("href", (Seq)new Text("overview.html"), (MetaData)$md5);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("All packages"));
        $buf8.$amp$plus((Object)new Elem(null, "a", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf8.$amp$plus((Object)new Text("\n              "));
        $buf7.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf7.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)coverage.statementCoverageFormatted());
        $buf10.$amp$plus((Object)new Text("%"));
        $buf7.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf7.$amp$plus((Object)new Text("\n            "));
        $buf6.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf5.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf5.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n            "));
        $buf11.$amp$plus(coverage.packages().map((Function1 & Serializable)arg -> {
            void var2_2;
            void var3_3;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n                "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("target", (Seq)new Text("mainFrame"), (MetaData)$md);
            $md = new UnprefixedAttribute("href", this.packageOverviewRelativePath((MeasuredPackage)arg), (MetaData)$md);
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)arg.name());
            $buf2.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
            $buf2.$amp$plus((Object)new Text("\n              "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)));
            $buf.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)arg.statementCoverageFormatted());
            $buf4.$amp$plus((Object)new Text("%"));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            $buf.$amp$plus((Object)new Text("\n            "));
            return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
        }));
        $buf11.$amp$plus((Object)new Text("\n          "));
        $buf5.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)new Elem(null, "table", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "html", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
    }

    public Elem risks(Coverage coverage, int limit) {
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", (Seq)new Text("font-size: 12px"), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("tablesorter table table-striped"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n            Class\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n            Lines\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n            Methods\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n            Statements\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n            Statement Rate\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n            Branches\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n            Branch Rate\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n        "));
        $buf11.$amp$plus(coverage.risks(limit).map((Function1 & Serializable)klass -> {
            void var1_1;
            void var3_3;
            void var2_2;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n            "));
            $buf2.$amp$plus((Object)klass.displayClassName());
            $buf2.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2)));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n            "));
            $buf3.$amp$plus((Object)Integer.toString(klass.loc()));
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n            "));
            $buf4.$amp$plus((Object)Integer.toString(klass.methodCount()));
            $buf4.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new Text("\n            "));
            $buf5.$amp$plus((Object)Integer.toString(klass.statementCount()));
            $buf5.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("\n            "));
            $buf6.$amp$plus((Object)klass.statementCoverageFormatted());
            $buf6.$amp$plus((Object)new Text("\n            %\n          "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)new Text("\n            "));
            $buf7.$amp$plus((Object)Integer.toString(klass.branchCount()));
            $buf7.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf8 = new NodeBuffer();
            $buf8.$amp$plus((Object)new Text("\n            "));
            $buf8.$amp$plus((Object)klass.branchCoverageFormatted());
            $buf8.$amp$plus((Object)new Text("\n            %\n          "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
            $buf.$amp$plus((Object)new Text("\n        "));
            return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
        }));
        $buf11.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    /*
     * WARNING - void declaration
     */
    public Elem packages2(Coverage coverage) {
        void var3_3;
        scala.collection.immutable.Seq rows = (scala.collection.immutable.Seq)coverage.packages().map((Function1 & Serializable)arg -> {
            void var1_1;
            void var3_3;
            void var2_2;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)arg.name());
            $buf2.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2)));
            $buf.$amp$plus((Object)new Text("\n        "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf3.$amp$plus((Object)Integer.toString(arg.invokedClasses()));
            $buf3.$amp$plus((Object)new Text("\n          /\n          "));
            $buf3.$amp$plus((Object)BoxesRunTime.boxToInteger((int)arg.classCount()));
            $buf3.$amp$plus((Object)new Text("\n          (\n          "));
            $buf3.$amp$plus((Object)Double.toString(arg.classCoverage()));
            $buf3.$amp$plus((Object)new Text("\n          %)\n        "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)));
            $buf.$amp$plus((Object)new Text("\n        "));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n          "));
            $buf4.$amp$plus((Object)arg.invokedStatements().toString());
            $buf4.$amp$plus((Object)new Text("\n          /\n          "));
            $buf4.$amp$plus((Object)BoxesRunTime.boxToInteger((int)arg.statementCount()));
            $buf4.$amp$plus((Object)new Text("\n          (\n          "));
            $buf4.$amp$plus((Object)arg.statementCoverageFormatted());
            $buf4.$amp$plus((Object)new Text("\n          %)\n        "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            $buf.$amp$plus((Object)new Text("\n      "));
            return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
        });
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)rows);
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public Node overview(Coverage coverage) {
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)this.header());
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", (Seq)new Text("font-family: monospace;"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("alert alert-info"), (MetaData)$md2);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          SCoverage\n        "));
        $buf3.$amp$plus((Object)new Elem(null, "b", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf3.$amp$plus((Object)new Text("\n        generated at\n        "));
        $buf3.$amp$plus((Object)new Date().toString());
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("overview"), (MetaData)$md3);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("stats"), (MetaData)$md4);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus((Object)this.stats(coverage));
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf5.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n          "));
        $buf7.$amp$plus((Object)this.classesTable((Iterable<MeasuredClass>)coverage.classes(), true));
        $buf7.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf2.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "html", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
    }

    public Node stats(Coverage coverage) {
        String statement0f = Integer.toString((int)Math.round(coverage.statementCoveragePercent()));
        String branch0f = Integer.toString((int)Math.round(coverage.branchCoveragePercent()));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("table"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          Lines of code:\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          "));
        $buf4.$amp$plus((Object)Integer.toString(coverage.loc()));
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n          Files:\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus((Object)Integer.toString(coverage.fileCount()));
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n          Classes:\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n          "));
        $buf8.$amp$plus((Object)Integer.toString(coverage.classCount()));
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n          Methods:\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n          "));
        $buf10.$amp$plus((Object)Integer.toString(coverage.methodCount()));
        $buf10.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n          Lines per file:\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("\n          "));
        $buf13.$amp$plus((Object)coverage.linesPerFileFormatted());
        $buf13.$amp$plus((Object)new Text("\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13)));
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("\n          Packages:\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf14)));
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)new Text("\n          "));
        $buf15.$amp$plus((Object)Integer.toString(coverage.packageCount()));
        $buf15.$amp$plus((Object)new Text("\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf15)));
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("\n          Classes per package:\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf16)));
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf17 = new NodeBuffer();
        $buf17.$amp$plus((Object)new Text("\n          "));
        $buf17.$amp$plus((Object)coverage.avgClassesPerPackageFormatted());
        $buf17.$amp$plus((Object)new Text("\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf17)));
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf18 = new NodeBuffer();
        $buf18.$amp$plus((Object)new Text("\n          Methods per class:\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf18)));
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf19 = new NodeBuffer();
        $buf19.$amp$plus((Object)new Text("\n          "));
        $buf19.$amp$plus((Object)coverage.avgMethodsPerClassFormatted());
        $buf19.$amp$plus((Object)new Text("\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf19)));
        $buf11.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf20 = new NodeBuffer();
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf21 = new NodeBuffer();
        $buf21.$amp$plus((Object)new Text("\n          Total statements:\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf21)));
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf22 = new NodeBuffer();
        $buf22.$amp$plus((Object)new Text("\n          "));
        $buf22.$amp$plus((Object)Integer.toString(coverage.statementCount()));
        $buf22.$amp$plus((Object)new Text("\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf22)));
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf23 = new NodeBuffer();
        $buf23.$amp$plus((Object)new Text("\n          Invoked statements:\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf23)));
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf24 = new NodeBuffer();
        $buf24.$amp$plus((Object)new Text("\n          "));
        $buf24.$amp$plus((Object)Integer.toString(coverage.invokedStatementCount()));
        $buf24.$amp$plus((Object)new Text("\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf24)));
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf25 = new NodeBuffer();
        $buf25.$amp$plus((Object)new Text("\n          Total branches:\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf25)));
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf26 = new NodeBuffer();
        $buf26.$amp$plus((Object)new Text("\n          "));
        $buf26.$amp$plus((Object)Integer.toString(coverage.branchCount()));
        $buf26.$amp$plus((Object)new Text("\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf26)));
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf27 = new NodeBuffer();
        $buf27.$amp$plus((Object)new Text("\n          Invoked branches:\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf27)));
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf28 = new NodeBuffer();
        $buf28.$amp$plus((Object)new Text("\n          "));
        $buf28.$amp$plus((Object)Integer.toString(coverage.invokedBranchesCount()));
        $buf28.$amp$plus((Object)new Text("\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf28)));
        $buf20.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf20)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf29 = new NodeBuffer();
        $buf29.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf30 = new NodeBuffer();
        $buf30.$amp$plus((Object)new Text("\n          Ignored statements:\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf30)));
        $buf29.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf31 = new NodeBuffer();
        $buf31.$amp$plus((Object)new Text("\n          "));
        $buf31.$amp$plus((Object)Integer.toString(coverage.ignoredStatementCount()));
        $buf31.$amp$plus((Object)new Text("\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf31)));
        $buf29.$amp$plus((Object)new Text("\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf29.$amp$plus((Object)new Text("\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf29.$amp$plus((Object)new Text("\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf29.$amp$plus((Object)new Text("\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf29.$amp$plus((Object)new Text("\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf29.$amp$plus((Object)new Text("\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf29.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf29)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf32 = new NodeBuffer();
        $buf32.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf33 = new NodeBuffer();
        $buf33.$amp$plus((Object)new Text("\n          Statement coverage:\n        "));
        $buf32.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf33)));
        $buf32.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf34 = new NodeBuffer();
        $buf34.$amp$plus((Object)new Text("\n          "));
        $buf34.$amp$plus((Object)coverage.statementCoverageFormatted());
        $buf34.$amp$plus((Object)new Text("\n          %\n        "));
        $buf32.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf34)));
        $buf32.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("colspan", (Seq)new Text("2"), (MetaData)$md2);
        NodeBuffer $buf35 = new NodeBuffer();
        $buf35.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("meter"), (MetaData)$md3);
        NodeBuffer $buf36 = new NodeBuffer();
        $buf36.$amp$plus((Object)new Text("\n            "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("style", new StringBuilder(8).append("width: ").append(statement0f).append("%").toString(), (MetaData)$md4);
        $buf36.$amp$plus((Object)new Elem(null, "span", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf36.$amp$plus((Object)new Text("\n          "));
        $buf35.$amp$plus((Object)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf36)));
        $buf35.$amp$plus((Object)new Text("\n        "));
        $buf32.$amp$plus((Object)new Elem(null, "td", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf35)));
        $buf32.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf37 = new NodeBuffer();
        $buf37.$amp$plus((Object)new Text("\n          Branch coverage:\n        "));
        $buf32.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf37)));
        $buf32.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf38 = new NodeBuffer();
        $buf38.$amp$plus((Object)new Text("\n          "));
        $buf38.$amp$plus((Object)coverage.branchCoverageFormatted());
        $buf38.$amp$plus((Object)new Text("\n          %\n        "));
        $buf32.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf38)));
        $buf32.$amp$plus((Object)new Text("\n        "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("colspan", (Seq)new Text("2"), (MetaData)$md5);
        NodeBuffer $buf39 = new NodeBuffer();
        $buf39.$amp$plus((Object)new Text("\n          "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("class", (Seq)new Text("meter"), (MetaData)$md6);
        NodeBuffer $buf40 = new NodeBuffer();
        $buf40.$amp$plus((Object)new Text("\n            "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("style", new StringBuilder(8).append("width: ").append(branch0f).append("%").toString(), (MetaData)$md7);
        $buf40.$amp$plus((Object)new Elem(null, "span", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf40.$amp$plus((Object)new Text("\n          "));
        $buf39.$amp$plus((Object)new Elem(null, "div", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf40)));
        $buf39.$amp$plus((Object)new Text("\n        "));
        $buf32.$amp$plus((Object)new Elem(null, "td", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf39)));
        $buf32.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf32)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    public NodeBuffer plugins() {
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("src", (Seq)new Text("https://ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("href", (Seq)new Text("https://cdnjs.cloudflare.com/ajax/libs/jquery.tablesorter/2.20.1/css/theme.default.min.css"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("src", (Seq)new Text("https://cdnjs.cloudflare.com/ajax/libs/jquery.tablesorter/2.20.1/js/jquery.tablesorter.min.js"), (MetaData)$md3);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("href", (Seq)new Text("https://netdna.bootstrapcdn.com/bootstrap/3.0.3/css/bootstrap.min.css"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("src", (Seq)new Text("https://netdna.bootstrapcdn.com/bootstrap/3.0.3/js/bootstrap.min.js"), (MetaData)$md5);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("type", (Seq)new Text("text/javascript"), (MetaData)$md6);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)Unparsed$.MODULE$.apply("$(document).ready(function() {$(\".tablesorter\").tablesorter();});"));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        return $buf;
    }

    public ScoverageHtmlWriter(scala.collection.immutable.Seq<File> sourceDirectories, File outputDir, Option<String> sourceEncoding) {
        this.outputDir = outputDir;
        this.sourceEncoding = sourceEncoding;
        super(sourceDirectories, outputDir, sourceEncoding);
    }

    public ScoverageHtmlWriter(File[] sourceDirectories, File outputDir, Option<String> sourceEncoding) {
        this((scala.collection.immutable.Seq<File>)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])sourceDirectories)), outputDir, sourceEncoding);
    }

    public ScoverageHtmlWriter(scala.collection.immutable.Seq<File> sourceDirectories, File outputDir) {
        this(sourceDirectories, outputDir, (Option<String>)None$.MODULE$);
    }

    public ScoverageHtmlWriter(File sourceDirectory, File outputDir) {
        this((scala.collection.immutable.Seq<File>)new .colon.colon((Object)sourceDirectory, (List)Nil$.MODULE$), outputDir);
    }
}

