/*
 * Decompiled with CFR 0.152.
 */
package scoverage.reporter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scoverage.domain.Constants$;

public final class IOUtils$ {
    public static final IOUtils$ MODULE$ = new IOUtils$();
    private static final char UnixSeperator = (char)47;
    private static final char WindowsSeperator = (char)92;
    private static final Function1<File, Object> isMeasurementFile = (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)IOUtils$.$anonfun$isMeasurementFile$1(file));
    private static final Function1<File, Object> isReportFile = (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)IOUtils$.$anonfun$isReportFile$1(file));
    private static final Function1<File, Object> isDebugReportFile = (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)IOUtils$.$anonfun$isDebugReportFile$1(file));

    public File getTempDirectory() {
        return new File(this.getTempPath());
    }

    public String getTempPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public String readStreamAsString(InputStream in) {
        return Source$.MODULE$.fromInputStream(in, Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    private char UnixSeperator() {
        return UnixSeperator;
    }

    private char WindowsSeperator() {
        return WindowsSeperator;
    }

    public Object getName(String path) {
        int lastUnixPos = path.lastIndexOf(this.UnixSeperator());
        int lastWindowsPos = path.lastIndexOf(this.WindowsSeperator());
        int index = Math.max(lastUnixPos, lastWindowsPos);
        return StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(path), index + 1);
    }

    public File reportFile(File outputDir, boolean debug) {
        boolean bl = debug;
        if (bl) {
            return new File(outputDir, Constants$.MODULE$.XMLReportFilenameWithDebug());
        }
        if (!bl) {
            return new File(outputDir, Constants$.MODULE$.XMLReportFilename());
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    public boolean reportFile$default$2() {
        return false;
    }

    public void clean(File dataDir) {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.findMeasurementFiles(dataDir)), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.delete()));
    }

    public void clean(String dataDir) {
        this.clean(new File(dataDir));
    }

    public void writeToFile(File file, String str, Option<String> encoding) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), (String)encoding.getOrElse((Function0 & Serializable)() -> Codec$.MODULE$.UTF8().name())));){
            writer.write(str);
        }
    }

    public File measurementFile(File dataDir) {
        return this.measurementFile(dataDir.getAbsolutePath());
    }

    public File measurementFile(String dataDir) {
        return new File(dataDir, new StringBuilder(0).append(Constants$.MODULE$.MeasurementsPrefix()).append(Thread.currentThread().getId()).toString());
    }

    public File[] findMeasurementFiles(String dataDir) {
        return this.findMeasurementFiles(new File(dataDir));
    }

    public File[] findMeasurementFiles(File dataDir) {
        return dataDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().startsWith(Constants$.MODULE$.MeasurementsPrefix());
            }
        });
    }

    public Seq<File> scoverageDataDirsSearch(File baseDir) {
        return IOUtils$.search$1(baseDir);
    }

    public Function1<File, Object> isMeasurementFile() {
        return isMeasurementFile;
    }

    public Function1<File, Object> isReportFile() {
        return isReportFile;
    }

    public Function1<File, Object> isDebugReportFile() {
        return isDebugReportFile;
    }

    public Set<Tuple2<Object, String>> invoked(Seq<File> files, String encoding) {
        scala.collection.mutable.Set acc = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        files.foreach((Function1 & Serializable)file -> {
            IOUtils$.$anonfun$invoked$1(encoding, acc, file);
            return BoxedUnit.UNIT;
        });
        return acc;
    }

    public String invoked$default$2() {
        return Codec$.MODULE$.UTF8().name();
    }

    private static final FileFilter directoryFilter$1() {
        return new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        };
    }

    private static final Seq search$1(File file2) {
        File file3 = file2;
        if (file3.isDirectory()) {
            String string = file3.getName();
            String string2 = Constants$.MODULE$.DataDir();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return new .colon.colon((Object)file3, (List)Nil$.MODULE$);
            }
        }
        if (file3.isDirectory()) {
            return (Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])file3.listFiles(IOUtils$.directoryFilter$1()))).flatMap((Function1 & Serializable)file -> IOUtils$.search$1(file));
        }
        return Nil$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$isMeasurementFile$1(File file) {
        return file.getName().startsWith(Constants$.MODULE$.MeasurementsPrefix());
    }

    public static final /* synthetic */ boolean $anonfun$isReportFile$1(File file) {
        String string = file.getName();
        String string2 = Constants$.MODULE$.XMLReportFilename();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isDebugReportFile$1(File file) {
        String string = file.getName();
        String string2 = Constants$.MODULE$.XMLReportFilenameWithDebug();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$invoked$1(String encoding$1, scala.collection.mutable.Set acc$1, File file) {
        BufferedSource reader = Source$.MODULE$.fromFile(file, encoding$1);
        reader.getLines().foreach((Function1 & Serializable)line -> {
            if (!line.isEmpty()) {
                SeqOps seqOps;
                Tuple2 tuple2;
                SeqOps seqOps2;
                List list = Predef$.MODULE$.wrapRefArray((Object[])line.split(" ")).toList();
                if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.List().unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2) == 0) {
                    String idx = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
                    String clazz = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(idx))), (Object)clazz);
                } else if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                    String idx = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(idx))), (Object)"");
                } else {
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)"");
                }
                return acc$1.$plus$eq((Object)tuple2);
            }
            return BoxedUnit.UNIT;
        });
        reader.close();
    }

    private IOUtils$() {
    }
}

