/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.templater;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class Templater {
    private static final String PACKAGE_FOLDER_PLACEHOLDER = "__packageInPathFormat__";
    private static final String MAIN_CLASS_FILE_PLACEHOLDER = "__mainClass__";
    private static final Set<String> SUBSTITUTED_PLACEHOLDER_FILES_EXTENSIONS = new HashSet<String>(Arrays.asList("xml", "java"));
    private static final String DOLLAR_SYMBOL_PLACEHOLDER = Pattern.quote("${symbol_dollar}");
    private static final String PACKAGE_PLACEHOLDER = Pattern.quote("package ${package};");
    private static final String MAIN_CLASS_PLACEHOLDER = Pattern.quote("${mainClass}");
    private static final String MAVEN_ARCHETYPE_SET_PLACEHOLDER = "#set\\(.*\\)\n";
    private static final String ROBOVM_PROPERTIES_FILE = "robovm.properties";
    private static final String ROBOVM_PROPERTIES_PACKAGE_PLACEHOLDER = Pattern.quote("${package}");
    private static final String ROBOVM_PROPERTIES_MAIN_CLASS_PLACEHOLDER = Pattern.quote("${mainClass}");
    private static final String ROBOVM_PROPERTIES_APP_NAME_PLACEHOLDER = Pattern.quote("${appName}");
    private static final String ANDROID_MANIFEST_FILE = "AndroidManifest.xml";
    private static final String ANDROID_MANIFEST_PACKAGE_PLACEHOLDER = Pattern.quote("${package}");
    private static final String ANDROID_MANIFEST_MAIN_CLASS_PLACEHOLDER = Pattern.quote("${mainClass}");
    private static final String ANDROID_STRINGS_APP_NAME_PLACEHOLDER = Pattern.quote("${appName}");
    private static final String ANDROID_BUILD_FILE = "build.gradle";
    private static final String ANDROID_SDK_VERSION = Pattern.quote("${androidSdkVersion}");
    private static final String ANDROID_BUILD_TOOLS_VERSION = Pattern.quote("${androidBuildToolsVersion}");
    private static final String ANDROID_STRINGS_FILE = "strings.xml";
    private final String template;
    private final URL templateURL;
    private String mainClass;
    private String mainClassName;
    private String packageName;
    private String packageDirName;
    private String appName;
    private String appId;
    private String executable;
    private String androidSdkVersion = "23";
    private String androidBuildToolsVersion = "\"23.0.1\"";

    public Templater(String template) {
        if (template == null) {
            throw new IllegalArgumentException("No template specified");
        }
        this.template = template;
        this.templateURL = Templater.class.getResource("/templates/robovm-" + template + "-template.tar.gz");
        if (this.templateURL == null) {
            throw new IllegalArgumentException(String.format("Template with name '%s' doesn't exist!", template));
        }
    }

    public Templater mainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public Templater packageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public Templater appName(String appName) {
        this.appName = appName;
        return this;
    }

    public Templater appId(String appId) {
        this.appId = appId;
        return this;
    }

    public Templater executable(String executable) {
        this.executable = executable;
        return this;
    }

    public Templater androidSdkVersion(String androidSdkVersion) {
        this.androidSdkVersion = androidSdkVersion;
        return this;
    }

    public Templater androidBuildToolsVersion(String androidBuildToolsVersion) {
        this.androidBuildToolsVersion = androidBuildToolsVersion;
        return this;
    }

    public void buildProject(File projectRoot) {
        if (projectRoot == null) {
            throw new NullPointerException("projectRoot");
        }
        if (this.mainClass == null) {
            throw new IllegalArgumentException("No main class specified");
        }
        this.mainClassName = this.mainClass.substring(this.mainClass.lastIndexOf(46) + 1);
        if (this.executable == null || this.executable.length() == 0) {
            this.executable = this.mainClassName;
        }
        if (this.appName == null || this.appName.length() == 0) {
            this.appName = this.mainClassName;
        }
        if (this.packageName == null || this.packageName.length() == 0) {
            int index = this.mainClass.lastIndexOf(46);
            this.packageName = index == -1 ? "" : this.mainClass.substring(0, index);
        }
        this.packageDirName = this.packageName.replace('.', '/');
        if (this.appId == null || this.appId.length() == 0) {
            this.appId = this.packageName;
            if (this.appId == null || this.appId.length() == 0) {
                this.appId = this.mainClassName;
            }
        }
        try {
            File targetFile = new File(projectRoot, FilenameUtils.getBaseName((String)this.templateURL.getPath()));
            FileUtils.copyURLToFile((URL)this.templateURL, (File)targetFile);
            this.extractArchive(targetFile, targetFile.getParentFile());
            targetFile.delete();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractArchive(File archive, File destDir) throws IOException {
        TarArchiveInputStream in = null;
        try {
            in = new TarArchiveInputStream((InputStream)new GZIPInputStream(new FileInputStream(archive)));
            ArchiveEntry entry = null;
            while ((entry = in.getNextEntry()) != null) {
                File f = new File(destDir, this.substitutePlaceholdersInFileName(entry.getName()));
                if (entry.isDirectory()) {
                    f.mkdirs();
                    continue;
                }
                f.getParentFile().mkdirs();
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(f);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)out);
                this.substitutePlaceholdersInFile(f);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    private String substitutePlaceholdersInFileName(String fileName) {
        fileName = fileName.replaceAll(PACKAGE_FOLDER_PLACEHOLDER, this.packageDirName);
        fileName = fileName.replaceAll(MAIN_CLASS_FILE_PLACEHOLDER, this.mainClassName);
        return fileName;
    }

    private void substitutePlaceholdersInFile(File file) throws IOException {
        String extension = FilenameUtils.getExtension((String)file.getName());
        if (ROBOVM_PROPERTIES_FILE.equals(file.getName())) {
            String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
            content = content.replace("\r", "");
            content = content.replaceAll(Pattern.quote("app.id=${package}"), "app.id=" + this.appId);
            content = content.replaceAll(ROBOVM_PROPERTIES_APP_NAME_PLACEHOLDER, this.appName);
            content = content.replaceAll(ROBOVM_PROPERTIES_MAIN_CLASS_PLACEHOLDER, this.mainClassName);
            String propsPackageName = this.packageName == null || this.packageName.length() == 0 ? "" : this.packageName;
            content = content.replaceAll(ROBOVM_PROPERTIES_PACKAGE_PLACEHOLDER, propsPackageName);
            content = content.replaceAll(Pattern.quote("mainclass=."), "mainclass=");
            FileUtils.writeStringToFile((File)file, (String)content, (String)"UTF-8");
        } else if (ANDROID_MANIFEST_FILE.equals(file.getName())) {
            String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
            content = content.replace("\r", "");
            String propsPackageName = this.packageName == null || this.packageName.length() == 0 ? "" : this.packageName;
            content = content.replaceAll(ANDROID_MANIFEST_PACKAGE_PLACEHOLDER, propsPackageName);
            content = content.replaceAll(ANDROID_MANIFEST_MAIN_CLASS_PLACEHOLDER, this.mainClassName);
            FileUtils.writeStringToFile((File)file, (String)content, (String)"UTF-8");
        } else if (ANDROID_STRINGS_FILE.equals(file.getName())) {
            String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
            content = content.replace("\r", "");
            content = content.replaceAll(ANDROID_STRINGS_APP_NAME_PLACEHOLDER, this.appName);
            FileUtils.writeStringToFile((File)file, (String)content, (String)"UTF-8");
        } else if (ANDROID_BUILD_FILE.equals(file.getName())) {
            String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
            content = content.replace("\r", "");
            content = content.replaceAll(ANDROID_SDK_VERSION, this.androidSdkVersion);
            content = content.replaceAll(ANDROID_BUILD_TOOLS_VERSION, "\"" + this.androidBuildToolsVersion + "\"");
            FileUtils.writeStringToFile((File)file, (String)content, (String)"UTF-8");
        } else if (SUBSTITUTED_PLACEHOLDER_FILES_EXTENSIONS.contains(extension)) {
            String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
            content = content.replace("\r", "");
            content = content.replaceAll(MAVEN_ARCHETYPE_SET_PLACEHOLDER, "");
            content = content.replaceAll(DOLLAR_SYMBOL_PLACEHOLDER, Matcher.quoteReplacement("$"));
            content = content.replaceAll(PACKAGE_PLACEHOLDER, Templater.getPackageNameReplacement(this.packageName));
            content = content.replaceAll(MAIN_CLASS_PLACEHOLDER, this.mainClassName);
            FileUtils.writeStringToFile((File)file, (String)content, (String)"UTF-8");
        }
    }

    private static String getPackageNameReplacement(String packageName) {
        if (packageName == null || packageName.length() == 0) {
            return "";
        }
        return String.format("package %s;", packageName);
    }

    public static void main(String[] args) {
        if (args.length <= 1) {
            Templater.printHelpText();
            return;
        }
        String template = null;
        String mainClass = null;
        String packageName = null;
        String appName = null;
        String appId = null;
        String executable = null;
        File projectRoot = null;
        String androidSdkVersion = null;
        String androidBuildToolsVersion = null;
        for (int i = 0; i < args.length; i += 2) {
            if (Templater.isOption(args[i])) {
                if (args[i].length() <= 1) {
                    throw new IllegalArgumentException("invalid option: " + args[i]);
                }
                char option = args[i].charAt(1);
                switch (option) {
                    case 't': {
                        template = Templater.getOptionValue(args, i);
                        break;
                    }
                    case 'c': {
                        mainClass = Templater.getOptionValue(args, i);
                        break;
                    }
                    case 'p': {
                        packageName = Templater.getOptionValue(args, i);
                        break;
                    }
                    case 'n': {
                        appName = Templater.getOptionValue(args, i);
                        break;
                    }
                    case 'i': {
                        appId = Templater.getOptionValue(args, i);
                        break;
                    }
                    case 'e': {
                        executable = Templater.getOptionValue(args, i);
                        break;
                    }
                    case 'g': {
                        projectRoot = new File(Templater.getOptionValue(args, i));
                        break;
                    }
                    case 'a': {
                        androidSdkVersion = Templater.getOptionValue(args, i);
                        break;
                    }
                    case 'b': {
                        androidBuildToolsVersion = "\"" + Templater.getOptionValue(args, i) + "\"";
                    }
                }
                continue;
            }
            Templater.printHelpText();
        }
        new Templater(template).mainClass(mainClass).packageName(packageName).appName(appName).appId(appId).executable(executable).buildProject(projectRoot);
        System.out.println("Project created in " + projectRoot.getAbsolutePath());
    }

    private static boolean isOption(String arg) {
        return arg.startsWith("-");
    }

    private static String getOptionValue(String[] args, int option) {
        if (args.length < option + 1) {
            throw new IllegalArgumentException("value missing for option: " + args[option]);
        }
        String value = args[option + 1];
        if (Templater.isOption(value)) {
            throw new IllegalArgumentException("illegal value for option: " + args[option]);
        }
        return value;
    }

    private static void printHelpText() {
        System.out.println("RoboVM Templater\nGenerates a new RoboVM project from a template\nUsage: templater\n-t <TEMPLATE>                        template (required)\n-c <CLASS>                           main class (required)\n-p <PACKAGE>                         package name\n-n <NAME>                            app name\n-i <ID>                              app id\n-e <EXECUTABLE>                      executable name\n-g <PROJECT_ROOT>                    generates project to project root (required)\n-a <ANDROID_SDK_VERSION>             Android SDK version, default 23 (optional)\n-b <ANDROID_BUILD_TOOLS_VERSION>     Android build tools version, default 23.0.1 (optional)\n");
    }
}

