/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle.config;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.immutables.value.Value;
import org.revapi.gradle.config.AcceptedBreak;
import org.revapi.gradle.config.GroupAndName;
import org.revapi.gradle.config.ImmutablePerProjectAcceptedBreaks;

@JsonDeserialize(as=ImmutablePerProjectAcceptedBreaks.class)
@Value.Immutable
abstract class PerProjectAcceptedBreaks {
    PerProjectAcceptedBreaks() {
    }

    @JsonValue
    @Value.NaturalOrder
    protected abstract SortedMap<GroupAndName, SortedSet<AcceptedBreak>> acceptedBreaks();

    public Set<AcceptedBreak> acceptedBreaksFor(GroupAndName groupAndName) {
        return this.acceptedBreaks().getOrDefault(groupAndName, Collections.emptySortedSet());
    }

    public PerProjectAcceptedBreaks merge(GroupAndName groupAndName, Set<AcceptedBreak> acceptedBreaks) {
        if (acceptedBreaks.isEmpty()) {
            return this;
        }
        TreeMap<GroupAndName, SortedSet<AcceptedBreak>> mergedAcceptedBreaks = new TreeMap<GroupAndName, SortedSet<AcceptedBreak>>(this.acceptedBreaks());
        TreeSet<AcceptedBreak> newAcceptedBreaks = new TreeSet<AcceptedBreak>(this.acceptedBreaks().getOrDefault(groupAndName, Collections.emptySortedSet()));
        newAcceptedBreaks.addAll(acceptedBreaks);
        mergedAcceptedBreaks.put(groupAndName, newAcceptedBreaks);
        return PerProjectAcceptedBreaks.builder().putAllAcceptedBreaks(mergedAcceptedBreaks).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PerProjectAcceptedBreaks empty() {
        return PerProjectAcceptedBreaks.builder().build();
    }

    static final class Builder
    extends ImmutablePerProjectAcceptedBreaks.Builder {
        Builder() {
        }
    }
}

