/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle.config;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.revapi.gradle.config.ImmutableJustification;

@JsonDeserialize(as=ImmutableJustification.class)
@Value.Immutable
@Serial.Structural
public interface Justification {
    public static final String YOU_MUST_ENTER_JUSTIFICATION = "{why this break is ok}";

    @JsonValue
    public String asString();

    @Value.Check
    default public void check() {
        if (this.asString().equals(YOU_MUST_ENTER_JUSTIFICATION)) {
            throw new IllegalArgumentException("You must enter a justification other than {why this break is ok}");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Justification fromString(String justification) {
        return Justification.builder().asString(justification).build();
    }

    public static class Builder
    extends ImmutableJustification.Builder {
    }
}

