/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.revapi.gradle.config.GradleRevapiConfig;
import org.revapi.gradle.config.GroupNameVersion;
import org.revapi.gradle.config.PerProjectAcceptedBreaks;
import org.revapi.gradle.config.Version;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GradleRevapiConfig", generator="Immutables")
@Immutable
final class ImmutableGradleRevapiConfig
extends GradleRevapiConfig {
    private final SortedMap<GroupNameVersion, String> versionOverrides;
    private final SortedMap<Version, PerProjectAcceptedBreaks> acceptedBreaks;

    private ImmutableGradleRevapiConfig(SortedMap<GroupNameVersion, String> versionOverrides, SortedMap<Version, PerProjectAcceptedBreaks> acceptedBreaks) {
        this.versionOverrides = versionOverrides;
        this.acceptedBreaks = acceptedBreaks;
    }

    @Override
    @JsonProperty(value="versionOverrides")
    protected SortedMap<GroupNameVersion, String> versionOverrides() {
        return this.versionOverrides;
    }

    @Override
    @JsonProperty(value="acceptedBreaks")
    protected SortedMap<Version, PerProjectAcceptedBreaks> acceptedBreaks() {
        return this.acceptedBreaks;
    }

    public final ImmutableGradleRevapiConfig withVersionOverrides(Map<? extends GroupNameVersion, ? extends String> entries) {
        if (this.versionOverrides == entries) {
            return this;
        }
        NavigableMap<GroupNameVersion, String> newValue = ImmutableGradleRevapiConfig.createUnmodifiableSortedMap(false, true, false, entries);
        return new ImmutableGradleRevapiConfig(newValue, this.acceptedBreaks);
    }

    public final ImmutableGradleRevapiConfig withAcceptedBreaks(Map<? extends Version, ? extends PerProjectAcceptedBreaks> entries) {
        if (this.acceptedBreaks == entries) {
            return this;
        }
        NavigableMap<Version, PerProjectAcceptedBreaks> newValue = ImmutableGradleRevapiConfig.createUnmodifiableSortedMap(false, true, false, entries);
        return new ImmutableGradleRevapiConfig(this.versionOverrides, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGradleRevapiConfig && this.equalTo(0, (ImmutableGradleRevapiConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableGradleRevapiConfig another) {
        return this.versionOverrides.equals(another.versionOverrides) && this.acceptedBreaks.equals(another.acceptedBreaks);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.versionOverrides.hashCode();
        h += (h << 5) + this.acceptedBreaks.hashCode();
        return h;
    }

    public String toString() {
        return "GradleRevapiConfig{versionOverrides=" + this.versionOverrides + ", acceptedBreaks=" + this.acceptedBreaks + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGradleRevapiConfig fromJson(Json json) {
        GradleRevapiConfig.Builder builder = new GradleRevapiConfig.Builder();
        if (json.versionOverrides != null) {
            builder.putAllVersionOverrides(json.versionOverrides);
        }
        if (json.acceptedBreaks != null) {
            builder.putAllAcceptedBreaks(json.acceptedBreaks);
        }
        return (ImmutableGradleRevapiConfig)builder.build();
    }

    public static GradleRevapiConfig copyOf(GradleRevapiConfig instance) {
        if (instance instanceof ImmutableGradleRevapiConfig) {
            return (ImmutableGradleRevapiConfig)instance;
        }
        return new GradleRevapiConfig.Builder().from(instance).build();
    }

    private static <K extends Comparable<? super K>, V> NavigableMap<K, V> createUnmodifiableSortedMap(boolean reverse, boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        TreeMap sortedMap;
        TreeMap<Object, V> treeMap = sortedMap = reverse ? new TreeMap(Collections.reverseOrder()) : new TreeMap();
        if (checkNulls || skipNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                Comparable k = (Comparable)e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                sortedMap.put(k, v);
            }
        } else {
            sortedMap.putAll(map);
        }
        return Collections.unmodifiableNavigableMap(sortedMap);
    }

    @Generated(from="GradleRevapiConfig", generator="Immutables")
    @NotThreadSafe
    static class Builder {
        private Map<GroupNameVersion, String> versionOverrides = new LinkedHashMap<GroupNameVersion, String>();
        private Map<Version, PerProjectAcceptedBreaks> acceptedBreaks = new LinkedHashMap<Version, PerProjectAcceptedBreaks>();

        Builder() {
            if (!(this instanceof GradleRevapiConfig.Builder)) {
                throw new UnsupportedOperationException("Use: new GradleRevapiConfig.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final GradleRevapiConfig.Builder from(GradleRevapiConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllVersionOverrides(instance.versionOverrides());
            this.putAllAcceptedBreaks(instance.acceptedBreaks());
            return (GradleRevapiConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GradleRevapiConfig.Builder putVersionOverrides(GroupNameVersion key, String value) {
            this.versionOverrides.put(Objects.requireNonNull(key, "versionOverrides key"), Objects.requireNonNull(value, value == null ? "versionOverrides value for key: " + key : null));
            return (GradleRevapiConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GradleRevapiConfig.Builder putVersionOverrides(Map.Entry<? extends GroupNameVersion, ? extends String> entry) {
            String v;
            GroupNameVersion k = entry.getKey();
            this.versionOverrides.put(Objects.requireNonNull(k, "versionOverrides key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "versionOverrides value for key: " + k : null));
            return (GradleRevapiConfig.Builder)this;
        }

        @JsonProperty(value="versionOverrides")
        @CanIgnoreReturnValue
        public final GradleRevapiConfig.Builder versionOverrides(Map<? extends GroupNameVersion, ? extends String> entries) {
            this.versionOverrides.clear();
            return this.putAllVersionOverrides(entries);
        }

        @CanIgnoreReturnValue
        public final GradleRevapiConfig.Builder putAllVersionOverrides(Map<? extends GroupNameVersion, ? extends String> entries) {
            for (Map.Entry<? extends GroupNameVersion, ? extends String> e : entries.entrySet()) {
                String v;
                GroupNameVersion k = e.getKey();
                this.versionOverrides.put(Objects.requireNonNull(k, "versionOverrides key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "versionOverrides value for key: " + k : null));
            }
            return (GradleRevapiConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GradleRevapiConfig.Builder putAcceptedBreaks(Version key, PerProjectAcceptedBreaks value) {
            this.acceptedBreaks.put(Objects.requireNonNull(key, "acceptedBreaks key"), Objects.requireNonNull(value, value == null ? "acceptedBreaks value for key: " + key : null));
            return (GradleRevapiConfig.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GradleRevapiConfig.Builder putAcceptedBreaks(Map.Entry<? extends Version, ? extends PerProjectAcceptedBreaks> entry) {
            PerProjectAcceptedBreaks v;
            Version k = entry.getKey();
            this.acceptedBreaks.put(Objects.requireNonNull(k, "acceptedBreaks key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "acceptedBreaks value for key: " + k : null));
            return (GradleRevapiConfig.Builder)this;
        }

        @JsonProperty(value="acceptedBreaks")
        @CanIgnoreReturnValue
        public final GradleRevapiConfig.Builder acceptedBreaks(Map<? extends Version, ? extends PerProjectAcceptedBreaks> entries) {
            this.acceptedBreaks.clear();
            return this.putAllAcceptedBreaks(entries);
        }

        @CanIgnoreReturnValue
        public final GradleRevapiConfig.Builder putAllAcceptedBreaks(Map<? extends Version, ? extends PerProjectAcceptedBreaks> entries) {
            for (Map.Entry<? extends Version, ? extends PerProjectAcceptedBreaks> e : entries.entrySet()) {
                PerProjectAcceptedBreaks v;
                Version k = e.getKey();
                this.acceptedBreaks.put(Objects.requireNonNull(k, "acceptedBreaks key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "acceptedBreaks value for key: " + k : null));
            }
            return (GradleRevapiConfig.Builder)this;
        }

        public GradleRevapiConfig build() {
            return new ImmutableGradleRevapiConfig(ImmutableGradleRevapiConfig.createUnmodifiableSortedMap(false, false, false, this.versionOverrides), ImmutableGradleRevapiConfig.createUnmodifiableSortedMap(false, false, false, this.acceptedBreaks));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GradleRevapiConfig", generator="Immutables")
    static final class Json
    extends GradleRevapiConfig {
        @Nullable
        SortedMap<GroupNameVersion, String> versionOverrides = ImmutableGradleRevapiConfig.access$000(false, false, false, Collections.emptyMap());
        @Nullable
        SortedMap<Version, PerProjectAcceptedBreaks> acceptedBreaks = ImmutableGradleRevapiConfig.access$000(false, false, false, Collections.emptyMap());

        Json() {
        }

        @JsonProperty(value="versionOverrides")
        public void setVersionOverrides(SortedMap<GroupNameVersion, String> versionOverrides) {
            this.versionOverrides = versionOverrides;
        }

        @JsonProperty(value="acceptedBreaks")
        public void setAcceptedBreaks(SortedMap<Version, PerProjectAcceptedBreaks> acceptedBreaks) {
            this.acceptedBreaks = acceptedBreaks;
        }

        @Override
        protected SortedMap<GroupNameVersion, String> versionOverrides() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected SortedMap<Version, PerProjectAcceptedBreaks> acceptedBreaks() {
            throw new UnsupportedOperationException();
        }
    }
}

