/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle;

import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.revapi.gradle.ConfigManager;
import org.revapi.gradle.RevapiExtension;
import org.revapi.gradle.config.GroupNameVersion;

public class RevapiVersionOverrideTask
extends DefaultTask {
    public static final String REPLACEMENT_VERSION_OPTION = "replacement-version";
    private final Property<ConfigManager> configManager = this.getProject().getObjects().property(ConfigManager.class);
    private final Property<String> replacementVersion = this.getProject().getObjects().property(String.class);

    public RevapiVersionOverrideTask() {
        this.getOutputs().upToDateWhen(_ignored -> false);
    }

    @Internal
    final Property<ConfigManager> getConfigManager() {
        return this.configManager;
    }

    @Option(option="replacement-version", description="The version to use instead of the default oldVersion")
    public final void setReplacementVersion(String replacementVersionValue) {
        this.replacementVersion.set((Object)replacementVersionValue);
    }

    @TaskAction
    public final void addVersionOverride() {
        if (!this.replacementVersion.isPresent()) {
            throw new RuntimeException("Please supply the --replacement-version param this task");
        }
        ((ConfigManager)this.configManager.get()).modifyConfigFile(config -> config.addVersionOverride(this.oldGroupNameVersion(), (String)this.replacementVersion.get()));
    }

    private GroupNameVersion oldGroupNameVersion() {
        return ((RevapiExtension)this.getProject().getExtensions().getByType(RevapiExtension.class)).oldGroupNameVersion();
    }
}

