/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.revapi.gradle.AnalysisResults;
import org.revapi.gradle.RevapiAcceptAllBreaksTask;
import org.revapi.gradle.RevapiAcceptBreakTask;

public class RevapiReportTask
extends DefaultTask {
    private final RegularFileProperty analysisResultsFile = this.getProject().getObjects().fileProperty();
    private final RegularFileProperty junitOutputFile = this.getProject().getObjects().fileProperty();

    @InputFile
    public final RegularFileProperty getAnalysisResultsFile() {
        return this.analysisResultsFile;
    }

    @OutputFile
    public final RegularFileProperty getJunitOutputFile() {
        return this.junitOutputFile;
    }

    @TaskAction
    public final void reportBreaks() throws Exception {
        AnalysisResults results = AnalysisResults.fromFile((File)this.analysisResultsFile.getAsFile().get());
        Configuration freeMarkerConfiguration = this.createFreeMarkerConfiguration();
        HashMap<String, Object> templateData = new HashMap<String, Object>();
        templateData.put("results", results);
        templateData.put("acceptBreakTask", ((RevapiAcceptBreakTask)this.getProject().getTasks().withType(RevapiAcceptBreakTask.class).getByName("revapiAcceptBreak")).getPath());
        templateData.put("acceptAllBreaksProjectTask", ((RevapiAcceptAllBreaksTask)this.getProject().getTasks().withType(RevapiAcceptAllBreaksTask.class).getByName("revapiAcceptAllBreaks")).getPath());
        templateData.put("acceptAllBreaksEverywhereTask", "revapiAcceptAllBreaks");
        templateData.put("explainWhy", "{why this break is ok}");
        Template junitTemplate = freeMarkerConfiguration.getTemplate("gradle-revapi-junit-template.ftl");
        junitTemplate.process(templateData, (Writer)Files.newBufferedWriter(((File)this.junitOutputFile.getAsFile().get()).toPath(), StandardCharsets.UTF_8, new OpenOption[0]));
        Template textTemplate = freeMarkerConfiguration.getTemplate("gradle-revapi-text-template.ftl");
        StringWriter textOutputWriter = new StringWriter();
        textTemplate.process(templateData, (Writer)textOutputWriter);
        String textOutput = textOutputWriter.toString();
        if (!textOutput.trim().isEmpty()) {
            throw new RuntimeException("There were Java public API/ABI breaks reported by revapi:\n\n" + textOutput);
        }
    }

    private Configuration createFreeMarkerConfiguration() {
        DefaultObjectWrapperBuilder objectWrapper = new DefaultObjectWrapperBuilder(Configuration.VERSION_2_3_23);
        Configuration freeMarker = new Configuration(Configuration.VERSION_2_3_23);
        freeMarker.setObjectWrapper((ObjectWrapper)objectWrapper.build());
        freeMarker.setAPIBuiltinEnabled(true);
        freeMarker.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(((Object)((Object)this)).getClass(), "/META-INF"));
        return freeMarker;
    }
}

