/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle;

import java.io.File;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentResult;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.revapi.gradle.ConfigManager;
import org.revapi.gradle.GradleUtils;
import org.revapi.gradle.ResolveOldApi;
import org.revapi.gradle.RevapiAcceptAllBreaksTask;
import org.revapi.gradle.RevapiAcceptBreakTask;
import org.revapi.gradle.RevapiAnalyzeTask;
import org.revapi.gradle.RevapiExtension;
import org.revapi.gradle.RevapiReportTask;
import org.revapi.gradle.RevapiVersionOverrideTask;
import org.revapi.gradle.config.AcceptedBreak;
import org.revapi.gradle.config.GroupAndName;

public final class RevapiPlugin
implements Plugin<Project> {
    public static final String VERSION_OVERRIDE_TASK_NAME = "revapiVersionOverride";
    public static final String ACCEPT_BREAK_TASK_NAME = "revapiAcceptBreak";
    public static final String ACCEPT_ALL_BREAKS_TASK_NAME = "revapiAcceptAllBreaks";

    public void apply(Project project) {
        project.getPluginManager().apply(LifecycleBasePlugin.class);
        project.getPluginManager().apply(JavaPlugin.class);
        RevapiExtension extension = (RevapiExtension)project.getExtensions().create("revapi", RevapiExtension.class, new Object[]{project});
        ConfigManager configManager = new ConfigManager(RevapiPlugin.configFile(project));
        Provider<Optional<ResolveOldApi.OldApi>> maybeOldApi = ResolveOldApi.oldApiProvider(project, extension, configManager);
        Spec oldApiIsPresent = _task -> ((Optional)maybeOldApi.get()).isPresent();
        TaskProvider analyzeTask = project.getTasks().register("revapiAnalyze", RevapiAnalyzeTask.class, task -> {
            Configuration revapiNewApi = (Configuration)project.getConfigurations().create("revapiNewApi", conf -> {
                conf.extendsFrom(new Configuration[]{project.getConfigurations().getByName("compileClasspath")});
                RevapiPlugin.configureApiUsage(project, conf);
                conf.setCanBeConsumed(false);
                conf.setVisible(false);
            });
            Configuration revapiNewApiElements = (Configuration)project.getConfigurations().create("revapiNewApiElements", conf -> {
                conf.extendsFrom(new Configuration[]{project.getConfigurations().getByName("apiElements")});
                RevapiPlugin.configureApiUsage(project, conf);
                conf.setCanBeConsumed(false);
                conf.setVisible(false);
            });
            task.getAcceptedBreaks().set(this.acceptedBreaks(project, configManager, extension.oldGroupAndName()));
            FileCollection thisJarFile = project.getConfigurations().getByName("runtimeElements").getOutgoing().getArtifacts().getFiles();
            FileCollection otherProjectsOutputs = revapiNewApiElements.getIncoming().artifactView(vc -> vc.componentFilter(ci -> ci instanceof ProjectComponentIdentifier)).getFiles();
            task.getNewApiJars().set((Object)thisJarFile.plus(otherProjectsOutputs));
            task.getNewApiDependencyJars().set((Object)revapiNewApi.minus((FileCollection)task.getNewApiJars().get()));
            task.getJarsToReportBreaks().set(project.provider(() -> thisJarFile.plus((FileCollection)task.getOldApiJars().get())));
            task.getOldApiJars().set(maybeOldApi.map(oldApi -> oldApi.map(ResolveOldApi.OldApi::jars).map(xva$0 -> project.files(new Object[]{xva$0})).orElseGet(() -> project.files(new Object[0]))));
            task.getOldApiDependencyJars().set(maybeOldApi.map(oldApi -> oldApi.map(ResolveOldApi.OldApi::dependencyJars).map(xva$0 -> project.files(new Object[]{xva$0})).orElseGet(() -> project.files(new Object[0]))));
            task.getAnalysisResultsFile().set(new File(project.getBuildDir(), "revapi/revapi-results.json"));
            task.onlyIf(oldApiIsPresent);
        });
        TaskProvider reportTask = project.getTasks().register("revapi", RevapiReportTask.class, task -> {
            task.dependsOn(new Object[]{analyzeTask});
            task.getAnalysisResultsFile().set(analyzeTask.flatMap(RevapiAnalyzeTask::getAnalysisResultsFile));
            task.getJunitOutputFile().set(this.junitOutput(project));
            task.onlyIf(oldApiIsPresent);
        });
        ((Task)project.getTasks().findByName("check")).dependsOn(new Object[]{reportTask});
        project.getTasks().register(ACCEPT_ALL_BREAKS_TASK_NAME, RevapiAcceptAllBreaksTask.class, task -> {
            task.dependsOn(new Object[]{analyzeTask});
            task.getOldGroupNameVersion().set(project.getProviders().provider(extension::oldGroupNameVersion));
            task.getConfigManager().set((Object)configManager);
            task.getAnalysisResultsFile().set(analyzeTask.flatMap(RevapiAnalyzeTask::getAnalysisResultsFile));
            task.onlyIf(oldApiIsPresent);
        });
        project.getTasks().register(VERSION_OVERRIDE_TASK_NAME, RevapiVersionOverrideTask.class, task -> task.getConfigManager().set((Object)configManager));
        project.getTasks().register(ACCEPT_BREAK_TASK_NAME, RevapiAcceptBreakTask.class, task -> task.getConfigManager().set((Object)configManager));
    }

    private static void configureApiUsage(Project project, Configuration conf) {
        conf.attributes(attrs -> attrs.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, "java-api"))));
    }

    private Provider<Set<AcceptedBreak>> acceptedBreaks(Project project, ConfigManager configManager, Provider<GroupAndName> oldGroupAndNameProvider) {
        return GradleUtils.memoisedProvider(project, () -> configManager.fromFileOrEmptyIfDoesNotExist().acceptedBreaksFor((GroupAndName)oldGroupAndNameProvider.get()));
    }

    static Provider<Set<Jar>> allJarTasksIncludingDependencies(Project project, Configuration configuration) {
        return GradleUtils.memoisedProvider(project, () -> configuration.getIncoming().getResolutionResult().getAllComponents().stream().map(ComponentResult::getId).filter(resolvedComponentResult -> resolvedComponentResult instanceof ProjectComponentIdentifier).map(resolvedComponentResult -> (ProjectComponentIdentifier)resolvedComponentResult).map(ProjectComponentIdentifier::getProjectPath).map(arg_0 -> ((Project)project.getRootProject()).project(arg_0)).flatMap(dependentProject -> dependentProject.getTasks().withType(Jar.class).matching(jar -> jar.getName().equals("jar")).stream()).collect(Collectors.toSet()));
    }

    private static File configFile(Project project) {
        return new File(project.getRootDir(), ".palantir/revapi.yml");
    }

    private File junitOutput(Project project) {
        Optional<String> circleReportsDir = Optional.ofNullable(System.getenv("CIRCLE_TEST_REPORTS"));
        File reportsDir = circleReportsDir.map(File::new).orElseGet(() -> ((Project)project).getBuildDir());
        return new File(reportsDir, "junit-reports/revapi/revapi-" + project.getName() + ".xml");
    }
}

