/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.revapi.gradle.GitVersionUtils;
import org.revapi.gradle.config.GroupAndName;
import org.revapi.gradle.config.GroupNameVersion;
import org.revapi.gradle.config.Version;

public class RevapiExtension {
    private final Property<String> oldGroup;
    private final Property<String> oldName;
    private final ListProperty<String> oldVersions;
    private final Provider<GroupAndName> oldGroupAndName;

    public RevapiExtension(Project project) {
        this.oldGroup = project.getObjects().property(String.class);
        this.oldGroup.set(project.getProviders().provider(() -> project.getGroup().toString()));
        this.oldName = project.getObjects().property(String.class);
        this.oldName.set(project.getProviders().provider(() -> ((Project)project).getName()));
        this.oldVersions = project.getObjects().listProperty(String.class);
        this.oldVersions.set(project.getProviders().provider(() -> GitVersionUtils.previousGitTags(project).limit(3L).collect(Collectors.toList())));
        this.oldGroupAndName = project.provider(() -> GroupAndName.builder().group((String)this.oldGroup.get()).name((String)this.oldName.get()).build());
    }

    public Property<String> getOldGroup() {
        return this.oldGroup;
    }

    public Property<String> getOldName() {
        return this.oldName;
    }

    public ListProperty<String> getOldVersions() {
        return this.oldVersions;
    }

    public void setOldVersion(String oldVersionValue) {
        this.oldVersions.set(Collections.singletonList(oldVersionValue));
    }

    GroupNameVersion oldGroupNameVersion() {
        return ((GroupAndName)this.oldGroupAndName().get()).withVersion(Version.fromString((String)((List)this.oldVersions.get()).get(0)));
    }

    Provider<GroupAndName> oldGroupAndName() {
        return this.oldGroupAndName;
    }
}

