/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.file.FileCollection;
import org.immutables.value.Value;
import org.revapi.gradle.ImmutableRevapiConfig;
import org.revapi.gradle.Utils;
import org.revapi.gradle.config.AcceptedBreak;

@Value.Immutable
abstract class RevapiConfig {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)new Jdk8Module());

    RevapiConfig() {
    }

    protected abstract List<JsonNode> config();

    public String configAsString() {
        try {
            return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(this.config());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public RevapiConfig withTextReporter(String templateName, File outputPath) {
        return this.withExtension("revapi.reporter.text", (JsonNode)OBJECT_MAPPER.createObjectNode().put("minSeverity", "BREAKING").put("template", templateName).put("output", outputPath.getAbsolutePath()).put("append", false));
    }

    public RevapiConfig withIgnoredBreaks(Set<AcceptedBreak> acceptedBreaks) {
        return this.withExtension("revapi.ignore", (JsonNode)OBJECT_MAPPER.convertValue(acceptedBreaks, ArrayNode.class));
    }

    public RevapiConfig withExtension(String extensionId) {
        return this.withExtension(extensionId, (JsonNode)OBJECT_MAPPER.createObjectNode());
    }

    public RevapiConfig withExtension(String extensionId, JsonNode configuration) {
        JsonNode extension = OBJECT_MAPPER.createObjectNode().put("extension", extensionId).set("configuration", configuration);
        return RevapiConfig.fromJsonNodes(Stream.concat(this.config().stream(), Stream.of(extension)).collect(Collectors.toList()));
    }

    public RevapiConfig mergeWith(RevapiConfig other) {
        return new Builder().from(this).addAllConfig(other.config()).build();
    }

    public static RevapiConfig defaults(FileCollection jarsToReportBreaks) {
        String template = Utils.resourceToString(RevapiConfig.class, "revapi-configuration.json");
        return RevapiConfig.fromString(template.replace("{{ARCHIVE_INCLUDE_REGEXES}}", jarsToReportBreaks.getFiles().stream().map(File::getName).collect(Collectors.joining("\", \""))));
    }

    public static RevapiConfig mergeAll(RevapiConfig ... revapiConfigs) {
        return Arrays.stream(revapiConfigs).reduce(RevapiConfig.empty(), RevapiConfig::mergeWith);
    }

    public static RevapiConfig empty() {
        return RevapiConfig.fromJsonNodes(Collections.emptyList());
    }

    private static RevapiConfig fromString(String configJson) {
        try {
            return RevapiConfig.fromJsonNodes((List)OBJECT_MAPPER.readValue(configJson, (TypeReference)new TypeReference<List<JsonNode>>(){}));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static RevapiConfig fromJsonNodes(List<JsonNode> jsonNodes) {
        return new Builder().config(jsonNodes).build();
    }

    public static ArrayNode createArrayNode() {
        return OBJECT_MAPPER.createArrayNode();
    }

    static final class Builder
    extends ImmutableRevapiConfig.Builder {
        Builder() {
        }
    }
}

