/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle;

import java.util.Collections;
import java.util.Optional;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.revapi.gradle.ConfigManager;
import org.revapi.gradle.RevapiExtension;
import org.revapi.gradle.config.AcceptedBreak;
import org.revapi.gradle.config.GroupNameVersion;
import org.revapi.gradle.config.Justification;

public class RevapiAcceptBreakTask
extends DefaultTask {
    private static final String CODE_OPTION = "code";
    private static final String OLD_OPTION = "old";
    private static final String NEW_OPTION = "new";
    private static final String JUSTIFICATION_OPTION = "justification";
    private final Property<ConfigManager> configManager = this.getProject().getObjects().property(ConfigManager.class);
    private final Property<String> code = this.getProject().getObjects().property(String.class);
    private final Property<String> oldElement = this.getProject().getObjects().property(String.class);
    private final Property<String> newElement = this.getProject().getObjects().property(String.class);
    private final Property<Justification> justification = this.getProject().getObjects().property(Justification.class);

    public RevapiAcceptBreakTask() {
        this.getOutputs().upToDateWhen(_ignored -> false);
    }

    @Internal
    final Property<ConfigManager> getConfigManager() {
        return this.configManager;
    }

    @Option(option="code", description="Revapi change code")
    public final void setCode(String codeString) {
        this.code.set((Object)codeString);
    }

    @Option(option="old", description="Old API element")
    public final void setOldElement(String oldElementString) {
        this.oldElement.set((Object)oldElementString);
    }

    @Option(option="new", description="New API element")
    public final void setNewElement(String newElementString) {
        this.newElement.set((Object)newElementString);
    }

    @Option(option="justification", description="Justification for why these breaks are ok")
    public final void setJustification(String justificationString) {
        this.justification.set((Object)Justification.fromString(justificationString));
    }

    @TaskAction
    public final void addVersionOverride() {
        this.ensurePresent(this.code, CODE_OPTION);
        this.ensurePresent(this.justification, JUSTIFICATION_OPTION);
        ((ConfigManager)this.configManager.get()).modifyConfigFile(revapiConfig -> revapiConfig.addAcceptedBreaks(this.oldGroupNameVersion(), Collections.singleton(AcceptedBreak.builder().code((String)this.code.get()).oldElement(Optional.ofNullable((String)this.oldElement.getOrNull())).newElement(Optional.ofNullable((String)this.newElement.getOrNull())).justification((Justification)this.justification.get()).build())));
    }

    private void ensurePresent(Property<?> prop, String option) {
        if (!prop.isPresent()) {
            throw new IllegalArgumentException("Please supply the --" + option + " param to this task");
        }
    }

    private GroupNameVersion oldGroupNameVersion() {
        return ((RevapiExtension)this.getProject().getExtensions().getByType(RevapiExtension.class)).oldGroupNameVersion();
    }
}

