/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle;

import java.io.File;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.revapi.gradle.AnalysisResults;
import org.revapi.gradle.ConfigManager;
import org.revapi.gradle.config.AcceptedBreak;
import org.revapi.gradle.config.GroupNameVersion;
import org.revapi.gradle.config.Justification;

public class RevapiAcceptAllBreaksTask
extends DefaultTask {
    public static final String JUSTIFICATION = "justification";
    private final Property<ConfigManager> configManager = this.getProject().getObjects().property(ConfigManager.class);
    private final Property<GroupNameVersion> oldGroupNameVersion = this.getProject().getObjects().property(GroupNameVersion.class);
    private final RegularFileProperty analysisResultsFile = this.getProject().getObjects().fileProperty();
    private final Property<Justification> justification = this.getProject().getObjects().property(Justification.class);

    public RevapiAcceptAllBreaksTask() {
        this.getOutputs().upToDateWhen(_ignored -> false);
    }

    @Internal
    final Property<ConfigManager> getConfigManager() {
        return this.configManager;
    }

    @Input
    final Property<GroupNameVersion> getOldGroupNameVersion() {
        return this.oldGroupNameVersion;
    }

    @InputFile
    final RegularFileProperty getAnalysisResultsFile() {
        return this.analysisResultsFile;
    }

    @Option(option="justification", description="Justification for why these breaks are ok")
    public final void setJustification(String justificationString) {
        this.justification.set((Object)Justification.fromString(justificationString));
    }

    @TaskAction
    public final void addVersionOverride() {
        if (!this.justification.isPresent()) {
            throw new RuntimeException("Please supply the --justification param to this task");
        }
        Set<AcceptedBreak> acceptedBreaks = AnalysisResults.fromFile((File)this.analysisResultsFile.getAsFile().get()).toAcceptedBreaks((Justification)this.justification.get());
        ((ConfigManager)this.configManager.get()).modifyConfigFile(config -> config.addAcceptedBreaks((GroupNameVersion)this.oldGroupNameVersion.get(), acceptedBreaks));
    }
}

