/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle;

import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.immutables.value.Value;
import org.revapi.gradle.ConfigManager;
import org.revapi.gradle.ExceptionMessages;
import org.revapi.gradle.GradleUtils;
import org.revapi.gradle.ImmutableOldApi;
import org.revapi.gradle.OldApiConfigurations;
import org.revapi.gradle.RevapiExtension;
import org.revapi.gradle.config.GradleRevapiConfig;
import org.revapi.gradle.config.GroupAndName;
import org.revapi.gradle.config.GroupNameVersion;
import org.revapi.gradle.config.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ResolveOldApi {
    private static final Logger log = LoggerFactory.getLogger(ResolveOldApi.class);

    private ResolveOldApi() {
    }

    public static Provider<Optional<OldApi>> oldApiProvider(Project project, RevapiExtension extension, ConfigManager configManager) {
        return GradleUtils.memoisedProvider(project, () -> ResolveOldApi.resolveOldApiAcrossAllOldVersions(project, extension, configManager.fromFileOrEmptyIfDoesNotExist()));
    }

    private static Optional<OldApi> resolveOldApiAcrossAllOldVersions(Project project, RevapiExtension extension, GradleRevapiConfig config) {
        List oldVersionStrings = (List)extension.getOldVersions().get();
        if (oldVersionStrings.isEmpty()) {
            return Optional.empty();
        }
        GroupAndName oldGroupAndName = (GroupAndName)extension.oldGroupAndName().get();
        LinkedHashMap<Version, OldApiConfigurations.CouldNotResolveOldApiException> exceptionsPerVersion = new LinkedHashMap<Version, OldApiConfigurations.CouldNotResolveOldApiException>();
        for (String oldVersionString : oldVersionStrings) {
            GroupNameVersion oldGroupNameVersion = ResolveOldApi.possiblyReplacedOldVersionFor(config, oldGroupAndName.withVersion(Version.fromString(oldVersionString)));
            try {
                OldApi oldApi = ResolveOldApi.resolveOldApiWithVersion(project, oldGroupNameVersion);
                if (!exceptionsPerVersion.isEmpty()) {
                    log.warn("{} has successfully resolved. At first we tried to use versions {}, however they all failed to resolve with these errors:\n\n{}", new Object[]{oldGroupNameVersion.asString(), exceptionsPerVersion.keySet().stream().map(Version::asString).collect(Collectors.toList()), ExceptionMessages.joined(exceptionsPerVersion.values())});
                }
                return Optional.of(oldApi);
            }
            catch (OldApiConfigurations.CouldNotResolveOldApiException e) {
                exceptionsPerVersion.put(oldGroupNameVersion.version(), e);
            }
        }
        try {
            OldApiConfigurations.resolveOldConfiguration(project, oldGroupAndName.withVersion(Version.fromString("+")), false);
        }
        catch (OldApiConfigurations.CouldNotResolveOldApiException e) {
            return Optional.empty();
        }
        throw new IllegalStateException(ExceptionMessages.failedToResolve(project, ExceptionMessages.joined(exceptionsPerVersion.values())));
    }

    private static OldApi resolveOldApiWithVersion(Project project, GroupNameVersion groupNameVersion) throws OldApiConfigurations.CouldNotResolveOldApiException {
        Set<File> oldOnlyJar = OldApiConfigurations.resolveOldConfiguration(project, groupNameVersion, false);
        Set<File> oldWithDeps = OldApiConfigurations.resolveOldConfiguration(project, groupNameVersion, true);
        HashSet<File> oldJustDeps = new HashSet<File>(oldWithDeps);
        oldJustDeps.removeAll(oldOnlyJar);
        return OldApi.builder().jars(oldOnlyJar).dependencyJars(oldJustDeps).build();
    }

    private static GroupNameVersion possiblyReplacedOldVersionFor(GradleRevapiConfig config, GroupNameVersion groupNameVersion) {
        Version possiblyReplacedVersion = config.versionOverrideFor(groupNameVersion).orElseGet(groupNameVersion::version);
        return GroupNameVersion.builder().from(groupNameVersion).version(possiblyReplacedVersion).build();
    }

    @Value.Immutable
    static interface OldApi {
        public Set<File> jars();

        public Set<File> dependencyJars();

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends ImmutableOldApi.Builder {
        }
    }
}

