/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.revapi.gradle.GitVersionUtils;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GitVersionUtils.GitResult", generator="Immutables")
@Immutable
final class ImmutableGitResult
implements GitVersionUtils.GitResult {
    private final int exitCode;
    private final String stdout;
    private final String stderr;
    private final ImmutableList<String> command;

    private ImmutableGitResult(int exitCode, String stdout, String stderr, ImmutableList<String> command) {
        this.exitCode = exitCode;
        this.stdout = stdout;
        this.stderr = stderr;
        this.command = command;
    }

    @Override
    public int exitCode() {
        return this.exitCode;
    }

    @Override
    public String stdout() {
        return this.stdout;
    }

    @Override
    public String stderr() {
        return this.stderr;
    }

    public ImmutableList<String> command() {
        return this.command;
    }

    public final ImmutableGitResult withExitCode(int value) {
        if (this.exitCode == value) {
            return this;
        }
        return new ImmutableGitResult(value, this.stdout, this.stderr, this.command);
    }

    public final ImmutableGitResult withStdout(String value) {
        String newValue = Objects.requireNonNull(value, "stdout");
        if (this.stdout.equals(newValue)) {
            return this;
        }
        return new ImmutableGitResult(this.exitCode, newValue, this.stderr, this.command);
    }

    public final ImmutableGitResult withStderr(String value) {
        String newValue = Objects.requireNonNull(value, "stderr");
        if (this.stderr.equals(newValue)) {
            return this;
        }
        return new ImmutableGitResult(this.exitCode, this.stdout, newValue, this.command);
    }

    public final ImmutableGitResult withCommand(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableGitResult(this.exitCode, this.stdout, this.stderr, (ImmutableList<String>)newValue);
    }

    public final ImmutableGitResult withCommand(Iterable<String> elements) {
        if (this.command == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableGitResult(this.exitCode, this.stdout, this.stderr, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGitResult && this.equalTo(0, (ImmutableGitResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableGitResult another) {
        return this.exitCode == another.exitCode && this.stdout.equals(another.stdout) && this.stderr.equals(another.stderr) && this.command.equals(another.command);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.exitCode;
        h += (h << 5) + this.stdout.hashCode();
        h += (h << 5) + this.stderr.hashCode();
        h += (h << 5) + this.command.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GitResult").omitNullValues().add("exitCode", this.exitCode).add("stdout", (Object)this.stdout).add("stderr", (Object)this.stderr).add("command", this.command).toString();
    }

    public static ImmutableGitResult copyOf(GitVersionUtils.GitResult instance) {
        if (instance instanceof ImmutableGitResult) {
            return (ImmutableGitResult)instance;
        }
        return new GitVersionUtils.GitResult.Builder().from(instance).build();
    }

    @Generated(from="GitVersionUtils.GitResult", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_EXIT_CODE = 1L;
        private static final long INIT_BIT_STDOUT = 2L;
        private static final long INIT_BIT_STDERR = 4L;
        private long initBits = 7L;
        private int exitCode;
        @Nullable
        private String stdout;
        @Nullable
        private String stderr;
        private ImmutableList.Builder<String> command = ImmutableList.builder();

        public Builder() {
            if (!(this instanceof GitVersionUtils.GitResult.Builder)) {
                throw new UnsupportedOperationException("Use: new GitVersionUtils.GitResult.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final GitVersionUtils.GitResult.Builder from(GitVersionUtils.GitResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.exitCode(instance.exitCode());
            this.stdout(instance.stdout());
            this.stderr(instance.stderr());
            this.addAllCommand(instance.command());
            return (GitVersionUtils.GitResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GitVersionUtils.GitResult.Builder exitCode(int exitCode) {
            this.exitCode = exitCode;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (GitVersionUtils.GitResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GitVersionUtils.GitResult.Builder stdout(String stdout) {
            this.stdout = Objects.requireNonNull(stdout, "stdout");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (GitVersionUtils.GitResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GitVersionUtils.GitResult.Builder stderr(String stderr) {
            this.stderr = Objects.requireNonNull(stderr, "stderr");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (GitVersionUtils.GitResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GitVersionUtils.GitResult.Builder addCommand(String element) {
            this.command.add((Object)element);
            return (GitVersionUtils.GitResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GitVersionUtils.GitResult.Builder addCommand(String ... elements) {
            this.command.add((Object[])elements);
            return (GitVersionUtils.GitResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GitVersionUtils.GitResult.Builder command(Iterable<String> elements) {
            this.command = ImmutableList.builder();
            return this.addAllCommand(elements);
        }

        @CanIgnoreReturnValue
        public final GitVersionUtils.GitResult.Builder addAllCommand(Iterable<String> elements) {
            this.command.addAll(elements);
            return (GitVersionUtils.GitResult.Builder)this;
        }

        public ImmutableGitResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGitResult(this.exitCode, this.stdout, this.stderr, this.command.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("exitCode");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("stdout");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("stderr");
            }
            return "Cannot build GitResult, some of required attributes are not set " + attributes;
        }
    }
}

