/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.revapi.gradle.AnalysisResult;
import org.revapi.gradle.AnalysisResults;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AnalysisResults", generator="Immutables")
@Immutable
final class ImmutableAnalysisResults
extends AnalysisResults {
    private final String archiveNames;
    private final List<AnalysisResult> results;

    private ImmutableAnalysisResults(String archiveNames, List<AnalysisResult> results) {
        this.archiveNames = archiveNames;
        this.results = results;
    }

    @Override
    @JsonProperty(value="archiveNames")
    public String archiveNames() {
        return this.archiveNames;
    }

    @Override
    @JsonProperty(value="results")
    public List<AnalysisResult> results() {
        return this.results;
    }

    public final ImmutableAnalysisResults withArchiveNames(String value) {
        String newValue = Objects.requireNonNull(value, "archiveNames");
        if (this.archiveNames.equals(newValue)) {
            return this;
        }
        return new ImmutableAnalysisResults(newValue, this.results);
    }

    public final ImmutableAnalysisResults withResults(AnalysisResult ... elements) {
        List<AnalysisResult> newValue = ImmutableAnalysisResults.createUnmodifiableList(false, ImmutableAnalysisResults.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAnalysisResults(this.archiveNames, newValue);
    }

    public final ImmutableAnalysisResults withResults(Iterable<? extends AnalysisResult> elements) {
        if (this.results == elements) {
            return this;
        }
        List<AnalysisResult> newValue = ImmutableAnalysisResults.createUnmodifiableList(false, ImmutableAnalysisResults.createSafeList(elements, true, false));
        return new ImmutableAnalysisResults(this.archiveNames, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAnalysisResults && this.equalTo(0, (ImmutableAnalysisResults)another);
    }

    private boolean equalTo(int synthetic, ImmutableAnalysisResults another) {
        return this.archiveNames.equals(another.archiveNames) && this.results.equals(another.results);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.archiveNames.hashCode();
        h += (h << 5) + this.results.hashCode();
        return h;
    }

    public String toString() {
        return "AnalysisResults{archiveNames=" + this.archiveNames + ", results=" + this.results + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAnalysisResults fromJson(Json json) {
        AnalysisResults.Builder builder = new AnalysisResults.Builder();
        if (json.archiveNames != null) {
            builder.archiveNames(json.archiveNames);
        }
        if (json.results != null) {
            builder.addAllResults(json.results);
        }
        return (ImmutableAnalysisResults)builder.build();
    }

    public static AnalysisResults copyOf(AnalysisResults instance) {
        if (instance instanceof ImmutableAnalysisResults) {
            return (ImmutableAnalysisResults)instance;
        }
        return new AnalysisResults.Builder().from(instance).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AnalysisResults", generator="Immutables")
    @NotThreadSafe
    static class Builder {
        private static final long INIT_BIT_ARCHIVE_NAMES = 1L;
        private long initBits = 1L;
        @Nullable
        private String archiveNames;
        private List<AnalysisResult> results = new ArrayList<AnalysisResult>();

        Builder() {
            if (!(this instanceof AnalysisResults.Builder)) {
                throw new UnsupportedOperationException("Use: new AnalysisResults.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final AnalysisResults.Builder from(AnalysisResults instance) {
            Objects.requireNonNull(instance, "instance");
            this.archiveNames(instance.archiveNames());
            this.addAllResults(instance.results());
            return (AnalysisResults.Builder)this;
        }

        @JsonProperty(value="archiveNames")
        @CanIgnoreReturnValue
        public final AnalysisResults.Builder archiveNames(String archiveNames) {
            this.archiveNames = Objects.requireNonNull(archiveNames, "archiveNames");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (AnalysisResults.Builder)this;
        }

        @CanIgnoreReturnValue
        public final AnalysisResults.Builder addResults(AnalysisResult element) {
            this.results.add(Objects.requireNonNull(element, "results element"));
            return (AnalysisResults.Builder)this;
        }

        @CanIgnoreReturnValue
        public final AnalysisResults.Builder addResults(AnalysisResult ... elements) {
            for (AnalysisResult element : elements) {
                this.results.add(Objects.requireNonNull(element, "results element"));
            }
            return (AnalysisResults.Builder)this;
        }

        @JsonProperty(value="results")
        @CanIgnoreReturnValue
        public final AnalysisResults.Builder results(Iterable<? extends AnalysisResult> elements) {
            this.results.clear();
            return this.addAllResults(elements);
        }

        @CanIgnoreReturnValue
        public final AnalysisResults.Builder addAllResults(Iterable<? extends AnalysisResult> elements) {
            for (AnalysisResult analysisResult : elements) {
                this.results.add(Objects.requireNonNull(analysisResult, "results element"));
            }
            return (AnalysisResults.Builder)this;
        }

        public AnalysisResults build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAnalysisResults(this.archiveNames, ImmutableAnalysisResults.createUnmodifiableList(true, this.results));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("archiveNames");
            }
            return "Cannot build AnalysisResults, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AnalysisResults", generator="Immutables")
    static final class Json
    extends AnalysisResults {
        @Nullable
        String archiveNames;
        @Nullable
        List<AnalysisResult> results = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="archiveNames")
        public void setArchiveNames(String archiveNames) {
            this.archiveNames = archiveNames;
        }

        @JsonProperty(value="results")
        public void setResults(List<AnalysisResult> results) {
            this.results = results;
        }

        @Override
        public String archiveNames() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<AnalysisResult> results() {
            throw new UnsupportedOperationException();
        }
    }
}

