/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle;

import java.util.function.Supplier;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;

final class GradleUtils {
    private GradleUtils() {
    }

    public static <T> Provider<T> memoisedProvider(Project project, Supplier<T> supplier) {
        MemoizingSupplier<T> memoised = new MemoizingSupplier<T>(supplier);
        return project.provider(memoised::get);
    }

    private static class MemoizingSupplier<T>
    implements Supplier<T> {
        private final Supplier<T> delegate;
        private volatile transient boolean initialized;
        private transient T savedValue;

        MemoizingSupplier(Supplier<T> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (!this.initialized) {
                MemoizingSupplier memoizingSupplier = this;
                synchronized (memoizingSupplier) {
                    if (!this.initialized) {
                        T value = this.delegate.get();
                        this.savedValue = value;
                        this.initialized = true;
                        return value;
                    }
                }
            }
            return this.savedValue;
        }

        public String toString() {
            return "Suppliers.memoize(" + (this.initialized ? "<supplier that returned " + this.savedValue + ">" : this.delegate) + ")";
        }
    }
}

