/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.function.UnaryOperator;
import org.revapi.gradle.config.GradleRevapiConfig;

final class ConfigManager {
    private static final ObjectMapper OBJECT_MAPPER = GradleRevapiConfig.newYamlObjectMapper();
    private static final Object CONFIG_FILE_LOCK = new Object();
    private final File configFile;

    ConfigManager(File configFile) {
        this.configFile = configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyConfigFile(UnaryOperator<GradleRevapiConfig> transformer) {
        Object object = CONFIG_FILE_LOCK;
        synchronized (object) {
            GradleRevapiConfig oldGradleRevapiConfig = this.fromFileOrEmptyIfDoesNotExist();
            GradleRevapiConfig newGradleRevapiConfig = (GradleRevapiConfig)transformer.apply(oldGradleRevapiConfig);
            this.configFile.getParentFile().mkdirs();
            try {
                OBJECT_MAPPER.writeValue(this.configFile, (Object)newGradleRevapiConfig);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to modify revapi config file: " + this.configFile, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GradleRevapiConfig fromFileOrEmptyIfDoesNotExist() {
        if (!this.configFile.exists()) {
            return GradleRevapiConfig.empty();
        }
        try {
            Object object = CONFIG_FILE_LOCK;
            synchronized (object) {
                return (GradleRevapiConfig)OBJECT_MAPPER.readValue(this.configFile, GradleRevapiConfig.class);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read revapi config file: " + this.configFile, e);
        }
    }
}

