/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.revapi.CompatibilityType;
import org.revapi.DifferenceSeverity;
import org.revapi.gradle.ImmutableAnalysisResult;
import org.revapi.gradle.config.AcceptedBreak;
import org.revapi.gradle.config.Justification;

@JsonDeserialize(as=ImmutableAnalysisResult.class)
@Value.Immutable
public abstract class AnalysisResult {
    public abstract String code();

    @Nullable
    public abstract String oldElement();

    @Nullable
    public abstract String newElement();

    @Nullable
    public abstract String description();

    @Nullable
    public abstract String oldArchiveName();

    @Nullable
    public abstract String newArchiveName();

    public abstract Map<CompatibilityType, DifferenceSeverity> classification();

    final AcceptedBreak toAcceptedBreak(Justification justification) {
        return AcceptedBreak.builder().code(this.code()).oldElement(Optional.ofNullable(this.oldElement())).newElement(Optional.ofNullable(this.newElement())).justification(justification).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static class Builder
    extends ImmutableAnalysisResult.Builder {
        Builder() {
        }
    }
}

