/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.adapter;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.data.CacheDirective;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ClientInfo;
import org.restlet.data.Conditions;
import org.restlet.data.Cookie;
import org.restlet.data.Header;
import org.restlet.data.Method;
import org.restlet.data.Range;
import org.restlet.data.RecipientInfo;
import org.restlet.data.Reference;
import org.restlet.data.Tag;
import org.restlet.data.Warning;
import org.restlet.engine.adapter.ServerCall;
import org.restlet.engine.header.CacheDirectiveReader;
import org.restlet.engine.header.CookieReader;
import org.restlet.engine.header.ExpectationReader;
import org.restlet.engine.header.HeaderReader;
import org.restlet.engine.header.PreferenceReader;
import org.restlet.engine.header.RangeReader;
import org.restlet.engine.header.RecipientInfoReader;
import org.restlet.engine.header.StringReader;
import org.restlet.engine.header.TagReader;
import org.restlet.engine.header.WarningReader;
import org.restlet.engine.security.AuthenticatorUtils;
import org.restlet.engine.util.DateUtils;
import org.restlet.engine.util.ReferenceUtils;
import org.restlet.engine.util.StringUtils;
import org.restlet.representation.Representation;
import org.restlet.util.Series;

public class HttpRequest
extends Request {
    private volatile boolean accessControlRequestHeadersAdded;
    private volatile boolean accessControlRequestMethodAdded;
    private volatile boolean cacheDirectivesAdded;
    private volatile boolean clientAdded;
    private volatile boolean conditionAdded;
    private volatile Context context;
    private volatile boolean cookiesAdded;
    private volatile boolean entityAdded;
    private volatile ServerCall httpCall;
    private volatile boolean proxySecurityAdded;
    private volatile boolean rangesAdded;
    private volatile boolean recipientsInfoAdded;
    private volatile boolean referrerAdded;
    private volatile boolean securityAdded;
    private volatile boolean warningsAdded;

    public HttpRequest(Context context, ServerCall httpCall) {
        this.context = context;
        this.clientAdded = false;
        this.conditionAdded = false;
        this.cookiesAdded = false;
        this.entityAdded = false;
        this.referrerAdded = false;
        this.securityAdded = false;
        this.proxySecurityAdded = false;
        this.recipientsInfoAdded = false;
        this.warningsAdded = false;
        this.httpCall = httpCall;
        this.setMethod(Method.valueOf(httpCall.getMethod()));
        StringBuilder sb = new StringBuilder();
        sb.append(httpCall.getProtocol().getSchemeName()).append("://");
        sb.append(httpCall.getHostDomain());
        if (httpCall.getHostPort() != -1 && httpCall.getHostPort() != httpCall.getProtocol().getDefaultPort()) {
            sb.append(':').append(httpCall.getHostPort());
        }
        this.setHostRef(sb.toString());
        if (httpCall.getRequestUri() != null) {
            this.setResourceRef(new Reference(this.getHostRef(), httpCall.getRequestUri()));
            if (this.getResourceRef().isRelative()) {
                if (!httpCall.getRequestUri().startsWith("/")) {
                    this.setResourceRef(new Reference(this.getHostRef().toString() + "/" + httpCall.getRequestUri()));
                } else {
                    this.setResourceRef(new Reference(this.getHostRef().toString() + httpCall.getRequestUri()));
                }
            }
            this.setOriginalRef(ReferenceUtils.getOriginalRef(this.getResourceRef(), httpCall.getRequestHeaders()));
        }
        String dateHeader = httpCall.getRequestHeaders().getFirstValue("Date", true);
        Date date = null;
        if (dateHeader != null) {
            date = DateUtils.parse(dateHeader);
        }
        if (date == null) {
            date = new Date();
        }
        this.setDate(date);
    }

    @Override
    public boolean abort() {
        return this.getHttpCall().abort();
    }

    @Override
    public void flushBuffers() throws IOException {
        this.getHttpCall().flushBuffers();
    }

    @Override
    public Set<String> getAccessControlRequestHeaders() {
        Set<String> result = super.getAccessControlRequestHeaders();
        if (!this.accessControlRequestHeadersAdded) {
            for (String header : this.getHttpCall().getRequestHeaders().getValuesArray("Access-Control-Request-Headers", true)) {
                new StringReader(header).addValues(result);
            }
            this.accessControlRequestHeadersAdded = true;
        }
        return result;
    }

    @Override
    public Method getAccessControlRequestMethod() {
        Method result = super.getAccessControlRequestMethod();
        if (!this.accessControlRequestMethodAdded) {
            String header = this.getHttpCall().getRequestHeaders().getFirstValue("Access-Control-Request-Method", true);
            if (header != null) {
                result = Method.valueOf(header);
                super.setAccessControlRequestMethod(result);
            }
            this.accessControlRequestMethodAdded = true;
        }
        return result;
    }

    @Override
    public List<CacheDirective> getCacheDirectives() {
        List<CacheDirective> result = super.getCacheDirectives();
        if (!this.cacheDirectivesAdded) {
            for (Header header : this.getHttpCall().getRequestHeaders().subList("Cache-Control")) {
                CacheDirectiveReader.addValues(header, result);
            }
            this.cacheDirectivesAdded = true;
        }
        return result;
    }

    @Override
    public ChallengeResponse getChallengeResponse() {
        ChallengeResponse result = super.getChallengeResponse();
        if (!this.securityAdded) {
            String authorization = this.getHttpCall().getRequestHeaders().getValues("Authorization");
            result = AuthenticatorUtils.parseResponse(this, authorization, this.getHttpCall().getRequestHeaders());
            this.setChallengeResponse(result);
            this.securityAdded = true;
        }
        return result;
    }

    @Override
    public ClientInfo getClientInfo() {
        ClientInfo result = super.getClientInfo();
        if (!this.clientAdded) {
            String header;
            boolean useForwardedForHeader;
            String acceptMediaType = this.getHttpCall().getRequestHeaders().getValues("Accept");
            String acceptCharset = this.getHttpCall().getRequestHeaders().getValues("Accept-Charset");
            String acceptEncoding = this.getHttpCall().getRequestHeaders().getValues("Accept-Encoding");
            String acceptLanguage = this.getHttpCall().getRequestHeaders().getValues("Accept-Language");
            String acceptPatch = this.getHttpCall().getRequestHeaders().getValues("Accept-Patch");
            String expect = this.getHttpCall().getRequestHeaders().getValues("Expect");
            try {
                PreferenceReader.addCharacterSets(acceptCharset, result);
            }
            catch (Exception e) {
                this.context.getLogger().log(Level.INFO, e.getMessage());
            }
            try {
                PreferenceReader.addEncodings(acceptEncoding, result);
            }
            catch (Exception e) {
                this.context.getLogger().log(Level.INFO, e.getMessage());
            }
            try {
                PreferenceReader.addLanguages(acceptLanguage, result);
            }
            catch (Exception e) {
                this.context.getLogger().log(Level.INFO, e.getMessage());
            }
            try {
                PreferenceReader.addMediaTypes(acceptMediaType, result);
            }
            catch (Exception e) {
                this.context.getLogger().log(Level.INFO, e.getMessage());
            }
            try {
                PreferenceReader.addPatches(acceptPatch, result);
            }
            catch (Exception e) {
                this.context.getLogger().log(Level.INFO, e.getMessage());
            }
            try {
                ExpectationReader.addValues(expect, result);
            }
            catch (Exception e) {
                this.context.getLogger().log(Level.INFO, e.getMessage());
            }
            result.setAgent(this.getHttpCall().getRequestHeaders().getValues("User-Agent"));
            result.setFrom(this.getHttpCall().getRequestHeaders().getFirstValue("From", true));
            result.setAddress(this.getHttpCall().getClientAddress());
            result.setPort(this.getHttpCall().getClientPort());
            if (this.getHttpCall().getUserPrincipal() != null) {
                result.getPrincipals().add(this.getHttpCall().getUserPrincipal());
            }
            if (this.context != null && (useForwardedForHeader = Boolean.parseBoolean(this.context.getParameters().getFirstValue("useForwardedForHeader", false))) && (header = this.getHttpCall().getRequestHeaders().getValues("X-Forwarded-For")) != null) {
                String[] addresses = header.split(",");
                for (int i = 0; i < addresses.length; ++i) {
                    String address = addresses[i].trim();
                    result.getForwardedAddresses().add(address);
                }
            }
            this.clientAdded = true;
        }
        return result;
    }

    @Override
    public Conditions getConditions() {
        Conditions result = super.getConditions();
        if (!this.conditionAdded) {
            String ifMatchHeader = this.getHttpCall().getRequestHeaders().getValues("If-Match");
            String ifNoneMatchHeader = this.getHttpCall().getRequestHeaders().getValues("If-None-Match");
            Date ifModifiedSince = null;
            Date ifUnmodifiedSince = null;
            String ifRangeHeader = this.getHttpCall().getRequestHeaders().getFirstValue("If-Range", true);
            for (Header header : this.getHttpCall().getRequestHeaders()) {
                if (header.getName().equalsIgnoreCase("If-Modified-Since")) {
                    ifModifiedSince = HeaderReader.readDate(header.getValue(), false);
                    continue;
                }
                if (!header.getName().equalsIgnoreCase("If-Unmodified-Since")) continue;
                ifUnmodifiedSince = HeaderReader.readDate(header.getValue(), false);
            }
            if (ifModifiedSince != null && ifModifiedSince.getTime() != -1L) {
                result.setModifiedSince(ifModifiedSince);
            }
            if (ifUnmodifiedSince != null && ifUnmodifiedSince.getTime() != -1L) {
                result.setUnmodifiedSince(ifUnmodifiedSince);
            }
            if (ifMatchHeader != null) {
                try {
                    new TagReader(ifMatchHeader).addValues(result.getMatch());
                }
                catch (Exception e) {
                    this.context.getLogger().log(Level.INFO, "Unable to process the if-match header: " + ifMatchHeader);
                }
            }
            if (ifNoneMatchHeader != null) {
                try {
                    new TagReader(ifNoneMatchHeader).addValues(result.getNoneMatch());
                }
                catch (Exception e) {
                    this.context.getLogger().log(Level.INFO, "Unable to process the if-none-match header: " + ifNoneMatchHeader);
                }
            }
            if (!StringUtils.isNullOrEmpty(ifRangeHeader)) {
                Tag tag = Tag.parse(ifRangeHeader);
                if (tag != null) {
                    result.setRangeTag(tag);
                } else {
                    Date date = HeaderReader.readDate(ifRangeHeader, false);
                    result.setRangeDate(date);
                }
            }
            this.conditionAdded = true;
        }
        return result;
    }

    @Override
    public Series<Cookie> getCookies() {
        Series<Cookie> result = super.getCookies();
        if (!this.cookiesAdded) {
            String cookieValues = this.getHttpCall().getRequestHeaders().getValues("Cookie");
            if (cookieValues != null) {
                new CookieReader(cookieValues).addValues(result);
            }
            this.cookiesAdded = true;
        }
        return result;
    }

    @Override
    public Representation getEntity() {
        if (!this.entityAdded) {
            this.setEntity(this.getHttpCall().getRequestEntity());
            this.entityAdded = true;
        }
        return super.getEntity();
    }

    public ServerCall getHttpCall() {
        return this.httpCall;
    }

    @Override
    public ChallengeResponse getProxyChallengeResponse() {
        ChallengeResponse result = super.getProxyChallengeResponse();
        if (!this.proxySecurityAdded) {
            String authorization = this.getHttpCall().getRequestHeaders().getValues("Proxy-Authorization");
            result = AuthenticatorUtils.parseResponse(this, authorization, this.getHttpCall().getRequestHeaders());
            this.setProxyChallengeResponse(result);
            this.proxySecurityAdded = true;
        }
        return result;
    }

    @Override
    public List<Range> getRanges() {
        List<Range> result = super.getRanges();
        if (!this.rangesAdded) {
            String ranges = this.getHttpCall().getRequestHeaders().getValues("Range");
            result.addAll(RangeReader.read(ranges));
            this.rangesAdded = true;
        }
        return result;
    }

    @Override
    public List<RecipientInfo> getRecipientsInfo() {
        List<RecipientInfo> result = super.getRecipientsInfo();
        if (!this.recipientsInfoAdded) {
            for (String header : this.getHttpCall().getRequestHeaders().getValuesArray("Via", true)) {
                new RecipientInfoReader(header).addValues(result);
            }
            this.recipientsInfoAdded = true;
        }
        return result;
    }

    @Override
    public Reference getReferrerRef() {
        if (!this.referrerAdded) {
            String referrerValue = this.getHttpCall().getRequestHeaders().getValues("Referer");
            if (referrerValue != null) {
                this.setReferrerRef(new Reference(referrerValue));
            }
            this.referrerAdded = true;
        }
        return super.getReferrerRef();
    }

    @Override
    public List<Warning> getWarnings() {
        List<Warning> result = super.getWarnings();
        if (!this.warningsAdded) {
            for (String header : this.getHttpCall().getRequestHeaders().getValuesArray("Warning", true)) {
                new WarningReader(header).addValues(result);
            }
            this.warningsAdded = true;
        }
        return result;
    }

    @Override
    public void setAccessControlRequestHeaders(Set<String> accessControlRequestHeaders) {
        super.setAccessControlRequestHeaders(accessControlRequestHeaders);
        this.accessControlRequestHeadersAdded = true;
    }

    @Override
    public void setAccessControlRequestMethod(Method accessControlRequestMethod) {
        super.setAccessControlRequestMethod(accessControlRequestMethod);
        this.accessControlRequestMethodAdded = true;
    }

    @Override
    public void setChallengeResponse(ChallengeResponse response) {
        super.setChallengeResponse(response);
        this.securityAdded = true;
    }

    @Override
    public void setEntity(Representation entity) {
        super.setEntity(entity);
        this.entityAdded = true;
    }

    @Override
    public void setProxyChallengeResponse(ChallengeResponse response) {
        super.setProxyChallengeResponse(response);
        this.proxySecurityAdded = true;
    }

    @Override
    public void setRecipientsInfo(List<RecipientInfo> recipientsInfo) {
        super.setRecipientsInfo(recipientsInfo);
        this.recipientsInfoAdded = true;
    }

    @Override
    public void setWarnings(List<Warning> warnings) {
        super.setWarnings(warnings);
        this.warningsAdded = true;
    }
}

