/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.engine.resource.AnnotationInfo;
import org.restlet.engine.util.StringUtils;
import org.restlet.engine.util.SystemUtils;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.service.ConverterService;
import org.restlet.service.MetadataService;

public class MethodAnnotationInfo
extends AnnotationInfo {
    private final String input;
    private final String output;
    private final String query;
    private final Method restletMethod;

    public MethodAnnotationInfo(Class<?> javaClass, Method restletMethod, java.lang.reflect.Method javaMethod, String annotationValue) {
        super(javaClass, javaMethod, annotationValue);
        this.restletMethod = restletMethod;
        if (!StringUtils.isNullOrEmpty(annotationValue)) {
            int queryIndex = annotationValue.indexOf(63);
            if (queryIndex != -1) {
                this.query = annotationValue.substring(queryIndex + 1);
                annotationValue = annotationValue.substring(0, queryIndex);
            } else {
                this.query = null;
            }
            int ioSeparatorIndex = annotationValue.indexOf(58);
            if (ioSeparatorIndex != -1) {
                this.input = annotationValue.substring(0, ioSeparatorIndex);
                this.output = annotationValue.substring(ioSeparatorIndex + 1);
            } else {
                this.input = annotationValue;
                this.output = annotationValue;
            }
        } else {
            this.query = null;
            this.input = null;
            this.output = null;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MethodAnnotationInfo)) {
            return false;
        }
        MethodAnnotationInfo that = (MethodAnnotationInfo)other;
        return super.equals(that) && Objects.equals(this.getRestletMethod(), that.getRestletMethod());
    }

    public String getInput() {
        return this.input;
    }

    private Class<?> getJavaInputType(int index) {
        return this.getJavaActualType(this.javaMethodImpl.getParameterTypes()[index], this.javaMethodImpl.getGenericParameterTypes()[index]);
    }

    public Class<?>[] getJavaInputTypes() {
        int count = this.getJavaMethod().getParameterTypes().length;
        Class[] classes = new Class[count];
        for (int i = 0; i < count; ++i) {
            classes[i] = this.getJavaInputType(i);
        }
        return classes;
    }

    public Class<?> getJavaOutputType() {
        return this.getJavaActualType(this.javaMethodImpl.getReturnType(), this.javaMethodImpl.getGenericReturnType());
    }

    public String getOutput() {
        return this.output;
    }

    public String getQuery() {
        return this.query;
    }

    public List<Variant> getRequestVariants(MetadataService metadataService, ConverterService converterService) throws IOException {
        Class<?> inputClass;
        List<Variant> result = null;
        Class<?>[] classes = this.getJavaInputTypes();
        if (classes != null && classes.length >= 1 && (result = this.getVariants(metadataService, this.getInput())) == null && (inputClass = classes[0]) != null) {
            result = converterService.getVariants(inputClass, null);
        }
        return result;
    }

    public List<Variant> getResponseVariants(MetadataService metadataService, ConverterService converterService) throws IOException {
        List<Variant> result = null;
        if (this.getJavaOutputType() != null && this.getJavaOutputType() != Void.TYPE && this.getJavaOutputType() != Void.class && (result = this.getVariants(metadataService, this.getOutput())) == null) {
            result = converterService.getVariants(this.getJavaOutputType(), null);
        }
        return result;
    }

    public Method getRestletMethod() {
        return this.restletMethod;
    }

    private List<Variant> getVariants(MetadataService metadataService, String annotationValue) {
        ArrayList<Variant> result = null;
        if (annotationValue != null) {
            StringTokenizer stValue = new StringTokenizer(annotationValue, "\\|");
            while (stValue.hasMoreTokens()) {
                String variantValue = stValue.nextToken().trim();
                Variant variant = null;
                ArrayList<MediaType> mediaTypes = null;
                ArrayList<Language> languages = null;
                CharacterSet characterSet = null;
                StringTokenizer stExtension = new StringTokenizer(variantValue, "\\+");
                while (stExtension.hasMoreTokens()) {
                    List<Metadata> metadataList;
                    String extension = stExtension.nextToken().trim();
                    if (extension == null || (metadataList = metadataService.getAllMetadata(extension)) == null) continue;
                    for (Metadata metadata : metadataList) {
                        if (metadata instanceof MediaType) {
                            if (mediaTypes == null) {
                                mediaTypes = new ArrayList<MediaType>();
                            }
                            mediaTypes.add((MediaType)metadata);
                            continue;
                        }
                        if (metadata instanceof Language) {
                            if (languages == null) {
                                languages = new ArrayList<Language>();
                            }
                            languages.add((Language)metadata);
                            continue;
                        }
                        if (!(metadata instanceof CharacterSet)) continue;
                        if (characterSet == null) {
                            characterSet = (CharacterSet)metadata;
                            continue;
                        }
                        Context.getCurrentLogger().warning("A representation variant can have only one character set. Please check your annotation value.");
                    }
                }
                if (mediaTypes == null) continue;
                for (MediaType mediaType : mediaTypes) {
                    if (result != null && result.contains(mediaType)) continue;
                    if (result == null) {
                        result = new ArrayList<Variant>();
                    }
                    variant = new Variant(mediaType);
                    if (languages != null) {
                        variant.getLanguages().addAll(languages);
                    }
                    if (characterSet != null) {
                        variant.setCharacterSet(characterSet);
                    }
                    result.add(variant);
                }
            }
        }
        return result;
    }

    @Override
    public int hashCode() {
        return SystemUtils.hashCode(super.hashCode(), this.restletMethod);
    }

    public boolean isCompatible(Method restletMethod, Form queryParams, Representation requestEntity, MetadataService metadataService, ConverterService converterService) throws IOException {
        boolean result = true;
        if (this.getQuery() != null) {
            Form requiredParams = new Form(this.getQuery());
            Iterator iter = requiredParams.iterator();
            while (iter.hasNext() && result) {
                result = queryParams.contains(iter.next());
            }
        }
        if (result) {
            result = this.getRestletMethod().equals(restletMethod);
        }
        if (result) {
            result = this.isCompatibleRequestEntity(requestEntity, metadataService, converterService);
        }
        return result;
    }

    public boolean isCompatibleRequestEntity(Representation requestEntity, MetadataService metadataService, ConverterService converterService) throws IOException {
        boolean result = true;
        if (requestEntity != null && requestEntity.isAvailable()) {
            List<Variant> requestVariants = this.getRequestVariants(metadataService, converterService);
            if (requestVariants != null && !requestVariants.isEmpty()) {
                result = false;
                for (int i = 0; !result && i < requestVariants.size(); ++i) {
                    result = requestVariants.get(i).isCompatible(requestEntity);
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    @Override
    public String toString() {
        return "MethodAnnotationInfo [javaMethod: " + String.valueOf(this.javaMethod) + ", javaClass: " + String.valueOf(this.getJavaClass()) + ", restletMethod: " + String.valueOf(this.restletMethod) + ", input: " + this.getInput() + ", value: " + this.getAnnotationValue() + ", output: " + this.getOutput() + ", query: " + this.getQuery() + "]";
    }
}

