/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.rest.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.ThreadSafe;
import org.restcomm.sbc.bo.Statistics;
import org.restcomm.sbc.rest.converter.AbstractConverter;

@ThreadSafe
public final class StatisticsConverter
extends AbstractConverter
implements JsonSerializer<Statistics> {
    public StatisticsConverter(Configuration configuration) {
        super(configuration);
    }

    public boolean canConvert(Class klass) {
        return Statistics.class.equals((Object)klass);
    }

    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        Statistics stat = (Statistics)object;
        writer.startNode("Statistics");
        this.writeSid(stat.getSid(), writer);
        this.writeInteger(stat.getCpuUsage(), "CpuUsage", writer);
        this.writeInteger(stat.getCallRejectedCount(), "CallsRejected", writer);
        this.writeInteger(stat.getLiveCallsCount(), "LiveCalls", writer);
        this.writeInteger(stat.getMemoryUsage(), "MemoryUsage", writer);
        this.writeInteger(stat.getThreatCount(), "Threats", writer);
        this.writeDouble(stat.getCallRate(), "CallRate", writer);
        this.writeDateCreated(stat.getDateCreated(), writer);
        writer.endNode();
    }

    public JsonElement serialize(Statistics stat, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(stat.getSid(), object);
        this.writeInteger(stat.getCpuUsage(), "cpu_usage", object);
        this.writeInteger(stat.getCallRejectedCount(), "calls_rejected", object);
        this.writeInteger(stat.getLiveCallsCount(), "live_calls", object);
        this.writeInteger(stat.getMemoryUsage(), "memory_usage", object);
        this.writeInteger(stat.getThreatCount(), "threats", object);
        this.writeDouble(stat.getCallRate(), "call_rate", object);
        this.writeDateCreated(stat.getDateCreated(), object);
        return object;
    }

    protected void writeInteger(int value, String name, HierarchicalStreamWriter writer) {
        writer.startNode(name);
        writer.setValue("" + value);
        writer.endNode();
    }

    protected void writeDouble(double value, String name, HierarchicalStreamWriter writer) {
        writer.startNode(name);
        writer.setValue("" + value);
        writer.endNode();
    }

    protected void writeInteger(int value, String name, JsonObject object) {
        object.addProperty(name, "" + value);
    }

    protected void writeDouble(double value, String name, JsonObject object) {
        object.addProperty(name, "" + value);
    }
}

