/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.notification.impl;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.restcomm.chain.processor.impl.MutableMessage;
import org.restcomm.sbc.managers.CacheManager;
import org.restcomm.sbc.notification.SuspectActivityElectable;

public class SuspectActivityCache<K, T>
implements MutableMessage {
    private boolean linked = true;
    private boolean aborted = false;
    private int ttl;
    private Cache<Object, Object> cache;
    private static SuspectActivityCache<String, SuspectActivityElectable> scache;

    private SuspectActivityCache(int size, int ttl) {
        this.ttl = ttl;
        this.cache = CacheManager.getCacheManager().getCache("suspectactivity");
        this.cache.start();
    }

    public static SuspectActivityCache<String, SuspectActivityElectable> getCache(int size, int ttl) {
        if (scache == null) {
            scache = new SuspectActivityCache(size, ttl);
        }
        return scache;
    }

    public void update(String key, SuspectActivityElectable value) {
        this.cache.put((Object)key, (Object)value, (long)this.ttl, TimeUnit.SECONDS);
    }

    public SuspectActivityElectable get(String key) {
        return (SuspectActivityElectable)this.cache.get((Object)key);
    }

    public void remove(String key) {
        this.cache.remove((Object)key);
    }

    public int size() {
        return this.cache.size();
    }

    public void cleanup() {
        this.cache.clear();
    }

    public Object getContent() {
        return this.cache.get((Object)"content");
    }

    public void setContent(Object value) {
        this.update("content", (SuspectActivityElectable)value);
    }

    public void unlink() {
        this.linked = false;
    }

    public boolean isLinked() {
        return this.linked;
    }

    public void abort() {
        this.aborted = true;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public int getDirection() {
        return 0;
    }

    public String getSourceLocalAddress() {
        return null;
    }

    public String getSourceRemoteAddress() {
        return null;
    }

    public String getTargetLocalAddress() {
        return null;
    }

    public String getTargetRemoteAddress() {
        return null;
    }

    public Object getMetadata() {
        return null;
    }

    public int getTarget() {
        return 0;
    }

    public String getTargetTransport() {
        return null;
    }

    public String getSourceTransport() {
        return null;
    }
}

