/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.media.srtp;

import org.apache.log4j.Logger;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.mobicents.media.server.impl.rtp.crypto.AlgorithmCertificate;
import org.mobicents.media.server.impl.rtp.crypto.CipherSuite;
import org.mobicents.media.server.impl.rtp.crypto.DtlsSrtpServer;
import org.mobicents.media.server.impl.rtp.crypto.DtlsSrtpServerProvider;
import org.mobicents.media.server.impl.rtp.crypto.RawPacket;
import org.mobicents.media.server.impl.srtp.DtlsHandler;
import org.mobicents.media.server.impl.srtp.DtlsListener;

public class DtlsHandlerTest
implements DtlsListener {
    DtlsHandler dtlsHandler;
    private static Logger LOG = Logger.getLogger(DtlsHandlerTest.class);
    private static final byte[] HELLO_CLIENT = new byte[]{22, -2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, -106, 1, 0, 0, -118, 0, 0, 0, 0, 0, 0, 0, -118, -2, -3, -80, 106, 118, -80, 70, -13, 118, 27, 67, 40, -87, 119, -45, -56, 101, 86, 61, -124, -7, 96, -110, -113, 115, 21, 78, 91, 70, 90, -109, -99, -5, 13, 0, 0, 0, 30, -64, 43, -64, 47, 0, -98, -52, 20, -52, 19, -64, 10, -64, 20, 0, 57, -64, 9, -64, 19, 0, 51, 0, -100, 0, 53, 0, 47, 0, 10, 1, 0, 0, 66, -1, 1, 0, 1, 0, 0, 23, 0, 0, 0, 35, 0, 0, 0, 13, 0, 22, 0, 20, 6, 1, 6, 3, 5, 1, 5, 3, 4, 1, 4, 3, 3, 1, 3, 3, 2, 1, 2, 3, 0, 14, 0, 7, 0, 4, 0, 2, 0, 1, 0, 0, 11, 0, 2, 1, 0, 0, 10, 0, 6, 0, 4, 0, 23, 0, 24};
    private static final byte[] RTP_PACKET = new byte[]{-128, 8, 106, 108, -63, -85, 116, -115, -78, -30, -125, 105, 87, 87, 87, 87, 87, 87, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 54, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84};
    private static final int[] cipherSuites = new int[]{49200, 49199, 49192, 49191, 49172, 49171, 159, 158, 107, 103, 57, 51, 157, 156, 61, 60, 53, 47, 49195};

    public DtlsHandlerTest() {
        CipherSuite[] suites = new CipherSuite[]{CipherSuite.getEnum((int)49200), CipherSuite.getEnum((int)49199), CipherSuite.getEnum((int)49192), CipherSuite.getEnum((int)49191), CipherSuite.getEnum((int)49172), CipherSuite.getEnum((int)49171), CipherSuite.getEnum((int)159), CipherSuite.getEnum((int)158), CipherSuite.getEnum((int)107), CipherSuite.getEnum((int)103), CipherSuite.getEnum((int)57), CipherSuite.getEnum((int)51), CipherSuite.getEnum((int)157), CipherSuite.getEnum((int)156), CipherSuite.getEnum((int)61), CipherSuite.getEnum((int)60), CipherSuite.getEnum((int)53), CipherSuite.getEnum((int)47), CipherSuite.getEnum((int)49195)};
        DtlsSrtpServerProvider dtlsServerProvider = new DtlsSrtpServerProvider(ProtocolVersion.DTLSv10, ProtocolVersion.DTLSv12, suites, System.getProperty("user.home") + "/certs/id_rsa.public", System.getProperty("user.home") + "/certs/id_rsa.private", AlgorithmCertificate.RSA);
        DtlsSrtpServer dtlsSrtpServer = dtlsServerProvider.provide();
        this.dtlsHandler = new DtlsHandler(dtlsServerProvider);
        this.dtlsHandler.addListener((DtlsListener)this);
    }

    public static void main(String[] argv) {
        RawPacket packet = new RawPacket(RTP_PACKET, 0, RTP_PACKET.length);
        DtlsHandlerTest test = new DtlsHandlerTest();
        boolean canHandleHelloClient = test.dtlsHandler.canHandle(HELLO_CLIENT);
        boolean canHandleRtp = test.dtlsHandler.canHandle(RTP_PACKET);
        LOG.info((Object)("Can handle Hello Client? " + canHandleHelloClient));
        System.out.println("Raw RTP PayloadType ? " + packet.getPayloadType());
        System.out.println("Can handle RTP? " + canHandleRtp);
        test.dtlsHandler.handshake();
        while (test.dtlsHandler.isHandshaking()) {
        }
    }

    public void onDtlsHandshakeComplete() {
        LOG.info((Object)"onDtlsHandshakeComplete()");
    }

    public void onDtlsHandshakeFailed(Throwable arg0) {
        LOG.error((Object)"onDtlsHandshakeFailed()", arg0);
    }
}

