/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.media;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.rtp.crypto.RawPacket;
import org.mobicents.media.server.io.sdp.SessionDescription;
import org.restcomm.sbc.ConfigurationCache;
import org.restcomm.sbc.media.MediaController;
import org.restcomm.sbc.media.MediaZone;
import org.restcomm.sbc.media.srtp.RtpConnection;

public class MediaZone {
    protected static final int BUFFER = 1500;
    private static transient Logger LOG = Logger.getLogger(MediaZone.class);
    protected int originalRtpPort;
    protected int originalRtcpPort;
    protected boolean canMux;
    protected int rtpCountLog = ConfigurationCache.getRtpCountLog();
    protected String originalHost;
    protected String proxyHost;
    protected String mediaType;
    protected int logCounter = 0;
    protected boolean running;
    protected boolean suspended;
    protected MediaZone mediaZonePeer;
    protected ExecutorService executorService;
    protected ExecutorService rtcpService;
    protected DatagramChannel channel;
    protected DatagramChannel rtcpChannel;
    protected DatagramSocket socket;
    protected DatagramSocket rtcpSocket;
    protected int packetsSentCounter = 0;
    protected int packetsRecvCounter = 0;
    protected int lastPacketsSentCounter = 0;
    protected int lastPacketsRecvCounter = 0;
    protected int proxyPort;
    protected Direction direction;
    protected InetSocketAddress proxyAddress;
    protected InetSocketAddress rtcpProxyAddress;
    private InetAddress originalAddress;
    protected MediaController controller;
    protected RtpConnection rtpConnection;
    byte[] rbuffer = new byte[1500];
    DatagramPacket rdgram = new DatagramPacket(this.rbuffer, 1500);
    byte[] buffer = new byte[1500];
    DatagramPacket dgram = new DatagramPacket(this.buffer, 1500);

    public MediaZone(MediaController controller, Direction direction, String mediaType, String originalHost, int originalRtpPort, int originalRtcpPort, boolean canMux, int proxyPort) throws UnknownHostException {
        this.controller = controller;
        this.originalHost = originalHost;
        this.originalRtpPort = originalRtpPort;
        this.originalRtcpPort = originalRtcpPort;
        this.canMux = canMux;
        this.mediaType = mediaType;
        this.direction = direction;
        this.proxyPort = proxyPort;
        this.originalAddress = InetAddress.getByName(originalHost);
        this.rtpConnection = new RtpConnection(controller, originalHost, originalRtpPort);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("direction " + direction));
        }
    }

    public void setLocalProxy(String proxyHost) throws UnknownHostException, SocketException {
        this.proxyHost = proxyHost;
        this.proxyAddress = new InetSocketAddress(proxyHost, this.proxyPort);
        try {
            this.channel = DatagramChannel.open();
            this.channel.bind(this.proxyAddress);
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
        this.socket = this.channel.socket();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Opened socket " + this.proxyAddress.toString() + " for " + this.toPrint()));
        }
        if (!this.canMux) {
            this.rtcpProxyAddress = new InetSocketAddress(proxyHost, this.proxyPort + 1);
            try {
                this.rtcpChannel = DatagramChannel.open();
                this.rtcpChannel.bind(this.rtcpProxyAddress);
            }
            catch (IOException e) {
                throw new SocketException(e.getMessage());
            }
            this.rtcpSocket = this.rtcpChannel.socket();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Opened socket " + this.rtcpProxyAddress.toString() + " for " + this.toPrint()));
            }
        }
    }

    public SessionDescription getLocalSdp() {
        return this.controller.getSdp();
    }

    protected synchronized boolean checkReady() {
        if (!this.isAttached()) {
            return false;
        }
        if (this.originalHost == null || this.originalRtpPort == 0) {
            return false;
        }
        return this.proxyHost != null && this.proxyPort != 0;
    }

    protected void fireProxyTimeoutEvent() {
        this.controller.getMediaSession().fireMediaTimeoutEvent(this);
    }

    protected void fireProxyTerminatedEvent() {
        this.controller.getMediaSession().fireMediaTerminatedEvent(this);
    }

    protected void fireProxyReadyEvent() {
        this.controller.getMediaSession().fireMediaReadyEvent(this);
    }

    protected void fireProxyFailedEvent() {
        this.controller.getMediaSession().fireMediaFailedEvent(this);
    }

    public int getOriginalRtpPort() {
        return this.originalRtpPort;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getOriginalHost() {
        return this.originalHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void start() throws IOException {
        if (this.isRunning()) {
            LOG.warn((Object)"Media Proxy is just running, silently ignoring");
            return;
        }
        if (!this.checkReady()) {
            LOG.warn((Object)("Media Zone could not stablish proper routes, should dismiss? " + this.toPrint()));
        }
        if (this.channel != null && !this.channel.isConnected()) {
            LOG.debug((Object)("MUST Connect audio stream " + this.channel.getLocalAddress() + " to " + this.mediaZonePeer.getOriginalHost() + ":" + this.mediaZonePeer.getOriginalRtpPort()));
        }
        this.setRunning(true);
        this.executorService = Executors.newCachedThreadPool();
        this.executorService.execute((Runnable)new Proxy(this));
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Started " + this.isRunning() + "->" + this.toPrint()));
        }
        if (!this.canMux) {
            this.rtcpService = Executors.newCachedThreadPool();
            this.rtcpService.execute((Runnable)new RtcpProxy(this));
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Started " + this.isRunning() + "-> RtcpProxy"));
            }
        }
    }

    public void suspend() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Suspending mediaZone " + this.toPrint()));
        }
        this.suspended = true;
    }

    public void resume() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Resuming mediaZone " + this.toPrint()));
        }
        this.suspended = false;
    }

    public void finalize() {
        this.setRunning(false);
        if (this.mediaZonePeer != null) {
            this.setRunning(false);
            if (this.mediaZonePeer.socket != null && !this.mediaZonePeer.socket.isClosed()) {
                this.mediaZonePeer.socket.close();
                this.mediaZonePeer.socket = null;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Finalized mediaZone " + this.mediaZonePeer.toPrint()));
                }
            }
            if (this.mediaZonePeer.executorService != null) {
                this.mediaZonePeer.executorService.shutdown();
                this.mediaZonePeer.executorService = null;
                this.mediaZonePeer.fireProxyTerminatedEvent();
            }
            if (!this.canMux) {
                if (this.mediaZonePeer.rtcpSocket != null && !this.mediaZonePeer.rtcpSocket.isClosed()) {
                    this.mediaZonePeer.rtcpSocket.close();
                    this.mediaZonePeer.rtcpSocket = null;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)"Finalized RTCP mediaZone ");
                    }
                }
                if (this.mediaZonePeer.rtcpService != null) {
                    this.mediaZonePeer.rtcpService.shutdown();
                    this.mediaZonePeer.rtcpService = null;
                }
            }
        }
        this.mediaZonePeer = null;
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
            this.socket = null;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Finalized mediaZone " + this.toPrint()));
            }
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
            this.fireProxyTerminatedEvent();
        }
        if (!this.canMux) {
            if (this.rtcpSocket != null && !this.rtcpSocket.isClosed()) {
                this.rtcpSocket.close();
                this.rtcpSocket = null;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"Finalized RTCP mediaZone ");
                }
            }
            if (this.rtcpService != null) {
                this.rtcpService.shutdown();
                this.rtcpService = null;
            }
        }
    }

    public String toPrint() {
        String value = "(UMZ " + this.direction + ") " + this.hashCode() + " " + this.mediaType + ", MUX(" + this.canMux + ") Origin " + this.originalHost + ":" + this.originalRtpPort + "/" + this.originalRtcpPort + ", LocalProxy " + this.proxyHost + ":" + this.proxyPort;
        if (this.mediaZonePeer != null) {
            value = value + "[(" + this.mediaZonePeer.direction + ") " + this.mediaZonePeer.hashCode() + " " + this.mediaZonePeer.mediaType + ", MUX(" + this.mediaZonePeer.canMux + ") Origin " + this.mediaZonePeer.originalHost + ":" + this.mediaZonePeer.originalRtpPort + "/" + this.mediaZonePeer.originalRtcpPort + ", LocalProxy " + this.mediaZonePeer.proxyHost + ":" + this.mediaZonePeer.proxyPort + "]";
        }
        return value;
    }

    public byte[] encodeRTP(byte[] data, int offset, int length) {
        return ArrayUtils.subarray((byte[])data, (int)offset, (int)length);
    }

    public byte[] decodeRTP(byte[] data, int offset, int length) {
        return ArrayUtils.subarray((byte[])data, (int)offset, (int)length);
    }

    public void send(DatagramPacket dgram) throws IOException {
        if (dgram == null) {
            return;
        }
        dgram.setAddress(this.mediaZonePeer.getOriginalAddress());
        dgram.setPort(this.mediaZonePeer.getOriginalRtpPort());
        if (dgram.getData().length > 8) {
            if (this.logCounter == this.rtpCountLog) {
                RawPacket rtp = new RawPacket(dgram.getData(), 0, dgram.getLength());
                LOG.trace((Object)("--->[PayloadType " + rtp.getPayloadType() + "](" + this.mediaType + ", " + this.direction + ") LocalProxy " + this.proxyHost + ":" + this.proxyPort + "/" + dgram.getAddress() + ":" + dgram.getPort() + "[" + dgram.getLength() + "]"));
                this.logCounter = 0;
            }
        } else {
            LOG.warn((Object)("--->[PayloadType ?](" + this.mediaType + ", " + this.direction + ") LocalProxy " + this.proxyHost + ":" + this.proxyPort + "/" + dgram.getAddress() + ":" + dgram.getPort() + "[" + dgram.getLength() + "]"));
        }
        ++this.packetsSentCounter;
        this.socket.send(dgram);
    }

    public DatagramPacket receiveRtcp() throws IOException {
        if (this.mediaZonePeer.rtcpSocket == null) {
            throw new IOException("NULL Socket on " + this.toPrint());
        }
        this.mediaZonePeer.rtcpSocket.receive(this.rdgram);
        if (this.rdgram == null || this.rdgram.getLength() < 8) {
            LOG.warn((Object)("RTCPPacket too short, not sending [" + (this.rdgram != null ? Integer.valueOf(this.rdgram.getLength()) : "NULL") + "]"));
            this.rdgram = new DatagramPacket(this.rbuffer, 1500);
            return null;
        }
        return this.rdgram;
    }

    public void sendRtcp(DatagramPacket rdgram) throws IOException {
        if (rdgram == null) {
            return;
        }
        rdgram.setAddress(this.mediaZonePeer.getOriginalAddress());
        rdgram.setPort(this.mediaZonePeer.getOriginalRtcpPort());
        this.rtcpSocket.send(rdgram);
    }

    public DatagramPacket receive() throws IOException {
        if (this.mediaZonePeer.socket == null) {
            throw new IOException("NULL Socket on " + this.toPrint());
        }
        this.mediaZonePeer.socket.receive(this.dgram);
        if (this.dgram == null || this.dgram.getLength() < 8) {
            LOG.warn((Object)("RTPPacket too short on " + this.toPrint(this.mediaZonePeer.socket) + " not sending [" + (this.dgram != null ? Integer.valueOf(this.dgram.getLength()) : "NULL") + "]"));
            this.dgram = new DatagramPacket(this.buffer, 1500);
            return null;
        }
        this.dgram.setData(this.mediaZonePeer.encodeRTP(this.dgram.getData(), 0, this.dgram.getLength()));
        ++this.logCounter;
        if (this.logCounter == this.rtpCountLog) {
            RawPacket rtp = new RawPacket(this.dgram.getData(), 0, this.dgram.getLength());
            LOG.trace((Object)("<---[PayloadType " + rtp.getPayloadType() + "](" + this.mediaType + ", " + this.direction + ") LocalProxy " + this.proxyHost + ":" + this.proxyPort + "/" + this.dgram.getAddress() + ":" + this.dgram.getPort() + "[" + this.dgram.getLength() + "]"));
        }
        ++this.packetsRecvCounter;
        return this.dgram;
    }

    public final void attach(MediaZone mediaZone) {
        if (!this.isAttached()) {
            this.setMediaZonePeer(mediaZone);
        }
        if (!mediaZone.isAttached()) {
            mediaZone.attach(this);
        }
        if (this.checkReady()) {
            this.fireProxyReadyEvent();
        }
    }

    public boolean isAttached() {
        return this.mediaZonePeer != null;
    }

    public boolean isStreaming() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Packets stats on " + this.toPrint()));
            LOG.trace((Object)("Packets total/sent " + this.packetsSentCounter + "/" + this.lastPacketsSentCounter));
            LOG.trace((Object)("Packets total/recv " + this.packetsRecvCounter + "/" + this.lastPacketsRecvCounter));
        }
        if (this.packetsSentCounter > this.lastPacketsSentCounter && this.packetsRecvCounter > this.lastPacketsRecvCounter && this.packetsSentCounter > 0 && this.packetsRecvCounter > 0) {
            this.lastPacketsSentCounter = this.packetsSentCounter;
            this.lastPacketsRecvCounter = this.packetsRecvCounter;
            return true;
        }
        return false;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public MediaZone getMediaZonePeer() {
        return this.mediaZonePeer;
    }

    protected void setMediaZonePeer(MediaZone mediaZonePeer) {
        this.mediaZonePeer = mediaZonePeer;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    protected synchronized void setRunning(boolean running) {
        this.running = running;
    }

    public int getPacketsSentCounter() {
        return this.packetsSentCounter;
    }

    public int getPacketsRecvCounter() {
        return this.packetsRecvCounter;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public boolean equals(Object zone) {
        MediaZone otherZone = (MediaZone)zone;
        if (!(zone instanceof MediaZone)) {
            return false;
        }
        return otherZone.getOriginalHost().equals(this.getOriginalHost()) && otherZone.getController().equals((Object)this.getController()) && otherZone.getOriginalRtpPort() == this.getOriginalRtpPort() && otherZone.getMediaType().equals(this.getMediaType()) && otherZone.getDirection().equals((Object)this.getDirection());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.controller == null ? 0 : this.controller.hashCode());
        result = prime * result + (this.originalHost == null ? 0 : this.originalHost.hashCode());
        result = prime * result + (this.originalRtpPort == 0 ? 0 : this.originalRtpPort);
        result = prime * result + (this.mediaType == null ? 0 : this.mediaType.hashCode());
        result = prime * result + (this.direction == null ? 0 : this.direction.hashCode());
        return result;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public InetSocketAddress getProxyAddress() {
        return this.proxyAddress;
    }

    public InetAddress getOriginalAddress() {
        return this.originalAddress;
    }

    public MediaController getController() {
        return this.controller;
    }

    public boolean canMux() {
        return this.canMux;
    }

    public DatagramChannel getChannel() {
        return this.channel;
    }

    public RtpConnection getRtpConnection() {
        return this.rtpConnection;
    }

    public int getOriginalRtcpPort() {
        return this.originalRtcpPort;
    }

    private String toPrint(DatagramSocket socket) {
        return "Socket Bound to " + socket.getLocalSocketAddress() + " Connected to " + socket.getRemoteSocketAddress();
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

