/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.media;

import java.net.UnknownHostException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;
import org.mobicents.media.server.io.sdp.SdpException;
import org.restcomm.sbc.media.MediaController;
import org.restcomm.sbc.media.MediaSession;
import org.restcomm.sbc.media.MediaSessionListener;
import org.restcomm.sbc.media.MediaZone;
import org.restcomm.sbc.media.PortManager;

public class MediaSession {
    private static transient Logger LOG = Logger.getLogger(MediaSession.class);
    private EventListenerList listenerList = new EventListenerList();
    private State state;
    private String sessionId;
    private MediaController offer;
    private MediaController answer;
    protected ScheduledExecutorService timeService;
    private PortManager portManager = PortManager.getPortManager();
    public final int MEDIATYPE_AUDIO = this.portManager.getNextAvailablePort();
    public final int MEDIATYPE_VIDEO = this.portManager.getNextAvailablePort();
    public final int[] proxyPorts = new int[]{this.MEDIATYPE_AUDIO, this.MEDIATYPE_VIDEO};

    public MediaSession(String id) {
        this.sessionId = id;
        this.setState(State.INACTIVE);
    }

    private String toPrint() {
        return "[MediaSession (" + this.sessionId + ")]";
    }

    public MediaController buildOffer(MediaController.StreamProfile streamProfile, String sdpOffer, String targetProxyAddress) throws UnknownHostException, SdpException {
        this.offer = new MediaController(this, streamProfile, MediaZone.Direction.OFFER, sdpOffer, targetProxyAddress);
        return this.offer;
    }

    public MediaController buildAnswer(MediaController.StreamProfile streamProfile, String sdpAnswer, String targetProxyAddress) throws UnknownHostException, SdpException {
        this.answer = new MediaController(this, streamProfile, MediaZone.Direction.ANSWER, sdpAnswer, targetProxyAddress);
        return this.answer;
    }

    public void attach() {
        if (this.answer == null || this.offer == null) {
            throw new IllegalStateException("Cannot attach uninitialized MediaControllers!");
        }
        this.answer.attach(this.offer);
    }

    public void addMediaSessionListener(MediaSessionListener listener) {
        this.listenerList.add(MediaSessionListener.class, listener);
    }

    protected void fireMediaTimeoutEvent(MediaZone mediaZone) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MediaSessionListener.class) continue;
            ((MediaSessionListener)listeners[i + 1]).onMediaTimeout(this, mediaZone);
        }
    }

    protected void fireMediaTerminatedEvent(MediaZone mediaZone) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MediaSessionListener.class) continue;
            ((MediaSessionListener)listeners[i + 1]).onMediaTerminated(this, mediaZone);
        }
    }

    protected void fireMediaReadyEvent(MediaZone mediaZone) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MediaSessionListener.class) continue;
            ((MediaSessionListener)listeners[i + 1]).onMediaReady(this, mediaZone);
        }
    }

    protected void fireMediaFailedEvent(MediaZone mediaZone) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MediaSessionListener.class) continue;
            ((MediaSessionListener)listeners[i + 1]).onMediaFailed(this, mediaZone);
        }
    }

    public void start() throws UnknownHostException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Starting " + this.toPrint()));
        }
        this.timeService = Executors.newSingleThreadScheduledExecutor();
        this.timeService.scheduleWithFixedDelay((Runnable)new MediaTimer(this), 60L, 60L, TimeUnit.SECONDS);
        this.setState(State.ACTIVE);
    }

    public void finalize() {
        if (this.offer != null) {
            this.offer.finalize();
        }
        if (this.answer != null) {
            this.answer.finalize();
        }
        if (this.timeService != null) {
            this.timeService.shutdown();
            this.timeService = null;
        }
        this.offer = null;
        this.answer = null;
        this.setState(State.CLOSED);
    }

    public boolean isActive() {
        return this.state == State.ACTIVE;
    }

    public State getState() {
        return this.state;
    }

    private void setState(State state) {
        this.state = state;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean equals(Object session) {
        MediaSession otherSession = (MediaSession)session;
        if (!(session instanceof MediaSession)) {
            return false;
        }
        return otherSession.sessionId.equals(this.sessionId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        return result;
    }

    public MediaController getOffer() {
        return this.offer;
    }

    public MediaController getAnswer() {
        return this.answer;
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    static /* synthetic */ String access$100(MediaSession x0) {
        return x0.toPrint();
    }

    static /* synthetic */ MediaController access$200(MediaSession x0) {
        return x0.offer;
    }

    static /* synthetic */ MediaController access$300(MediaSession x0) {
        return x0.answer;
    }
}

