/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.managers.jmx.tomcat;

import com.sun.management.OperatingSystemMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.SipConnector;
import org.mobicents.servlet.sip.listener.SipConnectorListener;
import org.restcomm.sbc.bo.Connector;
import org.restcomm.sbc.bo.NetworkPoint;
import org.restcomm.sbc.managers.NetworkManager;
import org.restcomm.sbc.managers.jmx.JMXProvider;

public class Provider
implements JMXProvider,
NotificationListener,
SipConnectorListener {
    private static transient Logger LOG = Logger.getLogger(Provider.class);
    private JMXConnector jmxc;
    private MBeanServerConnection mbsc;
    private OperatingSystemMXBean osMBean;
    private ObjectName objectName;
    private ArrayList<Connector> connectors;

    public Provider() throws IOException, MalformedObjectNameException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        String urlString = "service:jmx:rmi://localhost:9999/jndi/rmi://localhost:9999/jmxrmi";
        String objectNamePointer = "Sip-Servlets:type=Service";
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("\nCreate an RMI connector client on: " + urlString));
        }
        JMXServiceURL url = new JMXServiceURL(urlString);
        this.jmxc = JMXConnectorFactory.connect(url, null);
        this.mbsc = this.jmxc.getMBeanServerConnection();
        this.osMBean = ManagementFactory.newPlatformMXBeanProxy(this.mbsc, "java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
        this.objectName = new ObjectName(objectNamePointer);
        Set<ObjectName> mbeans = this.mbsc.queryNames(this.objectName, null);
        for (ObjectName mbean : mbeans) {
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Ontree: " + mbean));
            this.readAttributes(this.mbsc, mbean);
            this.readOperations(this.mbsc, mbean);
        }
        this.mbsc.addNotificationListener(this.objectName, (NotificationListener)this, null, null);
    }

    private void readAttributes(MBeanServerConnection mBeanServer, ObjectName http) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        MBeanInfo info = mBeanServer.getMBeanInfo(http);
        MBeanAttributeInfo[] attrInfo = info.getAttributes();
        LOG.debug((Object)("Attributes for object: " + http + ":\n"));
        for (MBeanAttributeInfo attr : attrInfo) {
            LOG.debug((Object)(" -- Attribute " + attr.getName()));
        }
    }

    private void readOperations(MBeanServerConnection mBeanServer, ObjectName http) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        MBeanInfo info = mBeanServer.getMBeanInfo(http);
        MBeanOperationInfo[] operInfo = info.getOperations();
        LOG.debug((Object)("Operations for object: " + http + ":\n"));
        for (MBeanOperationInfo oper : operInfo) {
            LOG.debug((Object)(" -- Operation --- " + oper.getName()));
        }
    }

    public boolean removeSipConnector(String ipAddress, int port, String transport) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Boolean stat = (Boolean)this.mbsc.invoke(this.objectName, "removeSipConnector", new Object[]{ipAddress, port, transport}, new String[]{String.class.getCanonicalName(), Integer.TYPE.getCanonicalName(), String.class.getCanonicalName()});
        return stat;
    }

    public boolean addSipConnector(String ipAddress, int port, String transport) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        SipConnector sipConnector = new SipConnector();
        sipConnector.setIpAddress(ipAddress);
        sipConnector.setPort(port);
        sipConnector.setTransport(transport);
        Boolean stat = (Boolean)this.mbsc.invoke(this.objectName, "addSipConnector", new Object[]{sipConnector}, new String[]{SipConnector.class.getCanonicalName()});
        return stat;
    }

    public List<Connector> getConnectors() {
        try {
            SipConnector[] sipConnectors = (SipConnector[])this.mbsc.invoke(this.objectName, "findSipConnectors", null, null);
            for (int i = 0; i < sipConnectors.length; ++i) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SipConnector " + sipConnectors[i]));
                }
                NetworkPoint point = NetworkManager.getNetworkPointByIpAddress((String)sipConnectors[i].getIpAddress());
                Connector connector = new Connector(sipConnectors[i].getPort(), Connector.Transport.getValueOf((String)sipConnectors[i].getTransport()), point.getId(), Connector.State.DOWN);
                this.connectors.add(connector);
            }
        }
        catch (InstanceNotFoundException e) {
            LOG.error((Object)e);
        }
        catch (MBeanException e) {
            LOG.error((Object)e);
        }
        catch (ReflectionException e) {
            LOG.error((Object)e);
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
        return this.connectors;
    }

    public void traceSipConnectors() throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        SipConnector[] sipConnectors = (SipConnector[])this.mbsc.invoke(this.objectName, "findSipConnectors", null, null);
        for (int i = 0; i < sipConnectors.length; ++i) {
            System.out.println(sipConnectors[i]);
            LOG.info((Object)sipConnectors[i]);
        }
    }

    public void close() throws IOException {
        this.jmxc.close();
    }

    public int getCPULoadAverage() {
        return (int)(this.osMBean.getSystemCpuLoad() * 100.0);
    }

    public int getMemoryUsage() {
        long free = this.osMBean.getFreePhysicalMemorySize();
        long total = this.osMBean.getTotalPhysicalMemorySize();
        int used = (int)((double)(total - free) / (double)total * 100.0);
        return used;
    }

    public static void main(String[] argv) {
        try {
            Provider m = new Provider();
            System.out.println("CPU " + m.getCPULoadAverage());
            System.out.println("MEM " + m.getMemoryUsage());
            m.close();
        }
        catch (IOException | InstanceNotFoundException | IntrospectionException | MalformedObjectNameException | ReflectionException e) {
            LOG.error((Object)"ERROR", (Throwable)e);
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        LOG.info((Object)("Notification " + notification + " callback " + handback));
    }

    public void onKeepAliveTimeout(SipConnector arg0, String arg1, int arg2) {
    }

    public void sipConnectorAdded(SipConnector arg0) {
        LOG.info((Object)("ADDED " + arg0));
    }

    public void sipConnectorRemoved(SipConnector arg0) {
        LOG.info((Object)("REMOVED " + arg0));
    }
}

